# coding=utf8

import fluent.syntax.ast as FTL
from fluent.migrate import COPY, PLURALS, REPLACE_IN_TEXT
from fluent.migrate.helpers import EXTERNAL_ARGUMENT


def migrate(ctx):
    """Migrate about:download in Firefox for Android, part {index}"""

    ctx.add_transforms('mobile/about_downloads.ftl', 'about_downloads.ftl', [
        FTL.Message(
            id=FTL.Identifier('title'),
            value=COPY(
                'mobile/android/chrome/aboutDownloads.dtd',
                'aboutDownloads.title'
            )
        ),
        FTL.Message(
            id=FTL.Identifier('header'),
            value=COPY(
                'mobile/android/chrome/aboutDownloads.dtd',
                'aboutDownloads.header'
            )
        ),
        FTL.Message(
            id=FTL.Identifier('empty'),
            value=COPY(
                'mobile/android/chrome/aboutDownloads.dtd',
                'aboutDownloads.empty'
            )
        ),
        FTL.Message(
            id=FTL.Identifier('open-menuitem'),
            attributes=[
                FTL.Attribute(
                    FTL.Identifier('label'),
                    COPY(
                        'mobile/android/chrome/aboutDownloads.dtd',
                        'aboutDownloads.open'
                    )
                )
            ]
        ),
        FTL.Message(
            id=FTL.Identifier('retry-menuitem'),
            attributes=[
                FTL.Attribute(
                    FTL.Identifier('label'),
                    COPY(
                        'mobile/android/chrome/aboutDownloads.dtd',
                        'aboutDownloads.retry'
                    )
                )
            ]
        ),
        FTL.Message(
            id=FTL.Identifier('remove-menuitem'),
            attributes=[
                FTL.Attribute(
                    FTL.Identifier('label'),
                    COPY(
                        'mobile/android/chrome/aboutDownloads.dtd',
                        'aboutDownloads.remove'
                    )
                )
            ]
        ),
        FTL.Message(
            id=FTL.Identifier('pause-menuitem'),
            attributes=[
                FTL.Attribute(
                    FTL.Identifier('label'),
                    COPY(
                        'mobile/android/chrome/aboutDownloads.dtd',
                        'aboutDownloads.pause'
                    )
                )
            ]
        ),
        FTL.Message(
            id=FTL.Identifier('resume-menuitem'),
            attributes=[
                FTL.Attribute(
                    FTL.Identifier('label'),
                    COPY(
                        'mobile/android/chrome/aboutDownloads.dtd',
                        'aboutDownloads.resume'
                    )
                )
            ]
        ),
        FTL.Message(
            id=FTL.Identifier('cancel-menuitem'),
            attributes=[
                FTL.Attribute(
                    FTL.Identifier('label'),
                    COPY(
                        'mobile/android/chrome/aboutDownloads.dtd',
                        'aboutDownloads.cancel'
                    )
                )
            ]
        ),
        FTL.Message(
            id=FTL.Identifier('remove-all-menuitem'),
            attributes=[
                FTL.Attribute(
                    FTL.Identifier('label'),
                    COPY(
                        'mobile/android/chrome/aboutDownloads.dtd',
                        'aboutDownloads.removeAll'
                    )
                )
            ]
        ),
        FTL.Message(
            id=FTL.Identifier('delete-all-title'),
            value=COPY(
                'mobile/android/chrome/aboutDownloads.properties',
                'downloadAction.deleteAll'
            )
        ),
        FTL.Message(
            id=FTL.Identifier('delete-all-message'),
            value=PLURALS(
                'mobile/android/chrome/aboutDownloads.properties',
                'downloadMessage.deleteAll',
                EXTERNAL_ARGUMENT('num'),
                lambda text: REPLACE_IN_TEXT(
                    text,
                    {
                        '#1': EXTERNAL_ARGUMENT('num')
                    }
                )
            )
        ),
        FTL.Message(
            id=FTL.Identifier('download-state-downloading'),
            value=COPY(
                'mobile/android/chrome/aboutDownloads.properties',
                'downloadState.downloading'
            )
        ),
        FTL.Message(
            id=FTL.Identifier('download-state-canceled'),
            value=COPY(
                'mobile/android/chrome/aboutDownloads.properties',
                'downloadState.canceled'
            )
        ),
        FTL.Message(
            id=FTL.Identifier('download-state-failed'),
            value=COPY(
                'mobile/android/chrome/aboutDownloads.properties',
                'downloadState.failed'
            )
        ),
        FTL.Message(
            id=FTL.Identifier('download-state-paused'),
            value=COPY(
                'mobile/android/chrome/aboutDownloads.properties',
                'downloadState.paused'
            )
        ),
        FTL.Message(
            id=FTL.Identifier('download-state-starting'),
            value=COPY(
                'mobile/android/chrome/aboutDownloads.properties',
                'downloadState.starting'
            )
        ),
        FTL.Message(
            id=FTL.Identifier('download-size-unknown'),
            value=COPY(
                'mobile/android/chrome/aboutDownloads.properties',
                'downloadState.unknownSize'
            )
        ),
    ])
