/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing;

import com.sun.java.swing.FocusManager;
import com.sun.java.swing.JComponent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.util.Vector;

public class DefaultFocusManager
extends FocusManager {
    public void processKeyEvent(Component component, KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 9 || keyEvent.getKeyChar() == '\t') {
            JComponent jComponent;
            if (component instanceof JComponent && (jComponent = (JComponent)component).isManagingFocus() && (keyEvent.getModifiers() & 2) != 2) {
                return;
            }
            if (keyEvent.getID() != 401) {
                keyEvent.consume();
                return;
            }
            if ((keyEvent.getModifiers() & 1) == 1) {
                this.focusPreviousComponent(component);
            } else {
                this.focusNextComponent(component);
            }
            keyEvent.consume();
        }
    }

    public void focusNextComponent(Component component) {
        Component component2;
        JComponent jComponent;
        Container container;
        if (component instanceof JComponent && (container = this.getFocusRoot(jComponent = (JComponent)component)) != null && (component2 = this.getFocusableComponentAfter(jComponent, container, true)) != null) {
            if (component2 instanceof JComponent) {
                ((JComponent)component2).grabFocus();
                return;
            }
            component2.requestFocus();
        }
    }

    public void focusPreviousComponent(Component component) {
        Component component2;
        JComponent jComponent;
        Container container;
        if (component instanceof JComponent && (container = this.getFocusRoot(jComponent = (JComponent)component)) != null && (component2 = this.getFocusableComponentAfter(jComponent, container, false)) != null) {
            if (component2 instanceof JComponent) {
                ((JComponent)component2).grabFocus();
                return;
            }
            component2.requestFocus();
        }
    }

    Container getFocusRoot(Component component) {
        Container container = component.getParent();
        while (container != null) {
            if (container instanceof JComponent && ((JComponent)container).isFocusCycleRoot() || container instanceof Window || container instanceof Dialog) {
                return container;
            }
            container = container.getParent();
        }
        return null;
    }

    private Component getFocusableComponentAfter(Component component, Container container, boolean bl) {
        Component component2;
        Component component3 = component2 = component;
        while (!((component3 = bl ? this.getNextComponent(component3, container, true) : this.getPreviousComponent(component3, container)) == null || component3 == component2 || component3.isVisible() && component3.isFocusTraversable() && component3.isEnabled())) {
        }
        return component3;
    }

    private Component getNextComponent(Component component, Container container, boolean bl) {
        Component component2 = null;
        if (bl && component.isVisible() && (component instanceof JComponent && !((JComponent)component).isManagingFocus() || !(component instanceof JComponent)) && component instanceof Container && ((Container)component).getComponentCount() > 0) {
            return this.getFirstComponent((Container)component);
        }
        Container container2 = component.getParent();
        component2 = this.getComponentAfter(container2, component);
        if (component2 != null) {
            return component2;
        }
        if (container2 == container) {
            return container;
        }
        return this.getNextComponent(container2, container, false);
    }

    private Component getPreviousComponent(Component component, Container container) {
        Container container2 = component.getParent();
        if (component == container) {
            return this.getDeepestLastComponent(container);
        }
        Component component2 = this.getComponentBefore(container2, component);
        if (component2 != null) {
            return this.getDeepestLastComponent(component2);
        }
        return container2;
    }

    private Component getDeepestLastComponent(Component component) {
        if (component.isVisible() && (component instanceof JComponent && !((JComponent)component).isManagingFocus() || !(component instanceof JComponent)) && component instanceof Container && ((Container)component).getComponentCount() > 0) {
            return this.getDeepestLastComponent(this.getLastComponent((Container)component));
        }
        return component;
    }

    public Component getFirstComponent(Container container) {
        Component[] componentArray = this.childrenTabOrder(container);
        if (componentArray.length > 0) {
            return componentArray[0];
        }
        return null;
    }

    public Component getLastComponent(Container container) {
        Component[] componentArray = this.childrenTabOrder(container);
        if (componentArray.length > 0) {
            return componentArray[componentArray.length - 1];
        }
        return null;
    }

    public Component getComponentBefore(Container container, Component component) {
        Component[] componentArray = this.childrenTabOrder(container);
        int n = 1;
        int n2 = componentArray.length;
        while (n < n2) {
            if (componentArray[n] == component) {
                return componentArray[n - 1];
            }
            ++n;
        }
        return null;
    }

    public Component getComponentAfter(Container container, Component component) {
        Component[] componentArray = this.childrenTabOrder(container);
        int n = 0;
        int n2 = componentArray.length - 1;
        while (n < n2) {
            if (componentArray[n] == component) {
                return componentArray[n + 1];
            }
            ++n;
        }
        return null;
    }

    public boolean compareTabOrder(Component component, Component component2) {
        int n;
        int n2;
        Rectangle rectangle;
        int n3;
        int n4;
        if (component instanceof JComponent) {
            n4 = ((JComponent)component).getY();
            n3 = ((JComponent)component).getX();
        } else {
            rectangle = component.getBounds();
            n4 = rectangle.y;
            n3 = rectangle.x;
        }
        if (component2 instanceof JComponent) {
            n2 = ((JComponent)component2).getY();
            n = ((JComponent)component2).getX();
        } else {
            rectangle = component2.getBounds();
            n2 = rectangle.y;
            n = rectangle.x;
        }
        if (Math.abs(n4 - n2) < 10) {
            return n3 < n;
        }
        return n4 < n2;
    }

    Component[] childrenTabOrder(Container container) {
        Component[] componentArray = container.getComponents();
        boolean bl = false;
        int n = 0;
        int n2 = componentArray.length;
        while (n < n2) {
            if (!bl && componentArray[n] instanceof JComponent && ((JComponent)componentArray[n]).getNextFocusableComponent() != null) {
                bl = true;
            }
            int n3 = n;
            while (n3 < n2) {
                if (n != n3 && this.compareTabOrder(componentArray[n3], componentArray[n])) {
                    Component component = componentArray[n];
                    componentArray[n] = componentArray[n3];
                    componentArray[n3] = component;
                }
                ++n3;
            }
            ++n;
        }
        if (bl) {
            Vector<Component> vector = new Vector<Component>(n2);
            n = 0;
            while (n < n2) {
                vector.addElement(componentArray[n]);
                ++n;
            }
            n = 0;
            while (n < n2) {
                int n4;
                Component component;
                if (componentArray[n] instanceof JComponent && (component = ((JComponent)componentArray[n]).getNextFocusableComponent()) != null && (n4 = vector.indexOf(component)) != -1) {
                    vector.removeElementAt(n4);
                    vector.insertElementAt(component, n + 1);
                }
                ++n;
            }
            n = 0;
            while (n < n2) {
                componentArray[n] = (Component)vector.elementAt(n);
                ++n;
            }
        }
        return componentArray;
    }
}

