/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing;

import com.sun.java.accessibility.Accessible;
import com.sun.java.accessibility.AccessibleComponent;
import com.sun.java.accessibility.AccessibleContext;
import com.sun.java.accessibility.AccessibleRole;
import com.sun.java.accessibility.AccessibleState;
import com.sun.java.accessibility.AccessibleStateSet;
import com.sun.java.swing.JComponent;
import com.sun.java.swing.JLayeredPane;
import com.sun.java.swing.JMenuBar;
import com.sun.java.swing.JRootPane;
import com.sun.java.swing.RootPaneContainer;
import com.sun.java.swing.SwingUtilities;
import com.sun.java.swing.UIManager;
import com.sun.java.swing.WindowConstants;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import java.util.Locale;
import java.util.Vector;

public class JFrame
extends Frame
implements WindowConstants,
Accessible,
RootPaneContainer {
    private int defaultCloseOperation = 1;
    protected JRootPane rootPane;
    protected boolean rootPaneCheckingEnabled = false;
    protected AccessibleContext accessibleContext;

    public JFrame() {
        this.frameInit();
    }

    public JFrame(String string) {
        super(string);
        this.frameInit();
    }

    protected void frameInit() {
        this.enableEvents(72L);
        this.setRootPane(this.createRootPane());
        ((Component)this).setBackground(UIManager.getColor("control"));
        this.setRootPaneCheckingEnabled(true);
    }

    protected JRootPane createRootPane() {
        return new JRootPane();
    }

    protected void processKeyEvent(KeyEvent keyEvent) {
        super.processKeyEvent(keyEvent);
        if (!keyEvent.isConsumed()) {
            JComponent.processKeyBindingsForAllComponents(keyEvent, this, new Vector(), keyEvent.getID() == 401);
        }
    }

    protected void processWindowEvent(WindowEvent windowEvent) {
        super.processWindowEvent(windowEvent);
        if (windowEvent.getID() == 201) {
            switch (this.defaultCloseOperation) {
                case 1: {
                    ((Component)this).setVisible(false);
                    return;
                }
                case 2: {
                    ((Component)this).setVisible(false);
                    this.dispose();
                    return;
                }
            }
        }
    }

    public void setDefaultCloseOperation(int n) {
        this.defaultCloseOperation = n;
    }

    public int getDefaultCloseOperation() {
        return this.defaultCloseOperation;
    }

    public void update(Graphics graphics) {
        ((Container)this).paint(graphics);
    }

    public void setJMenuBar(JMenuBar jMenuBar) {
        this.getRootPane().setMenuBar(jMenuBar);
    }

    public JMenuBar getJMenuBar() {
        return this.getRootPane().getMenuBar();
    }

    protected boolean isRootPaneCheckingEnabled() {
        return this.rootPaneCheckingEnabled;
    }

    protected void setRootPaneCheckingEnabled(boolean bl) {
        this.rootPaneCheckingEnabled = bl;
    }

    private Error createRootPaneException(String string) {
        String string2 = this.getClass().getName();
        return new Error("Do not use " + string2 + "." + string + "() use " + string2 + ".getContentPane()." + string + "() instead");
    }

    protected void addImpl(Component component, Object object, int n) {
        if (this.isRootPaneCheckingEnabled()) {
            throw this.createRootPaneException("add");
        }
        super.addImpl(component, object, n);
    }

    public void setLayout(LayoutManager layoutManager) {
        if (this.isRootPaneCheckingEnabled()) {
            throw this.createRootPaneException("setLayout");
        }
        super.setLayout(layoutManager);
    }

    public JRootPane getRootPane() {
        return this.rootPane;
    }

    protected void setRootPane(JRootPane jRootPane) {
        if (this.rootPane != null) {
            this.remove(this.rootPane);
        }
        this.rootPane = jRootPane;
        if (this.rootPane != null) {
            boolean bl = this.isRootPaneCheckingEnabled();
            try {
                this.setRootPaneCheckingEnabled(false);
                this.add((Component)this.rootPane, "Center");
                return;
            }
            finally {
                Object var4_3 = null;
                this.setRootPaneCheckingEnabled(bl);
            }
        }
    }

    public Container getContentPane() {
        return this.getRootPane().getContentPane();
    }

    public void setContentPane(Container container) {
        this.getRootPane().setContentPane(container);
    }

    public JLayeredPane getLayeredPane() {
        return this.getRootPane().getLayeredPane();
    }

    public void setLayeredPane(JLayeredPane jLayeredPane) {
        this.getRootPane().setLayeredPane(jLayeredPane);
    }

    public Component getGlassPane() {
        return this.getRootPane().getGlassPane();
    }

    public void setGlassPane(Component component) {
        this.getRootPane().setGlassPane(component);
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJFrame();
        }
        return this.accessibleContext;
    }

    protected class AccessibleJFrame
    extends AccessibleContext
    implements Serializable,
    AccessibleComponent {
        public String getAccessibleName() {
            if (this.accessibleName != null) {
                return this.accessibleName;
            }
            if (JFrame.this.getTitle() == null) {
                return super.getAccessibleName();
            }
            return JFrame.this.getTitle();
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.FRAME;
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet accessibleStateSet = SwingUtilities.getAccessibleStateSet(JFrame.this);
            if (JFrame.this.isResizable()) {
                accessibleStateSet.add(AccessibleState.RESIZABLE);
            }
            if (JFrame.this.getFocusOwner() != null) {
                accessibleStateSet.add(AccessibleState.ACTIVE);
            }
            return accessibleStateSet;
        }

        public Accessible getAccessibleParent() {
            Container container = JFrame.this.getParent();
            if (container instanceof Accessible) {
                return (Accessible)((Object)container);
            }
            return null;
        }

        public int getAccessibleIndexInParent() {
            return SwingUtilities.getAccessibleIndexInParent(JFrame.this);
        }

        public int getAccessibleChildrenCount() {
            return SwingUtilities.getAccessibleChildrenCount(JFrame.this);
        }

        public Accessible getAccessibleChild(int n) {
            return SwingUtilities.getAccessibleChild(JFrame.this, n);
        }

        public Locale getLocale() {
            return JFrame.this.getLocale();
        }

        public AccessibleComponent getAccessibleComponent() {
            return this;
        }

        public Color getBackground() {
            return ((Component)JFrame.this).getBackground();
        }

        public void setBackground(Color color) {
            ((Component)JFrame.this).setBackground(color);
        }

        public Color getForeground() {
            return JFrame.this.getForeground();
        }

        public void setForeground(Color color) {
            JFrame.this.setForeground(color);
        }

        public Cursor getCursor() {
            return JFrame.this.getCursor();
        }

        public void setCursor(Cursor cursor) {
            ((Component)JFrame.this).setCursor(cursor);
        }

        public Font getFont() {
            return JFrame.this.getFont();
        }

        public void setFont(Font font) {
            ((Component)JFrame.this).setFont(font);
        }

        public FontMetrics getFontMetrics(Font font) {
            return JFrame.this.getFontMetrics(font);
        }

        public boolean isEnabled() {
            return JFrame.this.isEnabled();
        }

        public void setEnabled(boolean bl) {
            JFrame.this.setEnabled(bl);
        }

        public boolean isVisible() {
            return JFrame.this.isVisible();
        }

        public void setVisible(boolean bl) {
            ((Component)JFrame.this).setVisible(bl);
        }

        public boolean isShowing() {
            return JFrame.this.isShowing();
        }

        public boolean contains(Point point) {
            return JFrame.this.contains(point);
        }

        public Point getLocationOnScreen() {
            return JFrame.this.getLocationOnScreen();
        }

        public Point getLocation() {
            return JFrame.this.getLocation();
        }

        public void setLocation(Point point) {
            ((Component)JFrame.this).setLocation(point);
        }

        public Rectangle getBounds() {
            return JFrame.this.getBounds();
        }

        public void setBounds(Rectangle rectangle) {
            ((Component)JFrame.this).setBounds(rectangle);
        }

        public Dimension getSize() {
            return JFrame.this.getSize();
        }

        public void setSize(Dimension dimension) {
            ((Component)JFrame.this).setSize(dimension);
        }

        public Accessible getAccessibleAt(Point point) {
            int n = this.getAccessibleChildrenCount();
            int n2 = 0;
            while (n2 < n) {
                AccessibleComponent accessibleComponent;
                AccessibleContext accessibleContext;
                Accessible accessible = this.getAccessibleChild(n2);
                if (accessible != null && (accessibleContext = accessible.getAccessibleContext()) != null && (accessibleComponent = accessibleContext.getAccessibleComponent()) != null && accessibleComponent.isShowing()) {
                    Point point2 = accessibleComponent.getLocation();
                    Point point3 = new Point(point.x - point2.x, point.y - point2.y);
                    if (accessibleComponent.contains(point3)) {
                        return accessible;
                    }
                }
                ++n2;
            }
            return JFrame.this;
        }

        public boolean isFocusTraversable() {
            return JFrame.this.isFocusTraversable();
        }

        public void requestFocus() {
            JFrame.this.requestFocus();
        }

        public void addFocusListener(FocusListener focusListener) {
            JFrame.this.addFocusListener(focusListener);
        }

        public void removeFocusListener(FocusListener focusListener) {
            JFrame.this.removeFocusListener(focusListener);
        }

        AccessibleJFrame() {
            JFrame.this = JFrame.this;
        }
    }
}

