/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing;

import com.sun.java.swing.JLayeredPane;
import com.sun.java.swing.JRootPane;
import com.sun.java.swing.RepaintManager;
import com.sun.java.swing.SwingUtilities;
import com.sun.java.swing.Timer;
import com.sun.java.swing.TimerQueue;
import java.awt.AWTEvent;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.image.ImageObserver;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

class SystemEventQueueUtilities {
    private static boolean checkedSystemEventQueue;
    private static EventQueue systemEventQueue;
    private static Hashtable rootTable;

    static void queueComponentWorkRequest(Component component) {
        boolean bl;
        ComponentWorkRequest componentWorkRequest = (ComponentWorkRequest)rootTable.get(component);
        boolean bl2 = bl = componentWorkRequest == null;
        if (bl) {
            componentWorkRequest = new ComponentWorkRequest(component);
        }
        ComponentWorkRequest componentWorkRequest2 = componentWorkRequest;
        synchronized (componentWorkRequest2) {
            if (bl) {
                rootTable.put(component, componentWorkRequest);
            }
            if (!componentWorkRequest.isPending) {
                SwingUtilities.invokeLater(componentWorkRequest);
                componentWorkRequest.isPending = true;
            }
            return;
        }
    }

    static synchronized void addRunnableCanvas(JRootPane jRootPane) {
        if (jRootPane.getClientProperty("defeatSystemEventQueueCheck") != null) {
            checkedSystemEventQueue = true;
        }
        if (!checkedSystemEventQueue) {
            SystemEventQueueUtilities.initSystemEventQueue();
        }
        if (systemEventQueue != null) {
            return;
        }
        JLayeredPane jLayeredPane = jRootPane.getLayeredPane();
        if (jLayeredPane != null) {
            RunnableCanvas runnableCanvas = new RunnableCanvas(jRootPane);
            jLayeredPane.add(runnableCanvas);
        }
    }

    static synchronized void removeRunnableCanvas(JRootPane jRootPane) {
        rootTable.remove(SwingUtilities.getRoot(jRootPane));
        RunnableCanvas.remove(jRootPane);
    }

    static Exception postRunnable(Runnable runnable, Object object) {
        if (!checkedSystemEventQueue) {
            SystemEventQueueUtilities.initSystemEventQueue();
        }
        RunnableEvent runnableEvent = new RunnableEvent(runnable, object);
        if (systemEventQueue != null) {
            systemEventQueue.postEvent(runnableEvent);
        } else {
            SystemEventQueueUtilities.postRunnableCanvasEvent(runnableEvent);
        }
        return runnableEvent.exception;
    }

    static synchronized void restartTimerQueueThread() {
        if (systemEventQueue == null) {
            TimerQueueRestart timerQueueRestart = new TimerQueueRestart();
            RunnableEvent runnableEvent = new RunnableEvent(timerQueueRestart, null);
            RunnableCanvas.postRunnableEventToAll(runnableEvent);
        }
    }

    private static synchronized void initSystemEventQueue() {
        if (!checkedSystemEventQueue) {
            try {
                try {
                    systemEventQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
                }
                catch (SecurityException securityException) {
                    System.err.println("Swing: checked access to system event queue.");
                }
                Object var1 = null;
                checkedSystemEventQueue = true;
                return;
            }
            catch (Throwable throwable) {
                Object var1_1 = null;
                checkedSystemEventQueue = true;
                throw throwable;
            }
        }
    }

    private static void processRunnableEvent(RunnableEvent runnableEvent) {
        Object object = runnableEvent.lock;
        if (object == null) {
            runnableEvent.doRun.run();
            return;
        }
        Object object2 = object;
        synchronized (object2) {
            try {
                try {
                    runnableEvent.doRun.run();
                }
                catch (Exception exception) {
                    runnableEvent.exception = exception;
                }
                Object var5_4 = null;
                if (runnableEvent.lock != null) {
                    runnableEvent.lock.notify();
                }
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                if (runnableEvent.lock != null) {
                    runnableEvent.lock.notify();
                }
                throw throwable;
            }
            return;
        }
    }

    private static synchronized void postRunnableCanvasEvent(RunnableEvent runnableEvent) {
        RunnableCanvas runnableCanvas = RunnableCanvas.lookup(runnableEvent);
        if (runnableCanvas == null) {
            if (runnableEvent.doRun instanceof ComponentWorkRequest) {
                ComponentWorkRequest componentWorkRequest;
                ComponentWorkRequest componentWorkRequest2 = componentWorkRequest = (ComponentWorkRequest)runnableEvent.doRun;
                synchronized (componentWorkRequest2) {
                    componentWorkRequest.isPending = false;
                }
            }
            if (runnableEvent.doRun instanceof Timer.DoPostEvent) {
                ((Timer.DoPostEvent)runnableEvent.doRun).getTimer().eventQueued = false;
            }
            if (runnableEvent.lock != null) {
                runnableEvent.lock.notify();
            }
            return;
        }
        runnableCanvas.addRunnableEvent(runnableEvent);
        runnableCanvas.repaint();
    }

    SystemEventQueueUtilities() {
    }

    static {
        systemEventQueue = null;
        rootTable = new Hashtable(4);
        if (SwingUtilities.is1dot2) {
            System.err.println("warning: running 1.1 version of SystemEventQueueUtilities");
        }
    }

    private static class ComponentWorkRequest
    implements Runnable {
        boolean isPending;
        Component component;

        ComponentWorkRequest(Component component) {
            this.component = component;
        }

        public void run() {
            RepaintManager repaintManager;
            ComponentWorkRequest componentWorkRequest = this;
            synchronized (componentWorkRequest) {
                repaintManager = RepaintManager.currentManager(this.component);
                this.isPending = false;
            }
            repaintManager.validateInvalidComponents();
            repaintManager.paintDirtyRegions();
        }
    }

    private static class TimerQueueRestart
    implements Runnable {
        boolean attemptedStart;

        public synchronized void run() {
            if (!this.attemptedStart) {
                TimerQueue timerQueue;
                TimerQueue timerQueue2 = timerQueue = TimerQueue.sharedInstance();
                synchronized (timerQueue2) {
                    if (!timerQueue.running) {
                        timerQueue.start();
                    }
                }
                this.attemptedStart = true;
            }
        }

        TimerQueueRestart() {
        }
    }

    private static class RunnableEvent
    extends AWTEvent {
        static final int EVENT_ID = 2999;
        static final Component target = new RunnableTarget();
        final Runnable doRun;
        final Object lock;
        Exception exception;

        RunnableEvent(Runnable runnable, Object object) {
            super(target, 2999);
            this.doRun = runnable;
            this.lock = object;
        }
    }

    private static class RunnableTarget
    extends Component {
        RunnableTarget() {
            this.enableEvents(2999L);
        }

        protected void processEvent(AWTEvent aWTEvent) {
            if (aWTEvent instanceof RunnableEvent) {
                SystemEventQueueUtilities.processRunnableEvent((RunnableEvent)aWTEvent);
            }
        }
    }

    private static class RunnableCanvas
    extends Canvas {
        private static final Graphics nullGraphics = new RunnableCanvasGraphics();
        private static Hashtable runnableCanvasTable = new Hashtable(1);
        private Vector runnableEvents = new Vector(2);
        private boolean isRegistered = false;

        RunnableCanvas(JRootPane jRootPane) {
            this.setBounds(0, 0, 1, 1);
            if (runnableCanvasTable.get(Thread.currentThread()) == null) {
                try {
                    runnableCanvasTable.put(Thread.currentThread(), this);
                    runnableCanvasTable.put(new Thread().getThreadGroup(), this);
                    if (SwingUtilities.isEventDispatchThread()) {
                        this.isRegistered = true;
                    }
                }
                catch (Exception exception) {
                    System.err.println("Can't register RunnableCanvas");
                    exception.printStackTrace();
                }
            }
            runnableCanvasTable.put(jRootPane, this);
            this.maybeRegisterEventDispatchThread();
        }

        private void maybeRegisterEventDispatchThread() {
            if (!this.isRegistered) {
                RunnableCanvas runnableCanvas = this;
                synchronized (runnableCanvas) {
                    if (!this.isRegistered && SwingUtilities.isEventDispatchThread()) {
                        Thread thread = Thread.currentThread();
                        if (runnableCanvasTable.get(thread) != null) {
                            this.isRegistered = true;
                        } else {
                            runnableCanvasTable.put(thread, this);
                            runnableCanvasTable.put(new Thread().getThreadGroup(), this);
                            this.isRegistered = true;
                        }
                    }
                    return;
                }
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        static RunnableCanvas lookup(RunnableEvent runnableEvent) {
            Object k;
            ThreadGroup threadGroup;
            if (runnableEvent.doRun instanceof ComponentWorkRequest) {
                ComponentWorkRequest componentWorkRequest;
                ComponentWorkRequest componentWorkRequest2 = componentWorkRequest = (ComponentWorkRequest)runnableEvent.doRun;
                synchronized (componentWorkRequest2) {
                    JRootPane jRootPane = SwingUtilities.getRootPane(componentWorkRequest.component);
                    if (jRootPane != null) {
                        return (RunnableCanvas)runnableCanvasTable.get(jRootPane);
                    }
                    componentWorkRequest.isPending = false;
                    return null;
                }
            }
            Object v = runnableCanvasTable.get(Thread.currentThread());
            if (v != null) {
                return (RunnableCanvas)v;
            }
            try {
                threadGroup = Thread.currentThread().getThreadGroup();
            }
            catch (SecurityException securityException) {
                return null;
            }
            RunnableCanvas runnableCanvas = (RunnableCanvas)runnableCanvasTable.get(threadGroup);
            if (runnableCanvas != null) return runnableCanvas;
            Enumeration enumeration = runnableCanvasTable.keys();
            if (enumeration == null) {
                return null;
            }
            do {
                if (!enumeration.hasMoreElements()) return runnableCanvas;
            } while (!((k = enumeration.nextElement()) instanceof JRootPane) || !((JRootPane)k).isShowing());
            return (RunnableCanvas)runnableCanvasTable.get(k);
        }

        static void postRunnableEventToAll(RunnableEvent runnableEvent) {
            ThreadGroup threadGroup;
            try {
                threadGroup = new Thread().getThreadGroup();
            }
            catch (SecurityException securityException) {
                threadGroup = null;
            }
            RunnableCanvas runnableCanvas = threadGroup != null ? (RunnableCanvas)runnableCanvasTable.get(threadGroup) : null;
            Enumeration enumeration = runnableCanvasTable.keys();
            while (enumeration.hasMoreElements()) {
                Object v;
                Object k = enumeration.nextElement();
                if (!(k instanceof JRootPane) || (v = runnableCanvasTable.get(k)) == runnableCanvas) continue;
                RunnableCanvas runnableCanvas2 = (RunnableCanvas)v;
                runnableCanvas2.addRunnableEvent(runnableEvent);
                runnableCanvas2.repaint();
            }
        }

        static void remove(JRootPane jRootPane) {
            RunnableCanvas runnableCanvas = (RunnableCanvas)runnableCanvasTable.get(jRootPane);
            if (runnableCanvas != null) {
                int n;
                Object object;
                RunnableCanvas runnableCanvas2 = null;
                JLayeredPane jLayeredPane = jRootPane.getLayeredPane();
                jLayeredPane.remove(runnableCanvas);
                Enumeration enumeration = runnableCanvasTable.keys();
                while (enumeration.hasMoreElements()) {
                    object = enumeration.nextElement();
                    Object v = runnableCanvasTable.get(object);
                    if (runnableCanvas == v) {
                        runnableCanvasTable.remove(object);
                        continue;
                    }
                    if (runnableCanvas2 != null) continue;
                    runnableCanvas2 = (RunnableCanvas)v;
                }
                object = runnableCanvas.getRunnableCanvasEvents();
                int n2 = n = object == null ? 0 : ((RunnableEvent[])object).length;
                if (n > 0) {
                    if (runnableCanvas2 != null) {
                        int n3 = 0;
                        while (n3 < n) {
                            RunnableEvent runnableEvent = object[n3];
                            if (runnableEvent.doRun instanceof Timer.DoPostEvent) {
                                runnableCanvas2.addRunnableEvent(runnableEvent);
                            }
                            ++n3;
                        }
                        runnableCanvas2.repaint();
                        return;
                    }
                    int n4 = 0;
                    while (n4 < n) {
                        RunnableEvent runnableEvent = object[n4];
                        if (runnableEvent.doRun instanceof Timer.DoPostEvent) {
                            ((Timer.DoPostEvent)runnableEvent.doRun).getTimer().eventQueued = false;
                        }
                        ++n4;
                    }
                }
            }
        }

        public boolean isShowing() {
            return this.runnableEvents.size() > 0;
        }

        public Graphics getGraphics() {
            return nullGraphics;
        }

        public Dimension getPreferredSize() {
            return new Dimension(1, 1);
        }

        synchronized void addRunnableEvent(RunnableEvent runnableEvent) {
            this.runnableEvents.addElement(runnableEvent);
        }

        private synchronized RunnableEvent[] getRunnableCanvasEvents() {
            int n = this.runnableEvents.size();
            if (n == 0) {
                return null;
            }
            RunnableEvent[] runnableEventArray = new RunnableEvent[n];
            int n2 = 0;
            while (n2 < n) {
                runnableEventArray[n2] = (RunnableEvent)this.runnableEvents.elementAt(n2);
                ++n2;
            }
            this.runnableEvents.removeAllElements();
            return runnableEventArray;
        }

        public void paint(Graphics graphics) {
            this.maybeRegisterEventDispatchThread();
        }

        public void update(Graphics graphics) {
            RunnableEvent[] runnableEventArray = this.getRunnableCanvasEvents();
            if (runnableEventArray != null) {
                int n = 0;
                while (n < runnableEventArray.length) {
                    SystemEventQueueUtilities.processRunnableEvent(runnableEventArray[n]);
                    ++n;
                }
            }
        }
    }

    private static class RunnableCanvasGraphics
    extends Graphics {
        public Graphics create() {
            return this;
        }

        public Rectangle getClipBounds() {
            return new Rectangle(0, 0, Short.MAX_VALUE, Short.MAX_VALUE);
        }

        public Shape getClip() {
            return this.getClipBounds();
        }

        public void dispose() {
        }

        public void translate(int n, int n2) {
        }

        public Color getColor() {
            return Color.black;
        }

        public void setColor(Color color) {
        }

        public void setPaintMode() {
        }

        public void setXORMode(Color color) {
        }

        public Font getFont() {
            return null;
        }

        public void setFont(Font font) {
        }

        public FontMetrics getFontMetrics(Font font) {
            return null;
        }

        public void clipRect(int n, int n2, int n3, int n4) {
        }

        public void setClip(int n, int n2, int n3, int n4) {
        }

        public void setClip(Shape shape) {
        }

        public void copyArea(int n, int n2, int n3, int n4, int n5, int n6) {
        }

        public void drawLine(int n, int n2, int n3, int n4) {
        }

        public void fillRect(int n, int n2, int n3, int n4) {
        }

        public void clearRect(int n, int n2, int n3, int n4) {
        }

        public void drawRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        }

        public void fillRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        }

        public void drawOval(int n, int n2, int n3, int n4) {
        }

        public void fillOval(int n, int n2, int n3, int n4) {
        }

        public void drawArc(int n, int n2, int n3, int n4, int n5, int n6) {
        }

        public void fillArc(int n, int n2, int n3, int n4, int n5, int n6) {
        }

        public void drawPolyline(int[] nArray, int[] nArray2, int n) {
        }

        public void drawPolygon(int[] nArray, int[] nArray2, int n) {
        }

        public void fillPolygon(int[] nArray, int[] nArray2, int n) {
        }

        public void drawString(String string, int n, int n2) {
        }

        public boolean drawImage(Image image, int n, int n2, ImageObserver imageObserver) {
            return false;
        }

        public boolean drawImage(Image image, int n, int n2, int n3, int n4, ImageObserver imageObserver) {
            return false;
        }

        public boolean drawImage(Image image, int n, int n2, Color color, ImageObserver imageObserver) {
            return false;
        }

        public boolean drawImage(Image image, int n, int n2, int n3, int n4, Color color, ImageObserver imageObserver) {
            return false;
        }

        public boolean drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, ImageObserver imageObserver) {
            return false;
        }

        public boolean drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Color color, ImageObserver imageObserver) {
            return false;
        }

        RunnableCanvasGraphics() {
        }
    }
}

