/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.border;

import com.sun.java.swing.border.AbstractBorder;
import com.sun.java.swing.border.Border;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;

public class LineBorder
extends AbstractBorder {
    private static Border blackLine;
    private static Border grayLine;
    protected int thickness;
    protected Color lineColor;
    protected boolean roundedCorners;

    public static Border createBlackLineBorder() {
        if (blackLine == null) {
            blackLine = new LineBorder(Color.black, 1);
        }
        return blackLine;
    }

    public static Border createGrayLineBorder() {
        if (grayLine == null) {
            grayLine = new LineBorder(Color.gray, 1);
        }
        return grayLine;
    }

    public LineBorder(Color color) {
        this(color, 1, false);
    }

    public LineBorder(Color color, int n) {
        this(color, n, false);
    }

    LineBorder(Color color, int n, boolean bl) {
        this.lineColor = color;
        this.thickness = n;
        this.roundedCorners = bl;
    }

    public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        Color color = graphics.getColor();
        graphics.setColor(this.lineColor);
        int n5 = 0;
        while (n5 < this.thickness) {
            if (!this.roundedCorners) {
                graphics.drawRect(n + n5, n2 + n5, n3 - n5 - n5 - 1, n4 - n5 - n5 - 1);
            } else {
                graphics.drawRoundRect(n + n5, n2 + n5, n3 - n5 - n5 - 1, n4 - n5 - n5 - 1, this.thickness, this.thickness);
            }
            ++n5;
        }
        graphics.setColor(color);
    }

    public Insets getBorderInsets(Component component) {
        return new Insets(this.thickness, this.thickness, this.thickness, this.thickness);
    }

    public Color getLineColor() {
        return this.lineColor;
    }

    public int getThickness() {
        return this.thickness;
    }

    public boolean isBorderOpaque() {
        return true;
    }
}

