/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.basic;

import com.sun.java.swing.AbstractButton;
import com.sun.java.swing.ButtonModel;
import com.sun.java.swing.Icon;
import com.sun.java.swing.JComponent;
import com.sun.java.swing.JMenu;
import com.sun.java.swing.JMenuBar;
import com.sun.java.swing.JMenuItem;
import com.sun.java.swing.KeyStroke;
import com.sun.java.swing.SwingUtilities;
import com.sun.java.swing.UIManager;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;

public class BasicGraphicsUtils {
    public static final Font controlFont = new Font("Dialog", 0, 12);
    public static Color control = Color.lightGray;
    public static Color controlShadow = Color.gray;
    public static Color controlHighlight = Color.white;
    public static Color controlBlack = Color.black;
    public static Color controlWhite = Color.white;
    public static Color scrollbarTrack = new Color(224, 224, 224);
    public static Color toolTip = new Color(255, 255, 225);
    private static final Insets GROOVE_INSETS = new Insets(2, 2, 2, 2);
    private static final Insets ETCHED_INSETS = new Insets(2, 2, 2, 2);

    public static void drawEtchedRect(Graphics graphics, int n, int n2, int n3, int n4) {
        Color color = graphics.getColor();
        graphics.translate(n, n2);
        graphics.setColor(controlShadow);
        graphics.drawLine(0, 0, n3 - 1, 0);
        graphics.drawLine(0, 1, 0, n4 - 2);
        graphics.setColor(controlBlack);
        graphics.drawLine(1, 1, n3 - 3, 1);
        graphics.drawLine(1, 2, 1, n4 - 3);
        graphics.setColor(controlWhite);
        graphics.drawLine(n3 - 1, 0, n3 - 1, n4 - 1);
        graphics.drawLine(0, n4 - 1, n3 - 1, n4 - 1);
        graphics.setColor(control);
        graphics.drawLine(n3 - 2, 1, n3 - 2, n4 - 3);
        graphics.drawLine(1, n4 - 2, n3 - 3, n4 - 2);
        graphics.translate(-n, -n2);
        graphics.setColor(color);
    }

    public static Insets getEtchedInsets() {
        return ETCHED_INSETS;
    }

    public static void drawGroove(Graphics graphics, int n, int n2, int n3, int n4) {
        Color color = graphics.getColor();
        graphics.translate(n, n2);
        graphics.setColor(controlShadow);
        graphics.drawRect(0, 0, n3 - 2, n4 - 2);
        graphics.setColor(controlWhite);
        graphics.drawLine(1, n4 - 3, 1, 1);
        graphics.drawLine(1, 1, n3 - 3, 1);
        graphics.drawLine(0, n4 - 1, n3 - 1, n4 - 1);
        graphics.drawLine(n3 - 1, n4 - 1, n3 - 1, 0);
        graphics.translate(-n, -n2);
        graphics.setColor(color);
    }

    public static Insets getGrooveInsets() {
        return GROOVE_INSETS;
    }

    public static void drawBezel(Graphics graphics, int n, int n2, int n3, int n4, boolean bl, boolean bl2) {
        Color color = graphics.getColor();
        graphics.translate(n, n2);
        if (bl) {
            if (bl2) {
                graphics.setColor(controlBlack);
                graphics.drawRect(0, 0, n3 - 1, n4 - 1);
            }
            graphics.setColor(controlShadow);
            graphics.drawRect(1, 1, n3 - 3, n4 - 3);
            return;
        }
        if (bl2) {
            graphics.setColor(controlBlack);
            graphics.drawRect(0, 0, n3 - 1, n4 - 1);
            graphics.setColor(controlHighlight);
            graphics.drawLine(1, 1, 1, n4 - 3);
            graphics.drawLine(2, 1, n3 - 4, 1);
            graphics.setColor(controlShadow);
            graphics.drawLine(2, n4 - 3, n3 - 3, n4 - 3);
            graphics.drawLine(n3 - 3, 1, n3 - 3, n4 - 4);
            graphics.setColor(Color.black);
            graphics.drawLine(1, n4 - 2, n3 - 2, n4 - 2);
            graphics.drawLine(n3 - 2, n4 - 2, n3 - 2, 1);
        } else {
            graphics.setColor(controlHighlight);
            graphics.drawLine(0, 0, 0, n4 - 1);
            graphics.drawLine(1, 0, n3 - 3, 0);
            graphics.setColor(controlShadow);
            graphics.drawLine(1, n4 - 2, n3 - 2, n4 - 2);
            graphics.drawLine(n3 - 2, 0, n3 - 2, n4 - 3);
            graphics.setColor(Color.black);
            graphics.drawLine(0, n4 - 1, n3 - 1, n4 - 1);
            graphics.drawLine(n3 - 1, n4 - 1, n3 - 1, 0);
        }
        graphics.translate(-n, -n2);
        graphics.setColor(color);
    }

    public static void drawLoweredBezel(Graphics graphics, int n, int n2, int n3, int n4) {
        graphics.setColor(controlBlack);
        graphics.drawLine(0, 0, 0, n4 - 1);
        graphics.drawLine(1, 0, n3 - 3, 0);
        graphics.setColor(controlShadow);
        graphics.drawLine(1, 1, 1, n4 - 2);
        graphics.drawLine(1, 1, n3 - 3, 1);
        graphics.setColor(controlHighlight);
        graphics.drawLine(0, n4 - 1, n3 - 1, n4 - 1);
        graphics.drawLine(n3 - 1, n4 - 1, n3 - 1, 0);
    }

    public static void drawString(Graphics graphics, String string, int n, int n2, int n3) {
        char[] cArray = new char[1];
        int n4 = -1;
        if (n != 0) {
            cArray[0] = (char)n;
            String string2 = new String(cArray).toUpperCase();
            char c = string2.charAt(0);
            string2 = new String(cArray).toLowerCase();
            char c2 = string2.charAt(0);
            int n5 = string.indexOf(c);
            int n6 = string.indexOf(c2);
            n4 = n5 == -1 ? n6 : (n6 == -1 ? n5 : (n6 < n5 ? n6 : n5));
        }
        graphics.drawString(string, n2, n3);
        if (n4 != -1) {
            FontMetrics fontMetrics = graphics.getFontMetrics();
            Rectangle rectangle = new Rectangle();
            rectangle.x = n2 + fontMetrics.stringWidth(string.substring(0, n4));
            rectangle.y = n3;
            rectangle.width = fontMetrics.charWidth(string.charAt(n4));
            rectangle.height = 1;
            graphics.fillRect(rectangle.x, rectangle.y + fontMetrics.getDescent() - 1, rectangle.width, rectangle.height);
        }
    }

    public static void drawDashedRect(Graphics graphics, int n, int n2, int n3, int n4) {
        int n5 = n;
        while (n5 < n + n3) {
            graphics.drawLine(n5, n2, n5, n2);
            graphics.drawLine(n5, n2 + n4 - 1, n5, n2 + n4 - 1);
            n5 += 2;
        }
        int n6 = n2;
        while (n6 < n2 + n4) {
            graphics.drawLine(n, n6, n, n6);
            graphics.drawLine(n + n3 - 1, n6, n + n3 - 1, n6);
            n6 += 2;
        }
    }

    public static void paintMenuItem(Graphics graphics, JComponent jComponent, Icon icon, Icon icon2, Color color, Color color2, int n) {
        JMenuItem jMenuItem = (JMenuItem)jComponent;
        ButtonModel buttonModel = jMenuItem.getModel();
        Dimension dimension = jMenuItem.getSize();
        Insets insets = jComponent.getInsets();
        Rectangle rectangle = new Rectangle(dimension);
        rectangle.x += insets.left;
        rectangle.y += insets.top;
        rectangle.width -= insets.right + rectangle.x;
        rectangle.height -= insets.bottom + rectangle.y;
        Rectangle rectangle2 = new Rectangle();
        Rectangle rectangle3 = new Rectangle();
        Rectangle rectangle4 = new Rectangle();
        Rectangle rectangle5 = new Rectangle();
        Rectangle rectangle6 = new Rectangle();
        Font font = graphics.getFont();
        Font font2 = jComponent.getFont();
        graphics.setFont(font2);
        FontMetrics fontMetrics = graphics.getFontMetrics(font2);
        FontMetrics fontMetrics2 = graphics.getFontMetrics(UIManager.getFont("MenuItem.acceleratorFont"));
        Color color3 = graphics.getColor();
        if (jComponent.isOpaque()) {
            if (buttonModel.isArmed() || jComponent instanceof JMenu && buttonModel.isSelected()) {
                graphics.setColor(color);
                graphics.fillRect(0, 0, dimension.width, dimension.height);
            } else {
                graphics.setColor(jMenuItem.getBackground());
                graphics.fillRect(0, 0, dimension.width, dimension.height);
            }
            graphics.setColor(color3);
        }
        KeyStroke keyStroke = jMenuItem.getAccelerator();
        String string = "";
        if (keyStroke != null) {
            int n2 = keyStroke.getModifiers();
            if (n2 > 0) {
                string = KeyEvent.getKeyModifiersText(n2);
                string = String.valueOf(string) + "+";
            }
            string = String.valueOf(string) + KeyEvent.getKeyText(keyStroke.getKeyCode());
        }
        String string2 = BasicGraphicsUtils.layoutMenuItem(fontMetrics, jMenuItem.getText(), fontMetrics2, string, jMenuItem.getIcon(), icon, icon2, jMenuItem.getVerticalAlignment(), jMenuItem.getHorizontalAlignment(), jMenuItem.getVerticalTextPosition(), jMenuItem.getHorizontalTextPosition(), rectangle, rectangle2, rectangle3, rectangle4, rectangle5, rectangle6, jMenuItem.getText() == null ? 0 : n, n);
        if (icon != null) {
            if (buttonModel.isArmed() || jComponent instanceof JMenu && buttonModel.isSelected()) {
                graphics.setColor(color2);
            } else {
                graphics.setColor(jMenuItem.getForeground());
            }
            icon.paintIcon(jComponent, graphics, rectangle5.x, rectangle5.y);
            graphics.setColor(color3);
        }
        if (jMenuItem.getIcon() != null) {
            Icon icon3;
            if (!buttonModel.isEnabled()) {
                icon3 = jMenuItem.getDisabledIcon();
            } else if (buttonModel.isPressed() && buttonModel.isArmed()) {
                icon3 = jMenuItem.getPressedIcon();
                if (icon3 == null) {
                    icon3 = jMenuItem.getIcon();
                }
            } else {
                icon3 = jMenuItem.getIcon();
            }
            icon3.paintIcon(jComponent, graphics, rectangle2.x, rectangle2.y);
        }
        if (string2 != null && !string2.equals("")) {
            if (!buttonModel.isEnabled()) {
                if (UIManager.get("MenuItem.disabledForeground") instanceof Color) {
                    graphics.setColor(UIManager.getColor("MenuItem.disabledForeground"));
                    BasicGraphicsUtils.drawString(graphics, string2, buttonModel.getMnemonic(), rectangle3.x, rectangle3.y + fontMetrics.getAscent());
                } else {
                    graphics.setColor(jMenuItem.getBackground().brighter());
                    BasicGraphicsUtils.drawString(graphics, string2, buttonModel.getMnemonic(), rectangle3.x, rectangle3.y + fontMetrics.getAscent());
                    graphics.setColor(jMenuItem.getBackground().darker());
                    BasicGraphicsUtils.drawString(graphics, string2, buttonModel.getMnemonic(), rectangle3.x - 1, rectangle3.y + fontMetrics.getAscent() - 1);
                }
            } else {
                if (buttonModel.isArmed() || jComponent instanceof JMenu && buttonModel.isSelected()) {
                    graphics.setColor(color2);
                } else {
                    graphics.setColor(jMenuItem.getForeground());
                }
                BasicGraphicsUtils.drawString(graphics, string2, buttonModel.getMnemonic(), rectangle3.x, rectangle3.y + fontMetrics.getAscent());
            }
        }
        if (string != null && !string.equals("")) {
            graphics.setFont(UIManager.getFont("MenuItem.acceleratorFont"));
            if (!buttonModel.isEnabled()) {
                if (UIManager.get("MenuItem.disabledForeground") instanceof Color) {
                    graphics.setColor(UIManager.getColor("MenuItem.disabledForeground"));
                    BasicGraphicsUtils.drawString(graphics, string, buttonModel.getMnemonic(), rectangle4.x, rectangle4.y + fontMetrics.getAscent());
                } else {
                    graphics.setColor(jMenuItem.getBackground().brighter());
                    BasicGraphicsUtils.drawString(graphics, string, buttonModel.getMnemonic(), rectangle4.x, rectangle4.y + fontMetrics.getAscent());
                    graphics.setColor(jMenuItem.getBackground().darker());
                    BasicGraphicsUtils.drawString(graphics, string, buttonModel.getMnemonic(), rectangle4.x - 1, rectangle4.y + fontMetrics.getAscent() - 1);
                }
            } else {
                if (buttonModel.isArmed() || jComponent instanceof JMenu && buttonModel.isSelected()) {
                    graphics.setColor(UIManager.getColor("MenuItem.acceleratorPressedForeground"));
                } else {
                    graphics.setColor(UIManager.getColor("MenuItem.acceleratorForeground"));
                }
                BasicGraphicsUtils.drawString(graphics, string, buttonModel.getMnemonic(), rectangle4.x, rectangle4.y + fontMetrics.getAscent());
            }
        }
        if (icon2 != null) {
            if (buttonModel.isArmed() || jComponent instanceof JMenu && buttonModel.isSelected()) {
                graphics.setColor(color2);
            }
            if (!(jMenuItem.getParent() instanceof JMenuBar)) {
                icon2.paintIcon(jComponent, graphics, rectangle6.x, rectangle6.y);
            }
        }
        graphics.setColor(color3);
        graphics.setFont(font);
    }

    public static Dimension getPreferredButtonSize(AbstractButton abstractButton, int n) {
        if (abstractButton.getComponentCount() > 0) {
            return null;
        }
        Icon icon = abstractButton.getIcon();
        String string = abstractButton.getText();
        Font font = abstractButton.getFont();
        FontMetrics fontMetrics = abstractButton.getToolkit().getFontMetrics(font);
        Rectangle rectangle = new Rectangle();
        Rectangle rectangle2 = new Rectangle();
        Rectangle rectangle3 = new Rectangle(Short.MAX_VALUE, Short.MAX_VALUE);
        SwingUtilities.layoutCompoundLabel(fontMetrics, string, icon, abstractButton.getVerticalAlignment(), abstractButton.getHorizontalAlignment(), abstractButton.getVerticalTextPosition(), abstractButton.getHorizontalTextPosition(), rectangle3, rectangle, rectangle2, string == null ? 0 : n);
        Rectangle rectangle4 = rectangle.union(rectangle2);
        Insets insets = abstractButton.getInsets();
        rectangle4.width += insets.left + insets.right;
        rectangle4.height += insets.top + insets.bottom;
        if (rectangle4.width % 2 == 0) {
            ++rectangle4.width;
        }
        if (rectangle4.height % 2 == 0) {
            ++rectangle4.height;
        }
        return rectangle4.getSize();
    }

    public static String layoutMenuItem(FontMetrics fontMetrics, String string, FontMetrics fontMetrics2, String string2, Icon icon, Icon icon2, Icon icon3, int n, int n2, int n3, int n4, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3, Rectangle rectangle4, Rectangle rectangle5, Rectangle rectangle6, int n5, int n6) {
        boolean bl;
        SwingUtilities.layoutCompoundLabel(fontMetrics, string, icon, n, n2, n3, n4, rectangle, rectangle2, rectangle3, n5);
        boolean bl2 = bl = string2 == null || string2.equals("");
        if (bl) {
            rectangle4.height = 0;
            rectangle4.width = 0;
            string2 = "";
        } else {
            rectangle4.width = SwingUtilities.computeStringWidth(fontMetrics2, string2);
            rectangle4.height = fontMetrics2.getHeight();
        }
        if (icon2 != null) {
            rectangle5.width = icon2.getIconWidth();
            rectangle5.height = icon2.getIconHeight();
        } else {
            rectangle5.height = 0;
            rectangle5.width = 0;
        }
        if (icon3 != null) {
            rectangle6.width = icon3.getIconWidth();
            rectangle6.height = icon3.getIconHeight();
        } else {
            rectangle6.height = 0;
            rectangle6.width = 0;
        }
        rectangle3.x += rectangle5.width + n6;
        rectangle2.x += rectangle5.width + n6;
        Rectangle rectangle7 = rectangle2.union(rectangle3);
        rectangle4.x += rectangle.width - rectangle6.width - n6 - rectangle4.width;
        rectangle4.y = rectangle.y + rectangle.height / 2 - rectangle4.height / 2;
        rectangle6.x += rectangle.width - rectangle6.width;
        rectangle6.y = rectangle.y + rectangle7.height / 2 - rectangle6.height / 2;
        rectangle5.y = rectangle.y + rectangle7.height / 2 - rectangle5.height / 2;
        rectangle5.x += rectangle.x;
        return string;
    }

    public static Dimension getPreferredMenuItemSize(JComponent jComponent, Icon icon, Icon icon2, int n) {
        boolean bl;
        JMenuItem jMenuItem = (JMenuItem)jComponent;
        Icon icon3 = jMenuItem.getIcon();
        String string = jMenuItem.getText();
        KeyStroke keyStroke = jMenuItem.getAccelerator();
        String string2 = "";
        if (keyStroke != null) {
            int n2 = keyStroke.getModifiers();
            if (n2 > 0) {
                string2 = KeyEvent.getKeyModifiersText(n2);
                string2 = String.valueOf(string2) + "+";
            }
            string2 = String.valueOf(string2) + KeyEvent.getKeyText(keyStroke.getKeyCode());
        }
        Font font = jMenuItem.getFont();
        FontMetrics fontMetrics = jMenuItem.getToolkit().getFontMetrics(font);
        FontMetrics fontMetrics2 = jMenuItem.getToolkit().getFontMetrics(UIManager.getFont("MenuItem.acceleratorFont"));
        Rectangle rectangle = new Rectangle();
        Rectangle rectangle2 = new Rectangle();
        Rectangle rectangle3 = new Rectangle();
        Rectangle rectangle4 = new Rectangle();
        Rectangle rectangle5 = new Rectangle();
        Rectangle rectangle6 = new Rectangle(Short.MAX_VALUE, Short.MAX_VALUE);
        BasicGraphicsUtils.layoutMenuItem(fontMetrics, string, fontMetrics2, string2, icon3, icon, icon2, jMenuItem.getVerticalAlignment(), jMenuItem.getHorizontalAlignment(), jMenuItem.getVerticalTextPosition(), jMenuItem.getHorizontalTextPosition(), rectangle6, rectangle, rectangle2, rectangle3, rectangle4, rectangle5, string == null ? 0 : n, n);
        Rectangle rectangle7 = rectangle.union(rectangle2);
        boolean bl2 = bl = string2 == null || string2.equals("");
        if (!bl) {
            rectangle7.width += rectangle3.width;
            rectangle7.width += 7 * n;
        }
        rectangle7.width += rectangle4.width;
        rectangle7.width += 2 * n;
        rectangle7.width += 2 * n;
        rectangle7.width += rectangle5.width;
        Insets insets = jMenuItem.getInsets();
        rectangle7.width += insets.left + insets.right;
        rectangle7.height += insets.top + insets.bottom;
        if (rectangle7.width % 2 == 0) {
            ++rectangle7.width;
        }
        if (rectangle7.height % 2 == 0) {
            ++rectangle7.height;
        }
        return rectangle7.getSize();
    }
}

