/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.basic;

import com.sun.java.swing.JButton;
import com.sun.java.swing.JSplitPane;
import com.sun.java.swing.UIManager;
import com.sun.java.swing.border.Border;
import com.sun.java.swing.plaf.basic.BasicSplitPaneUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;

public class BasicSplitPaneDivider
extends Container
implements PropertyChangeListener,
Serializable {
    protected static final int ONE_TOUCH_SIZE = 5;
    protected static final int ONE_TOUCH_OFFSET = 2;
    protected DragController dragger;
    protected BasicSplitPaneUI splitPaneUI;
    protected int dividerSize;
    protected Component hiddenDivider;
    protected JSplitPane splitPane;
    protected MouseHandler mouseHandler;
    protected int orientation;
    protected JButton leftButton;
    protected JButton rightButton;
    static final Cursor horizontalCursor = Cursor.getPredefinedCursor(11);
    static final Cursor verticalCursor = Cursor.getPredefinedCursor(9);
    static final Cursor defaultCursor = Cursor.getPredefinedCursor(0);

    public BasicSplitPaneDivider(BasicSplitPaneUI basicSplitPaneUI) {
        this.setLayout(new DividerLayout());
        this.setBasicSplitPaneUI(basicSplitPaneUI);
        this.orientation = this.splitPane.getOrientation();
        this.setBackground(UIManager.getColor("SplitPane.background"));
    }

    public void setBasicSplitPaneUI(BasicSplitPaneUI basicSplitPaneUI) {
        if (this.splitPane != null) {
            this.splitPane.removePropertyChangeListener(this);
            if (this.mouseHandler != null) {
                this.splitPane.removeMouseListener(this.mouseHandler);
                this.splitPane.removeMouseMotionListener(this.mouseHandler);
                this.mouseHandler = null;
            }
        }
        this.splitPaneUI = basicSplitPaneUI;
        if (basicSplitPaneUI != null) {
            this.splitPane = basicSplitPaneUI.getSplitPane();
            if (this.splitPane != null) {
                if (this.mouseHandler == null) {
                    this.mouseHandler = new MouseHandler();
                }
                this.splitPane.addMouseListener(this.mouseHandler);
                this.splitPane.addMouseMotionListener(this.mouseHandler);
                this.splitPane.addPropertyChangeListener(this);
                if (this.splitPane.isOneTouchExpandable()) {
                    this.oneTouchExpandableChanged();
                    return;
                }
            }
        } else {
            this.splitPane = null;
        }
    }

    public BasicSplitPaneUI getBasicSplitPaneUI() {
        return this.splitPaneUI;
    }

    public void setDividerSize(int n) {
        this.dividerSize = n;
    }

    public int getDividerSize() {
        return this.dividerSize;
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.getDividerSize(), this.getDividerSize());
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getSource() == this.splitPane) {
            if (propertyChangeEvent.getPropertyName().equals("orientation")) {
                this.orientation = this.splitPane.getOrientation();
                this.invalidate();
                this.validate();
                return;
            }
            if (propertyChangeEvent.getPropertyName().equals("oneTouchExpandable")) {
                this.oneTouchExpandableChanged();
            }
        }
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
    }

    protected void oneTouchExpandableChanged() {
        if (this.splitPane.isOneTouchExpandable() && this.leftButton == null && this.rightButton == null) {
            this.leftButton = this.createLeftOneTouchButton();
            if (this.leftButton != null) {
                this.leftButton.addActionListener(new LeftActionListener());
            }
            this.rightButton = this.createRightOneTouchButton();
            if (this.rightButton != null) {
                this.rightButton.addActionListener(new RightActionListener());
            }
            if (this.leftButton != null && this.rightButton != null) {
                this.add(this.leftButton);
                this.add(this.rightButton);
            }
        }
        this.invalidate();
        this.validate();
    }

    protected JButton createLeftOneTouchButton() {
        1 var1_1 = new 1();
        var1_1.setFocusPainted(false);
        var1_1.setBorderPainted(false);
        return var1_1;
    }

    protected JButton createRightOneTouchButton() {
        2 var1_1 = new 2();
        var1_1.setFocusPainted(false);
        var1_1.setBorderPainted(false);
        return var1_1;
    }

    protected void prepareForDragging() {
        this.splitPaneUI.startDragging();
    }

    protected void dragDividerTo(int n) {
        this.splitPaneUI.dragDividerTo(n);
    }

    protected void finishDraggingTo(int n) {
        this.splitPaneUI.finishDraggingTo(n);
    }

    private final class 1
    extends JButton {
        public void setBorder(Border border) {
        }

        public void paint(Graphics graphics) {
            this.getSize();
            if (BasicSplitPaneDivider.this.splitPane != null) {
                int[] nArray = new int[4];
                int[] nArray2 = new int[4];
                int n = Math.min(BasicSplitPaneDivider.this.getDividerSize(), 5);
                if (BasicSplitPaneDivider.this.orientation == 0) {
                    nArray[3] = 0;
                    nArray[0] = 0;
                    nArray[1] = n;
                    nArray[2] = n + n;
                    nArray2[2] = nArray2[3] = n;
                    nArray2[0] = nArray2[3];
                    nArray2[1] = 0;
                } else {
                    nArray[2] = nArray[3] = n;
                    nArray[0] = nArray[3];
                    nArray[1] = 0;
                    nArray2[3] = 0;
                    nArray2[0] = 0;
                    nArray2[1] = n;
                    nArray2[2] = n + n;
                }
                graphics.setColor(Color.black);
                graphics.fillPolygon(nArray, nArray2, 4);
            }
        }

        /* synthetic */ 1() {
        }
    }

    private final class 2
    extends JButton {
        public void setBorder(Border border) {
        }

        public void paint(Graphics graphics) {
            if (BasicSplitPaneDivider.this.splitPane != null) {
                int[] nArray = new int[4];
                int[] nArray2 = new int[4];
                int n = Math.min(BasicSplitPaneDivider.this.getDividerSize(), 5);
                if (BasicSplitPaneDivider.this.orientation == 0) {
                    nArray[3] = 0;
                    nArray[0] = 0;
                    nArray[1] = n;
                    nArray[2] = n + n;
                    nArray2[3] = 0;
                    nArray2[2] = 0;
                    nArray2[0] = 0;
                    nArray2[1] = n;
                } else {
                    nArray[3] = 0;
                    nArray[2] = 0;
                    nArray[0] = 0;
                    nArray[1] = n;
                    nArray2[3] = 0;
                    nArray2[0] = 0;
                    nArray2[1] = n;
                    nArray2[2] = n + n;
                }
                graphics.setColor(Color.black);
                graphics.fillPolygon(nArray, nArray2, 4);
            }
        }

        /* synthetic */ 2() {
        }
    }

    protected class MouseHandler
    extends MouseAdapter
    implements MouseMotionListener,
    Serializable {
        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.getSource() == BasicSplitPaneDivider.this.splitPane && BasicSplitPaneDivider.this.dragger == null && BasicSplitPaneDivider.this.splitPane.isEnabled()) {
                Component component = BasicSplitPaneDivider.this.splitPaneUI.getNonContinuousLayoutDivider();
                if (BasicSplitPaneDivider.this.hiddenDivider != component) {
                    if (BasicSplitPaneDivider.this.hiddenDivider != null) {
                        BasicSplitPaneDivider.this.hiddenDivider.removeMouseListener(this);
                        BasicSplitPaneDivider.this.hiddenDivider.removeMouseMotionListener(this);
                    }
                    BasicSplitPaneDivider.this.hiddenDivider = component;
                    if (BasicSplitPaneDivider.this.hiddenDivider != null) {
                        BasicSplitPaneDivider.this.hiddenDivider.addMouseMotionListener(this);
                        BasicSplitPaneDivider.this.hiddenDivider.addMouseListener(this);
                    }
                }
                if (BasicSplitPaneDivider.this.splitPane.getLeftComponent() != null && BasicSplitPaneDivider.this.splitPane.getRightComponent() != null) {
                    BasicSplitPaneDivider.this.dragger = BasicSplitPaneDivider.this.orientation == 1 ? new DragController(mouseEvent) : new VerticalDragController(mouseEvent);
                    if (!BasicSplitPaneDivider.this.dragger.isValid()) {
                        BasicSplitPaneDivider.this.dragger = null;
                    } else {
                        BasicSplitPaneDivider.this.prepareForDragging();
                        BasicSplitPaneDivider.this.dragger.continueDrag(mouseEvent);
                    }
                }
                mouseEvent.consume();
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (BasicSplitPaneDivider.this.dragger != null) {
                if (mouseEvent.getSource() == BasicSplitPaneDivider.this.splitPane) {
                    BasicSplitPaneDivider.this.dragger.completeDrag(mouseEvent.getX(), mouseEvent.getY());
                } else if (mouseEvent.getSource() == BasicSplitPaneDivider.this.hiddenDivider) {
                    BasicSplitPaneDivider.this.getLocation();
                    Point point = BasicSplitPaneDivider.this.hiddenDivider.getLocation();
                    int n = mouseEvent.getX() + point.x;
                    int n2 = mouseEvent.getY() + point.y;
                    BasicSplitPaneDivider.this.dragger.completeDrag(n, n2);
                }
                BasicSplitPaneDivider.this.dragger = null;
            }
            BasicSplitPaneDivider.this.splitPane.setCursor(defaultCursor);
            mouseEvent.consume();
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            if (BasicSplitPaneDivider.this.dragger != null) {
                if (mouseEvent.getSource() == BasicSplitPaneDivider.this.splitPane) {
                    BasicSplitPaneDivider.this.dragger.continueDrag(mouseEvent.getX(), mouseEvent.getY());
                } else if (mouseEvent.getSource() == BasicSplitPaneDivider.this.hiddenDivider) {
                    BasicSplitPaneDivider.this.getLocation();
                    Point point = BasicSplitPaneDivider.this.hiddenDivider.getLocation();
                    int n = mouseEvent.getX() + point.x;
                    int n2 = mouseEvent.getY() + point.y;
                    BasicSplitPaneDivider.this.dragger.continueDrag(n, n2);
                }
                mouseEvent.consume();
            }
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            block9: {
                block6: {
                    block8: {
                        block7: {
                            if (BasicSplitPaneDivider.this.dragger != null) {
                                return;
                            }
                            int n = mouseEvent.getX();
                            int n2 = mouseEvent.getY();
                            Rectangle rectangle = BasicSplitPaneDivider.this.getBounds();
                            if (n < rectangle.x || n >= rectangle.x + rectangle.width || n2 < rectangle.y || n2 >= rectangle.y + rectangle.height) break block6;
                            if (BasicSplitPaneDivider.this.orientation != 1) break block7;
                            if (BasicSplitPaneDivider.this.splitPane.getCursor() != horizontalCursor) {
                                BasicSplitPaneDivider.this.splitPane.setCursor(horizontalCursor);
                                return;
                            }
                            break block8;
                        }
                        if (BasicSplitPaneDivider.this.splitPane.getCursor() == verticalCursor) break block9;
                        BasicSplitPaneDivider.this.splitPane.setCursor(verticalCursor);
                    }
                    return;
                }
                if (BasicSplitPaneDivider.this.splitPane.getCursor() != defaultCursor) {
                    BasicSplitPaneDivider.this.splitPane.setCursor(defaultCursor);
                }
            }
        }

        MouseHandler() {
            BasicSplitPaneDivider.this = BasicSplitPaneDivider.this;
        }
    }

    protected class DragController
    implements Serializable {
        int initialX;
        int maxX;
        int minX;
        int offset;

        protected DragController(MouseEvent mouseEvent) {
            BasicSplitPaneDivider.this = BasicSplitPaneDivider.this;
            JSplitPane jSplitPane = BasicSplitPaneDivider.this.splitPaneUI.getSplitPane();
            Insets insets = jSplitPane.getInsets();
            int n = insets != null ? insets.right : 0;
            this.initialX = BasicSplitPaneDivider.this.getLocation().x;
            Component component = jSplitPane.getLeftComponent();
            Component component2 = jSplitPane.getRightComponent();
            if (component != null && component2 != null) {
                this.minX = component.getMinimumSize().width + component.getLocation().x;
                this.maxX = Math.max(0, jSplitPane.getSize().width - (2 + BasicSplitPaneDivider.this.getSize().width + n) - component2.getMinimumSize().width);
                if (this.maxX < this.minX) {
                    this.maxX = 0;
                    this.minX = 0;
                }
            } else {
                this.maxX = 0;
                this.minX = 0;
            }
            this.offset = mouseEvent.getX() - this.initialX;
            if (this.offset < -1 || this.offset > BasicSplitPaneDivider.this.getSize().width) {
                this.maxX = -1;
            }
        }

        protected boolean isValid() {
            return this.maxX > 0;
        }

        protected int positionForMouseEvent(MouseEvent mouseEvent) {
            int n = Math.min(this.maxX, Math.max(this.minX, mouseEvent.getX() - this.offset));
            return n;
        }

        protected int getNeededLocation(int n, int n2) {
            int n3 = Math.min(this.maxX, Math.max(this.minX, n - this.offset));
            return n3;
        }

        protected void continueDrag(int n, int n2) {
            BasicSplitPaneDivider.this.dragDividerTo(this.getNeededLocation(n, n2));
        }

        protected void continueDrag(MouseEvent mouseEvent) {
            BasicSplitPaneDivider.this.dragDividerTo(this.positionForMouseEvent(mouseEvent));
        }

        protected void completeDrag(int n, int n2) {
            BasicSplitPaneDivider.this.finishDraggingTo(this.getNeededLocation(n, n2));
        }

        protected void completeDrag(MouseEvent mouseEvent) {
            BasicSplitPaneDivider.this.finishDraggingTo(this.positionForMouseEvent(mouseEvent));
        }
    }

    protected class VerticalDragController
    extends DragController {
        protected VerticalDragController(MouseEvent mouseEvent) {
            super(mouseEvent);
            BasicSplitPaneDivider.this = BasicSplitPaneDivider.this;
            JSplitPane jSplitPane = BasicSplitPaneDivider.this.splitPaneUI.getSplitPane();
            Insets insets = jSplitPane.getInsets();
            int n = insets != null ? insets.bottom : 0;
            this.initialX = BasicSplitPaneDivider.this.getLocation().y;
            Component component = jSplitPane.getLeftComponent();
            Component component2 = jSplitPane.getRightComponent();
            if (component != null && component2 != null) {
                this.minX = component.getMinimumSize().height + component.getLocation().y;
                this.maxX = Math.max(0, jSplitPane.getSize().height - (2 + BasicSplitPaneDivider.this.getSize().height + n) - component2.getMinimumSize().height);
                if (this.maxX < this.minX) {
                    this.maxX = 0;
                    this.minX = 0;
                }
            } else {
                this.maxX = 0;
                this.minX = 0;
            }
            this.offset = mouseEvent.getY() - this.initialX;
            if (this.offset < -1 || this.offset > BasicSplitPaneDivider.this.getSize().height) {
                this.maxX = -1;
            }
        }

        protected int getNeededLocation(int n, int n2) {
            int n3 = Math.min(this.maxX, Math.max(this.minX, n2 - this.offset));
            return n3;
        }

        protected int positionForMouseEvent(MouseEvent mouseEvent) {
            int n = Math.min(this.maxX, Math.max(this.minX, mouseEvent.getY() - this.offset));
            return n;
        }
    }

    protected class DividerLayout
    implements LayoutManager,
    Serializable {
        public void layoutContainer(Container container) {
            if (BasicSplitPaneDivider.this.leftButton != null && BasicSplitPaneDivider.this.rightButton != null && container == BasicSplitPaneDivider.this) {
                if (BasicSplitPaneDivider.this.splitPane.isOneTouchExpandable()) {
                    int n = Math.min(BasicSplitPaneDivider.this.getDividerSize(), 5);
                    if (BasicSplitPaneDivider.this.orientation == 0) {
                        int n2 = (container.getSize().height - n) / 2;
                        BasicSplitPaneDivider.this.leftButton.setBounds(2, n2, n * 2, n);
                        BasicSplitPaneDivider.this.rightButton.setBounds(14, n2, n * 2, n);
                        return;
                    }
                    int n3 = (container.getSize().width - n) / 2;
                    BasicSplitPaneDivider.this.leftButton.setBounds(n3, 2, n, n * 2);
                    BasicSplitPaneDivider.this.rightButton.setBounds(n3, 14, n, n * 2);
                    return;
                }
                BasicSplitPaneDivider.this.leftButton.setBounds(-5, -5, 1, 1);
                BasicSplitPaneDivider.this.rightButton.setBounds(-5, -5, 1, 1);
            }
        }

        public Dimension minimumLayoutSize(Container container) {
            return new Dimension(0, 0);
        }

        public Dimension preferredLayoutSize(Container container) {
            return new Dimension(0, 0);
        }

        public void removeLayoutComponent(Component component) {
        }

        public void addLayoutComponent(String string, Component component) {
        }

        DividerLayout() {
            BasicSplitPaneDivider.this = BasicSplitPaneDivider.this;
        }
    }

    private class LeftActionListener
    implements ActionListener,
    Serializable {
        public void actionPerformed(ActionEvent actionEvent) {
            Insets insets = BasicSplitPaneDivider.this.splitPane.getInsets();
            int n = BasicSplitPaneDivider.this.splitPane.getDividerLocation();
            n += BasicSplitPaneDivider.this.splitPaneUI.getDividerBorderSize();
            if (BasicSplitPaneDivider.this.orientation == 0) {
                if (n >= BasicSplitPaneDivider.this.splitPane.getHeight() - insets.bottom - BasicSplitPaneDivider.this.getDividerSize()) {
                    BasicSplitPaneDivider.this.splitPane.setDividerLocation(BasicSplitPaneDivider.this.splitPane.getLastDividerLocation());
                    return;
                }
                BasicSplitPaneDivider.this.splitPane.setDividerLocation(0);
                return;
            }
            if (n >= BasicSplitPaneDivider.this.splitPane.getWidth() - insets.right - BasicSplitPaneDivider.this.getDividerSize()) {
                BasicSplitPaneDivider.this.splitPane.setDividerLocation(BasicSplitPaneDivider.this.splitPane.getLastDividerLocation());
                return;
            }
            BasicSplitPaneDivider.this.splitPane.setDividerLocation(0);
        }

        LeftActionListener() {
            BasicSplitPaneDivider.this = BasicSplitPaneDivider.this;
        }
    }

    private class RightActionListener
    implements ActionListener,
    Serializable {
        public void actionPerformed(ActionEvent actionEvent) {
            Insets insets = BasicSplitPaneDivider.this.splitPane.getInsets();
            int n = BasicSplitPaneDivider.this.splitPane.getDividerLocation();
            n -= BasicSplitPaneDivider.this.splitPaneUI.getDividerBorderSize();
            if (BasicSplitPaneDivider.this.orientation == 0) {
                if (n == insets.top) {
                    BasicSplitPaneDivider.this.splitPane.setDividerLocation(BasicSplitPaneDivider.this.splitPane.getLastDividerLocation());
                    return;
                }
                BasicSplitPaneDivider.this.splitPane.setDividerLocation(BasicSplitPaneDivider.this.splitPane.getHeight() - insets.bottom);
                return;
            }
            if (n == insets.left) {
                BasicSplitPaneDivider.this.splitPane.setDividerLocation(BasicSplitPaneDivider.this.splitPane.getLastDividerLocation());
                return;
            }
            BasicSplitPaneDivider.this.splitPane.setDividerLocation(BasicSplitPaneDivider.this.splitPane.getWidth() - insets.right);
        }

        RightActionListener() {
            BasicSplitPaneDivider.this = BasicSplitPaneDivider.this;
        }
    }
}

