/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.basic;

import com.sun.java.swing.JComponent;
import com.sun.java.swing.UIManager;
import com.sun.java.swing.plaf.SpinnerUI;
import java.awt.Adjustable;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

public class Spinner
extends JComponent
implements Adjustable,
AdjustmentListener,
FocusListener,
KeyListener,
MouseListener {
    protected String txt;
    protected Dimension d;
    protected int ascent;
    protected int value;
    protected boolean haveFocus = false;
    protected int minValue;
    protected int maxValue = 0x7FFFFF;
    protected FontMetrics fm;
    protected int nDigits = 4;
    protected int digitsTyped;
    protected boolean wraps = false;
    protected boolean borderPainted = false;
    protected Color backgroundColor = Color.white;
    protected int leadingPad = -1;
    public boolean wrapped = false;
    static /* synthetic */ Class class$java$awt$event$AdjustmentListener;

    public Spinner(int n, String string) {
        this.init(n, string);
    }

    public Spinner(int n) {
        this.init(n, null);
    }

    private void init(int n, String string) {
        this.txt = string;
        this.value = n;
        this.addFocusListener(this);
        this.addMouseListener(this);
        this.addKeyListener(this);
        this.updateUI();
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int n) {
        if (this.wraps) {
            this.wrapped = n < this.minValue || n > this.maxValue;
        }
        while (n < this.minValue) {
            n = this.wraps ? this.maxValue + 1 - this.minValue + n : this.minValue;
        }
        while (n > this.maxValue) {
            n = this.wraps ? this.minValue - 1 + n - this.maxValue : this.maxValue;
        }
        if (this.value != n) {
            this.value = n;
            if (this.isShowing()) {
                this.repaint(20L);
            }
            this.fireAdjustmentValueChanged(new AdjustmentEvent(this, 0, 601, n));
        }
    }

    public void setWrap(boolean bl) {
        this.wraps = bl;
    }

    public boolean getWrap() {
        return this.wraps;
    }

    public void setText(String string) {
        this.txt = string;
        if (this.isShowing()) {
            this.repaint(20L);
        }
    }

    public String getText() {
        return this.txt;
    }

    public void setFont(Font font) {
        if (font != this.getFont()) {
            super.setFont(font);
            this.d = null;
            this.invalidate();
        }
    }

    public void setDigits(int n) {
        this.nDigits = n;
    }

    public int getDigits() {
        return this.nDigits;
    }

    public void setLeadingPad(int n) {
        this.leadingPad = n;
    }

    public int getLeadingPad() {
        return this.leadingPad;
    }

    public void setBackgroundColor(Color color) {
        this.backgroundColor = color;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public boolean isFocusTraversable() {
        return true;
    }

    public boolean hasFocus() {
        return this.haveFocus;
    }

    public boolean isBorderPainted() {
        return this.borderPainted;
    }

    public void setBorderPainted(boolean bl) {
        this.borderPainted = bl;
        this.invalidate();
    }

    protected void paintBorder(Graphics graphics) {
        if (this.isBorderPainted()) {
            super.paintBorder(graphics);
        }
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        this.setValue(adjustmentEvent.getValue());
    }

    public void setMinimum(int n) {
        this.minValue = n;
        this.setValue(this.value);
    }

    public int getMinimum() {
        return this.minValue;
    }

    public void setMaximum(int n) {
        this.maxValue = n;
        this.setValue(this.value);
    }

    public int getMaximum() {
        return this.maxValue;
    }

    public void addAdjustmentListener(AdjustmentListener adjustmentListener) {
        this.listenerList.add(class$java$awt$event$AdjustmentListener != null ? class$java$awt$event$AdjustmentListener : (class$java$awt$event$AdjustmentListener = Spinner.class$("java.awt.event.AdjustmentListener")), adjustmentListener);
    }

    public void removeAdjustmentListener(AdjustmentListener adjustmentListener) {
        this.listenerList.remove(class$java$awt$event$AdjustmentListener != null ? class$java$awt$event$AdjustmentListener : (class$java$awt$event$AdjustmentListener = Spinner.class$("java.awt.event.AdjustmentListener")), adjustmentListener);
    }

    protected void fireAdjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$java$awt$event$AdjustmentListener != null ? class$java$awt$event$AdjustmentListener : Spinner.class$("java.awt.event.AdjustmentListener"))) {
                ((AdjustmentListener)objectArray[n + 1]).adjustmentValueChanged(adjustmentEvent);
            }
            n -= 2;
        }
    }

    public void setUnitIncrement(int n) {
    }

    public int getUnitIncrement() {
        return 1;
    }

    public void setBlockIncrement(int n) {
    }

    public int getBlockIncrement() {
        return 1;
    }

    public void setVisibleAmount(int n) {
    }

    public int getVisibleAmount() {
        return 1;
    }

    public int getOrientation() {
        return 0;
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.isActionKey()) {
            switch (keyEvent.getKeyCode()) {
                case 40: {
                    this.setValue(this.value - 1);
                    return;
                }
                case 38: {
                    this.setValue(this.value + 1);
                    return;
                }
                default: {
                    return;
                }
            }
        }
        char c = keyEvent.getKeyChar();
        if (c >= '0' && c <= '9') {
            if (this.digitsTyped < this.nDigits) {
                int n;
                if (this.digitsTyped == 0) {
                    this.value = 0;
                }
                if ((n = this.value * 10 + c - 48) <= this.maxValue && n >= this.minValue) {
                    this.setValue(n);
                    ++this.digitsTyped;
                    return;
                }
            }
        } else {
            switch (c) {
                case '\b': 
                case '\u007f': {
                    this.setValue(this.value / 10);
                    --this.digitsTyped;
                    return;
                }
                case '-': {
                    this.setValue(-this.value);
                    return;
                }
            }
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.requestFocus();
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void focusGained(FocusEvent focusEvent) {
        this.haveFocus = true;
        this.digitsTyped = 0;
        this.repaint();
    }

    public void focusLost(FocusEvent focusEvent) {
        this.haveFocus = false;
        this.repaint();
    }

    public SpinnerUI getUI() {
        return (SpinnerUI)this.ui;
    }

    public void setUI(SpinnerUI spinnerUI) {
        super.setUI(spinnerUI);
    }

    public void updateUI() {
        this.setUI((SpinnerUI)UIManager.getUI(this));
    }

    public String getUIClassID() {
        return "SpinnerUI";
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

