/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.metal;

import com.sun.java.swing.JComponent;
import com.sun.java.swing.UIManager;
import com.sun.java.swing.plaf.ComponentUI;
import com.sun.java.swing.plaf.basic.BasicTreeUI;
import com.sun.java.swing.plaf.basic.LargeTreeModelNode;
import com.sun.java.swing.plaf.basic.VisibleTreeNode;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;

public class MetalTreeUI
extends BasicTreeUI {
    private static Color lineColor;
    private static final String LINE_STYLE = "JTree.lineStyle";
    private static final String LEG_LINE_STYLE_STRING = "Angled";
    private static final String HORIZ_STYLE_STRING = "Horizontal";
    private static final String NO_STYLE_STRING = "None";
    private static final int LEG_LINE_STYLE = 2;
    private static final int HORIZ_LINE_STYLE = 1;
    private static final int NO_LINE_STYLE = 0;
    private int lineStyle = 1;
    private PropertyChangeListener lineStyleListener = new LineListener();

    public static ComponentUI createUI(JComponent jComponent) {
        return new MetalTreeUI();
    }

    protected int getHorizontalLegBuffer() {
        return 4;
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        if (!this.tree.isLargeModel()) {
            this.setRowHeight(0);
        }
        lineColor = UIManager.getColor("Tree.line");
        Object object = jComponent.getClientProperty(LINE_STYLE);
        this.decodeLineStyle(object);
        jComponent.addPropertyChangeListener(this.lineStyleListener);
    }

    public void uninstallUI(JComponent jComponent) {
        jComponent.removePropertyChangeListener(this.lineStyleListener);
        super.uninstallUI(jComponent);
    }

    protected void decodeLineStyle(Object object) {
        if (object == null || object.equals(HORIZ_STYLE_STRING)) {
            this.lineStyle = 1;
            return;
        }
        if (object.equals(LEG_LINE_STYLE_STRING)) {
            this.lineStyle = 2;
            return;
        }
        if (object.equals(NO_STYLE_STRING)) {
            this.lineStyle = 0;
        }
    }

    protected boolean clickedInExpandControl(VisibleTreeNode visibleTreeNode, LargeTreeModelNode largeTreeModelNode, int n, int n2, int n3, int n4) {
        if (visibleTreeNode != null && visibleTreeNode.isLeaf()) {
            return false;
        }
        int n5 = this.getExpandedIcon() != null ? this.getExpandedIcon().getIconWidth() + 6 : 8;
        int n6 = this.getShowsRootHandles() ? n2 * this.totalChildIndent + this.getLeftChildIndent() - n5 / 2 : (n2 - 1) * this.totalChildIndent + this.getLeftChildIndent() - n5 / 2;
        int n7 = n6 + n5;
        return n3 >= n6 && n3 <= n7;
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        super.paint(graphics, jComponent);
        if (this.lineStyle == 1 && !this.largeModel) {
            this.paintHorizontalSeparators(graphics, jComponent);
        }
    }

    protected void paintHorizontalSeparators(Graphics graphics, JComponent jComponent) {
        graphics.setColor(lineColor);
        Rectangle rectangle = graphics.getClipBounds();
        int n = this.getRowContainingYLocation(rectangle.y);
        int n2 = this.getRowContainingYLocation(rectangle.y + (rectangle.height - 1));
        if (n <= -1 || n2 <= -1) {
            return;
        }
        int n3 = n;
        while (n3 <= n2) {
            VisibleTreeNode visibleTreeNode = this.getNode(n3);
            if (visibleTreeNode.getParent() == visibleTreeNode.getRoot()) {
                graphics.drawLine(rectangle.x, this.getNodeY(visibleTreeNode), rectangle.x + rectangle.width, this.getNodeY(visibleTreeNode));
            }
            ++n3;
        }
    }

    public void drawVerticalPartOfLeg(Graphics graphics, JComponent jComponent, int n, int n2, int n3, int n4, int n5) {
        if (this.lineStyle == 2) {
            super.drawVerticalPartOfLeg(graphics, jComponent, n, n2, n3, n4, n5);
        }
    }

    public void drawHorizontalPartOfLeg(Graphics graphics, JComponent jComponent, int n, int n2, int n3) {
        if (this.lineStyle == 2) {
            super.drawHorizontalPartOfLeg(graphics, jComponent, n, n2, n3);
        }
    }

    class LineListener
    implements PropertyChangeListener,
    Serializable {
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals(LINE_STYLE)) {
                MetalTreeUI.this.decodeLineStyle(propertyChangeEvent.getNewValue());
            }
        }

        LineListener() {
            MetalTreeUI.this = MetalTreeUI.this;
        }
    }
}

