/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.preview;

import com.sun.java.swing.ColorChooserPanel;
import com.sun.java.swing.JComponent;
import com.sun.java.swing.JDialog;
import com.sun.java.swing.UIManager;
import com.sun.java.swing.plaf.ColorChooserUI;
import com.sun.java.swing.preview.ColorChooserDialog;
import com.sun.java.swing.preview.ColorTracker;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.io.Serializable;

public class JColorChooser
extends JComponent
implements Serializable {
    public static final String COLOR_PROPERTY = "color";
    private Color color;

    public static Color showDialog(Component component, String string, Color color) {
        JColorChooser jColorChooser = new JColorChooser(color != null ? color : Color.white);
        ColorTracker colorTracker = new ColorTracker(jColorChooser);
        JDialog jDialog = JColorChooser.createDialog(component, string, true, jColorChooser, colorTracker, null);
        jDialog.addWindowListener(new ColorChooserDialog.Closer());
        jDialog.addComponentListener(new ColorChooserDialog.DisposeOnClose());
        jDialog.show();
        return colorTracker.getColor();
    }

    public static JDialog createDialog(Component component, String string, boolean bl, JColorChooser jColorChooser, ActionListener actionListener, ActionListener actionListener2) {
        return new ColorChooserDialog(component, string, bl, jColorChooser, actionListener, actionListener2);
    }

    public JColorChooser() {
        this(Color.white);
    }

    public JColorChooser(Color color) {
        this.updateUI();
        this.setColor(color);
    }

    public ColorChooserUI getUI() {
        return (ColorChooserUI)this.ui;
    }

    public void setUI(ColorChooserUI colorChooserUI) {
        super.setUI(colorChooserUI);
    }

    public void updateUI() {
        this.setUI((ColorChooserUI)UIManager.getUI(this));
    }

    public String getUIClassID() {
        return "ColorChooserUI";
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        if (!color.equals(this.color)) {
            Color color2 = this.color;
            this.color = color;
            this.firePropertyChange(COLOR_PROPERTY, color2, color);
        }
    }

    public void setColor(int n, int n2, int n3) {
        this.setColor(new Color(n, n2, n3));
    }

    public void setColor(int n) {
        this.setColor(n >> 16 & 0xFF, n >> 8 & 0xFF, n & 0xFF);
    }

    public void addChooserPanel(String string, ColorChooserPanel colorChooserPanel) {
        this.getUI().addChooserPanel(string, colorChooserPanel);
    }

    public ColorChooserPanel removeChooserPanel(String string) {
        return this.getUI().removeChooserPanel(string);
    }
}

