/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.text;

import com.sun.java.swing.text.BadLocationException;
import com.sun.java.swing.text.Document;
import com.sun.java.swing.text.Element;
import com.sun.java.swing.text.JTextComponent;
import com.sun.java.swing.text.Segment;
import com.sun.java.swing.text.StyledDocument;
import com.sun.java.swing.text.TabExpander;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.text.BreakIterator;

public class Utilities {
    public static final int drawTabbedText(Segment segment, int n, int n2, Graphics graphics, TabExpander tabExpander, int n3) {
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n4 = n;
        char[] cArray = segment.array;
        int n5 = 0;
        int n6 = segment.offset;
        int n7 = segment.offset + segment.count;
        int n8 = segment.offset;
        while (n8 < n7) {
            if (cArray[n8] == '\t') {
                if (n5 > 0) {
                    graphics.drawChars(cArray, n6, n5, n, n2);
                    n5 = 0;
                }
                n6 = n8 + 1;
                n4 = tabExpander != null ? (int)tabExpander.nextTabStop(n4, n3 + n8 - segment.offset) : (n4 += fontMetrics.charWidth(' '));
                n = n4;
            } else if (cArray[n8] == '\n' || cArray[n8] == '\r') {
                if (n5 > 0) {
                    graphics.drawChars(cArray, n6, n5, n, n2);
                    n5 = 0;
                }
                n6 = n8 + 1;
                n = n4;
            } else {
                ++n5;
                n4 += fontMetrics.charWidth(cArray[n8]);
            }
            ++n8;
        }
        if (n5 > 0) {
            graphics.drawChars(cArray, n6, n5, n, n2);
        }
        return n4;
    }

    public static final int getTabbedTextWidth(Segment segment, FontMetrics fontMetrics, int n, TabExpander tabExpander, int n2) {
        int n3 = n;
        char[] cArray = segment.array;
        int n4 = segment.offset + segment.count;
        int n5 = segment.offset;
        while (n5 < n4) {
            n3 = cArray[n5] == '\t' ? (tabExpander != null ? (int)tabExpander.nextTabStop(n3, n2 + n5 - segment.offset) : (n3 += fontMetrics.charWidth(' '))) : (n3 += fontMetrics.charWidth(cArray[n5]));
            ++n5;
        }
        return n3 - n;
    }

    public static final int getTabbedTextOffset(Segment segment, FontMetrics fontMetrics, int n, int n2, TabExpander tabExpander, int n3) {
        int n4;
        int n5 = n4 = n;
        char[] cArray = segment.array;
        int n6 = segment.offset + segment.count;
        int n7 = segment.offset;
        while (n7 < n6) {
            n5 = cArray[n7] == '\t' ? (tabExpander != null ? (int)tabExpander.nextTabStop(n5, n3 + n7 - segment.offset) : (n5 += fontMetrics.charWidth(' '))) : (n5 += fontMetrics.charWidth(cArray[n7]));
            if (n2 >= n4 && n2 < n5) {
                if (n2 - n4 < n5 - n2) {
                    return n7 - segment.offset;
                }
                return n7 + 1 - segment.offset;
            }
            n4 = n5;
            ++n7;
        }
        return segment.count;
    }

    public static final int getBreakLocation(Segment segment, FontMetrics fontMetrics, int n, int n2, TabExpander tabExpander, int n3) {
        int n4 = Utilities.getTabbedTextOffset(segment, fontMetrics, n, n2, tabExpander, n3);
        int n5 = segment.offset + Math.min(n4, segment.count - 1);
        while (n5 >= segment.offset) {
            char c = segment.array[n5];
            if (Character.isWhitespace(c)) {
                n4 = n5 - segment.offset + 1;
                break;
            }
            --n5;
        }
        return n4;
    }

    public static final int getRowStart(JTextComponent jTextComponent, int n) throws BadLocationException {
        Rectangle rectangle = jTextComponent.modelToView(n);
        int n2 = n;
        int n3 = rectangle.y;
        while (rectangle != null && n3 == rectangle.y) {
            n = n2--;
            Rectangle rectangle2 = rectangle = n2 >= 0 ? jTextComponent.modelToView(n2) : null;
        }
        return n;
    }

    public static final int getRowEnd(JTextComponent jTextComponent, int n) throws BadLocationException {
        Rectangle rectangle = jTextComponent.modelToView(n);
        int n2 = jTextComponent.getDocument().getLength();
        int n3 = n;
        int n4 = rectangle.y;
        while (rectangle != null && n4 == rectangle.y) {
            n = n3++;
            Rectangle rectangle2 = rectangle = n3 <= n2 ? jTextComponent.modelToView(n3) : null;
        }
        return n;
    }

    public static final int getPositionAbove(JTextComponent jTextComponent, int n, int n2) throws BadLocationException {
        int n3 = Utilities.getRowStart(jTextComponent, n) - 1;
        int n4 = Short.MAX_VALUE;
        int n5 = 0;
        Rectangle rectangle = null;
        if (n3 >= 0) {
            rectangle = jTextComponent.modelToView(n3);
            n5 = rectangle.y;
        }
        while (rectangle != null && n5 == rectangle.y) {
            int n6 = Math.abs(rectangle.x - n2);
            if (n6 < n4) {
                n = n3;
                n4 = n6;
            }
            Rectangle rectangle2 = rectangle = --n3 >= 0 ? jTextComponent.modelToView(n3) : null;
        }
        return n;
    }

    public static final int getPositionBelow(JTextComponent jTextComponent, int n, int n2) throws BadLocationException {
        int n3 = Utilities.getRowEnd(jTextComponent, n) + 1;
        int n4 = Short.MAX_VALUE;
        int n5 = jTextComponent.getDocument().getLength();
        int n6 = 0;
        Rectangle rectangle = null;
        if (n3 <= n5) {
            rectangle = jTextComponent.modelToView(n3);
            n6 = rectangle.y;
        }
        while (rectangle != null && n6 == rectangle.y) {
            int n7 = Math.abs(n2 - rectangle.x);
            if (n7 < n4) {
                n = n3;
                n4 = n7;
            }
            Rectangle rectangle2 = rectangle = ++n3 <= n5 ? jTextComponent.modelToView(n3) : null;
        }
        return n;
    }

    public static final int getWordStart(JTextComponent jTextComponent, int n) throws BadLocationException {
        int n2;
        Element element;
        int n3;
        Document document = jTextComponent.getDocument();
        String string = document.getText(n3 = (element = Utilities.getParagraphElement(jTextComponent, n)).getStartOffset(), (n2 = Math.min(element.getEndOffset(), document.getLength())) - n3);
        if (string != null && string.length() > 0) {
            BreakIterator breakIterator = BreakIterator.getWordInstance();
            breakIterator.setText(string);
            int n4 = n - n3;
            if (n4 >= breakIterator.last()) {
                n4 = breakIterator.last() - 1;
            }
            breakIterator.following(n4);
            n = n3 + breakIterator.previous();
        }
        return n;
    }

    public static final int getWordEnd(JTextComponent jTextComponent, int n) throws BadLocationException {
        int n2;
        Element element;
        int n3;
        Document document = jTextComponent.getDocument();
        String string = document.getText(n3 = (element = Utilities.getParagraphElement(jTextComponent, n)).getStartOffset(), (n2 = Math.min(element.getEndOffset(), document.getLength())) - n3);
        if (string != null && string.length() > 0) {
            BreakIterator breakIterator = BreakIterator.getWordInstance();
            breakIterator.setText(string);
            int n4 = n - n3;
            if (n4 >= breakIterator.last()) {
                n4 = breakIterator.last() - 1;
            }
            n = n3 + breakIterator.following(n4);
        }
        return n;
    }

    public static final int getNextWord(JTextComponent jTextComponent, int n) throws BadLocationException {
        int n2;
        Element element;
        int n3;
        Document document = jTextComponent.getDocument();
        String string = document.getText(n3 = (element = Utilities.getParagraphElement(jTextComponent, n)).getStartOffset(), (n2 = Math.min(element.getEndOffset(), document.getLength())) - n3);
        if (string != null && string.length() > 0) {
            BreakIterator breakIterator = BreakIterator.getWordInstance();
            breakIterator.setText(string);
            int n4 = n - n3;
            if (n4 >= breakIterator.last()) {
                n4 = breakIterator.last() - 1;
            }
            breakIterator.following(n4);
            n = n3 + breakIterator.next();
        }
        return n;
    }

    public static final int getPreviousWord(JTextComponent jTextComponent, int n) throws BadLocationException {
        int n2;
        Element element;
        int n3;
        Document document = jTextComponent.getDocument();
        String string = document.getText(n3 = (element = Utilities.getParagraphElement(jTextComponent, n)).getStartOffset(), (n2 = Math.min(element.getEndOffset(), document.getLength())) - n3);
        if (string != null && string.length() > 0) {
            BreakIterator breakIterator = BreakIterator.getWordInstance();
            breakIterator.setText(string);
            int n4 = n - n3;
            if (n4 >= breakIterator.last()) {
                n4 = breakIterator.last() - 1;
            }
            breakIterator.following(n4);
            if (n == n3 + breakIterator.previous()) {
                breakIterator.previous();
                int n5 = breakIterator.previous();
                n = n5 == -1 ? n3 : n3 + n5;
            }
        }
        return n;
    }

    public static final Element getParagraphElement(JTextComponent jTextComponent, int n) {
        Document document = jTextComponent.getDocument();
        if (document instanceof StyledDocument) {
            return ((StyledDocument)document).getParagraphElement(n);
        }
        Element element = document.getDefaultRootElement();
        int n2 = element.getElementIndex(n);
        Element element2 = element.getElement(n2);
        return element2;
    }
}

