/*
 * Decompiled with CFR 0.152.
 */
package base.drawable;

import base.drawable.Category;
import base.drawable.ColorAlpha;
import base.drawable.Coord;
import base.drawable.CoordPixelXform;
import base.drawable.DrawnBoxSet;
import base.drawable.InfoBox;
import base.drawable.NestingStacks;
import base.drawable.TimeBoundingBox;
import base.drawable.Topology;
import java.awt.Graphics2D;
import java.awt.Point;
import java.util.Map;

public abstract class Drawable
extends InfoBox {
    public static final float NON_NESTABLE = 1.0f;
    public static final int INVALID_ROW = Integer.MIN_VALUE;
    private double exclusion;
    private float nesting_ftr;
    private int row_ID;
    private Drawable parent;

    public Drawable() {
        this.exclusion = 0.0;
        this.nesting_ftr = 1.0f;
        this.parent = null;
    }

    public Drawable(Category category) {
        super(category);
        this.exclusion = 0.0;
        this.nesting_ftr = 1.0f;
        this.parent = null;
    }

    public Drawable(Drawable drawable) {
        super(drawable);
        this.exclusion = 0.0;
        this.nesting_ftr = 1.0f;
        this.parent = drawable.parent;
    }

    public Drawable(Category category, Drawable drawable) {
        super(category, drawable);
        this.exclusion = 0.0;
        this.nesting_ftr = 1.0f;
        this.parent = drawable.parent;
    }

    public Drawable(int n, byte[] byArray) {
        super(n);
        super.setInfoBuffer(byArray);
        this.exclusion = 0.0;
        this.nesting_ftr = 1.0f;
        this.parent = null;
    }

    public void initExclusion(Object[] objectArray) {
        this.exclusion = super.getDuration();
        for (int i = objectArray.length - 1; i >= 0; --i) {
            this.exclusion -= super.getIntersectionDuration((TimeBoundingBox)objectArray[i]);
        }
    }

    public void decrementExclusion(double d) {
        this.exclusion -= d;
    }

    public double getExclusion() {
        return this.exclusion;
    }

    public boolean isNestingFactorUninitialized() {
        return this.nesting_ftr == 1.0f;
    }

    public void setNestingFactor(float f) {
        this.nesting_ftr = f;
    }

    public float getNestingFactor() {
        return this.nesting_ftr;
    }

    public boolean isRowIDUninitialized() {
        return this.row_ID == Integer.MIN_VALUE;
    }

    public void setRowID(int n) {
        this.row_ID = n;
    }

    public int getRowID() {
        return this.row_ID;
    }

    public void setParent(Drawable drawable) {
        this.parent = drawable;
    }

    public Drawable getParent() {
        return this.parent;
    }

    public abstract int getNumOfPrimitives();

    public abstract Integer[] getArrayOfLineIDs();

    public abstract Coord getStartVertex();

    public abstract Coord getFinalVertex();

    public abstract int drawState(Graphics2D var1, CoordPixelXform var2, Map var3, DrawnBoxSet var4, ColorAlpha var5);

    public abstract int drawArrow(Graphics2D var1, CoordPixelXform var2, Map var3, DrawnBoxSet var4, ColorAlpha var5);

    public abstract boolean isPixelInState(CoordPixelXform var1, Map var2, Point var3);

    public abstract boolean isPixelOnArrow(CoordPixelXform var1, Map var2, Point var3);

    public abstract boolean containSearchable();

    public void setStateRowAndNesting(CoordPixelXform coordPixelXform, Map map, NestingStacks nestingStacks) {
        Coord coord = this.getStartVertex();
        this.row_ID = (Integer)map.get(new Integer(coord.lineID));
        this.nesting_ftr = nestingStacks.getNestingFactorFor(this);
    }

    public int drawOnCanvas(Graphics2D graphics2D, CoordPixelXform coordPixelXform, Map map, DrawnBoxSet drawnBoxSet) {
        Category category = super.getCategory();
        Topology topology = category.getTopology();
        if (topology.isEvent()) {
            System.err.println("Not yet supported Event Primitive type.");
        } else {
            if (topology.isState()) {
                return this.drawState(graphics2D, coordPixelXform, map, drawnBoxSet, category.getColor());
            }
            if (topology.isArrow()) {
                return this.drawArrow(graphics2D, coordPixelXform, map, drawnBoxSet, category.getColor());
            }
            System.err.println("Non-recognized Primitive type! " + this);
        }
        return 0;
    }

    public Drawable getDrawableAt(CoordPixelXform coordPixelXform, Map map, Point point) {
        Category category = super.getCategory();
        Topology topology = category.getTopology();
        if (topology.isEvent()) {
            System.err.println("Not yet supported Event Primitive type.");
        } else if (topology.isState()) {
            if (this.isPixelInState(coordPixelXform, map, point)) {
                return this;
            }
        } else if (topology.isArrow()) {
            if (this.isPixelOnArrow(coordPixelXform, map, point)) {
                return this;
            }
        } else {
            System.err.println("Non-recognized Primitive type! " + this);
        }
        return null;
    }
}

