/*
 * Decompiled with CFR 0.152.
 */
package viewer.legends;

import base.drawable.Category;
import base.drawable.ColorAlpha;
import base.drawable.Topology;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.Icon;
import viewer.common.Parameters;

public class CategoryIcon
implements Icon {
    public static final CategoryIcon BLANK_ICON = new CategoryIcon();
    private static final int ICON_WIDTH = 35;
    private static final int ICON_HEIGHT = 21;
    private static final int ICON_HALF_WIDTH = 17;
    private static final int ICON_QUARTER_WIDTH = 8;
    private static final int ICON_HALF_HEIGHT = 10;
    private static final int ICON_QUARTER_HEIGHT = 5;
    private static final int XOFF = 3;
    private static final int YOFF = 2;
    private Topology topo;
    private final ColorAlpha color_orig;
    private Color color_shown;

    private CategoryIcon() {
        this.topo = null;
        this.color_orig = null;
        this.color_shown = null;
    }

    public CategoryIcon(Category category) {
        this.topo = category.getTopology();
        this.color_orig = category.getColor();
        this.color_shown = this.color_orig;
    }

    public CategoryIcon(Topology topology, Color color) {
        this.topo = topology;
        this.color_orig = new ColorAlpha(color, 255);
        this.color_shown = color;
    }

    public void setDisplayedColor(Color color) {
        this.color_shown = color;
    }

    public Color getDisplayedColor() {
        return this.color_shown;
    }

    public ColorAlpha getOriginalColor() {
        return this.color_orig;
    }

    public void resetColor() {
        this.color_shown = this.color_orig;
    }

    public int getIconWidth() {
        return 35;
    }

    public int getIconHeight() {
        return 21;
    }

    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        Color color = graphics.getColor();
        if (this.topo != null) {
            if (this.topo.isEvent()) {
                this.paintEventIcon(graphics, n, n2);
            } else if (this.topo.isState()) {
                this.paintStateIcon(graphics, n, n2);
            } else if (this.topo.isArrow()) {
                this.paintArrowIcon(graphics, n, n2);
            } else {
                this.paintBlankIcon(graphics, n, n2);
            }
        } else {
            this.paintBlankIcon(graphics, n, n2);
        }
        graphics.setColor(color);
    }

    private void paintStateIcon(Graphics graphics, int n, int n2) {
        graphics.setColor((Color)Parameters.BACKGROUND_COLOR.toValue());
        graphics.fillRect(n, n2, 35, 21);
        int n3 = n;
        int n4 = n2 + 10;
        int n5 = n + 35 - 1;
        int n6 = n4;
        graphics.setColor(Color.red);
        graphics.drawLine(n3, n4, n5, n6);
        n3 = n + 3;
        n4 = n2 + 2;
        n5 = n3 + 35 - 1 - 6;
        n6 = n4 + 21 - 1 - 4;
        graphics.setColor(this.color_shown);
        graphics.fillRect(n3, n4, 29, 17);
        Parameters.STATE_BORDER.paintStateBorder((Graphics2D)graphics, this.color_shown, n3, n4, true, n5, n6, true);
    }

    private void paintArrowIcon(Graphics graphics, int n, int n2) {
        graphics.setColor((Color)Parameters.BACKGROUND_COLOR.toValue());
        graphics.fillRect(n, n2, 35, 21);
        graphics.setColor(this.color_shown);
        int n3 = n;
        int n4 = n2 + 10;
        int n5 = n + 35 - 1;
        int n6 = n4;
        graphics.drawLine(n3, n4, n5, n6);
        n3 = n5;
        n4 = n6;
        n5 = n3 - 8;
        n6 = n4 + 5;
        int n7 = n5;
        int n8 = n4 - 5;
        graphics.drawLine(n3, n4, n5, n6);
        graphics.drawLine(n3, n4, n7, n8);
        graphics.drawLine(n5, n6, n7, n8);
    }

    private void paintEventIcon(Graphics graphics, int n, int n2) {
        graphics.setColor((Color)Parameters.BACKGROUND_COLOR.toValue());
        graphics.fillRect(n, n2, 35, 21);
        graphics.setColor(this.color_shown);
        int n3 = 6;
        int n4 = n + 17;
        int n5 = n2 + 2;
        int n6 = n + n3;
        int n7 = n2 + 21 - 1 - 2;
        int n8 = n + 35 - 1 - n3;
        int n9 = n7;
        graphics.drawLine(n4, n5, n6, n7);
        graphics.drawLine(n4, n5, n8, n9);
        graphics.drawLine(n6, n7, n8, n9);
    }

    private void paintBlankIcon(Graphics graphics, int n, int n2) {
        graphics.setColor((Color)Parameters.BACKGROUND_COLOR.toValue());
        graphics.fillRect(n, n2, 35, 21);
    }
}

