#
# Copyright (C) 2004 Tenable Network Security 
#
#

if(description)
{
 script_id(12018);
 script_version("$Revision: 1.1 $");

 name["english"] = "POWER SEARCH detection";

 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is using the POWER SEARCH program.  
You should ensure that:
- the user intended to install POWER SEARCH (it is sometimes silently installed)
- the use of POWER SEARCH matches your corporate mandates and security policies.

To remove this sort of software, you may wish to check
out ad-aware or spybot. 

See also : http://pestpatrol.com/PestInfo/p/powersearch.asp 
Solution : Uninstall this software
Risk factor : High";



 script_description(english:desc["english"]);
 
 summary["english"] = "POWER SEARCH detection";

 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Windows";
 script_family(english:family["english"]);
 
 script_dependencies("smb_registry_full_access.nasl");
 script_require_keys("SMB/registry_full_access");

 script_require_ports(139, 445);
 exit(0);
}


# start the script

if ( ! get_kb_item("SMB/registry_full_access") ) exit(0);

path[0] = "software\classes\clsid\{4e7bd74f-2b8d-469e-d3fa-f27ba787ad2d}";
path[1] = "software\microsoft\internet explorer\toolbar\{4e7bd74f-2b8d-469e-d3fa-f27ba787ad2d}";



include("smb_nt.inc");

for (i=0; path[i]; i++) {
    if (key[i]) {
        rootfile = registry_get_sz(key:path[i], item:key[i]);
        if(rootfile) {
           mypattern = string(".*", regx[i], ".*");
           if (egrep(string:rootfile, pattern:mypattern)) {security_hole(kb_smb_transport()); exit(0);}
       }
    } else {
       val = registry_get_acl(key:path[i]);
       if(val != NULL) {security_hole(kb_smb_transport()); exit(0); } 
    } 
}


