#
# **** THIS SCRIPT IS EXPERIMENTAL! ****
#
# (C) 2003 Michel Arboi <mikhail@nessus.org>
#
# Redistribution and use in source, with or without modification, are 
# permitted provided that the following conditions are met:
#
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. All advertising materials mentioning features or use of this software
#    must display the following acknowledgement:
#     This product includes software developed and data gathered by Michel Arboi
#
# This script is not a transcription in NASL of HMAP, which is much 
# more complex. It is only based upon ideas that are described in 
# Dustin Lee's thesis:
# "HMAP: A Technique and Tool For Remote Identification of HTTP Servers
#
# To receive useful contributions, we have to generate a significant 
# signature for unknown servers. This signature should be compact, 
# so only the most significant tests should be selected. An interesting 
# side effect is that the plugin will be quicker!
# As I don't have enough web servers, versions, sub-versions, and strange
# or typical configurations, I run into a chicken & egg problem:
# so we must keep in mind that the test set may change, and the known
# signatures will have to be adapted, or recomputed.
#
# NOTE TO SIGNATURE CONTRIBUTORS
# If you have different servers that return the _same_ signature, this 
# means that the test has to be enhanced. Please download hmap from
# http://ujeni.murkyroc.com/hmap/ and runs it against your servers, and
# send us the generated files.
#
# To look for duplicated signatures, run:
# egrep '^(...:){20,}' www_fingerprinting_hmap.nasl | awk -F: '{print $1,$2,$3,$4,$5,$6,$7,$8,$9,$10,$11,$12,$13,$14,$15,$16,$17,$18,$19,$20,$21,$22,$23,$24,$25; }' | sort | uniq -d
#
# Contributors: 
# Luca Bigliardi, 
# Andrew Brampton, J Barger, Jorge Blat, Randy Bias, Dustin Butler, 
# Lionel Cons, Stephen Davies, Renaud Deraison, Franck Dubray, 
# Joshua Fielden, Tomasz Finke, 
# Stephen Flanagan, Dennis Freise, Scott Fringer, 
# Chris Hanson, Chris Harrington,
# John T Hoffoss, Imre Klczi, Boris Karnaukh, Eddie Kilgore, 
# Paul Kurczaba, Sbastien Louafi, Tarmo Lindstrm, Florin Mariuteac, 
# Mats Martinsson, Ashesh Patel, Xavier Poli,
# Matthew Pour, Jason Radley, Thomas Reinke, Jon Repaci, Michael Scheidell, 
# Beat Siegenthaler, Marco Spoel, Robby Tanner, Ralph Utz, Bruce Wright, 
# Jeffrey Yu,
# Andrew Ziem, 
# PoiS QueM, Crowley, Munkhbayar, Neo, Sullo, Yong, Zube
# If I forgot you in this list or mispelled your name (or nym), please tell me!
# 
if (description)
{
  script_version("$Revision: 1.136 $");
  script_id(11919);
#  script_cve_id("CVE-MAP-NOMATCH");
  name["english"] = "HMAP";
  script_name(english:name["english"]);

  desc["english"] = "
This script tries to identify the HTTP Server type and version by
sending more or less incorrect requests.

An attacker may use this to identify the kind of the remote web server
and gain further knowledge about this host.

Suggestions for defense against fingerprinting are presented in
http://acsac.org/2002/abstracts/96.html

See also :	http://ujeni.murkyroc.com/hmap/
		http://seclab.cs.ucdavis.edu/papers/hmap-thesis.pdf
		
Risk factor : Low";

  script_description(english:desc["english"]);
 
  summary["english"] = "Fingerprints the web server";
  script_summary(english:summary["english"]);
 
  script_category(ACT_MIXED_ATTACK);
 
  script_copyright(english:"This script is Copyright (C) 2003 Michel Arboi - HMAP research by Dustin Lee");
  family["english"] = "General";
  script_family(english:family["english"]);

  script_dependencie("find_service.nes", "http_login.nasl", "httpver.nasl", "no404.nasl");
  script_require_ports("Services/www", 80);
  exit(0);

}

#### Fingerprints
# The last field is the name of the server, the previous field is the regex
# that the "Server" field is supposed to match.
# If the regex field is empty, the last field MUST be equal to the banner
#
# +++ is a joker than matches anything (useful when we add requests)
# --- means no answer
# HTM means that the server returned HTML directly, without any clean HTTP 
# answer code & headers.
# VER means that the server answered with an invalid HTTP version, e.g.:
#    HTTP/3.14 
#    HTTP/1.X 
#    HTTP/
#    http/1.0
# Note that this last code was added recently, and that previous signature
# may contain xxx instead in 4th, 5th, 6th or 8th position, or a valid 
# numeric code only in 6th or 8th position in some rare cases (when the 
# server answered with HTTP/ or http/1.0 in lower case) 
# 

fingerprints = "
# There are two Abyss web server...
# from abyss.sourceforge.net
200:200:400:505:400:400:500:400:400:200:500:500:200:400:400:400:200:405:405:405:200:405:405:405:400::ABYSS/0.3
# from www.aprelium.com
HTM:200:HTM:505:HTM:HTM:HTM:HTM:HTM:200:HTM:HTM:200:HTM:HTM:HTM:200:404:404:404:404:404:404:404:200::Abyss/1.2.1.0 (Linux) AbyssLib/1.0.7
200:200:---:200:200:200:200:---:200:200:200:200:200:200:200:+++:200:404:---:---:---:---:---:---:+++::ADSM_HTTP/0.1
200:200:400:200:200:200:400:200:200:400:400:400:200:200:200:200:200:501:501:400:400:400:400:400:+++:^Agent-ListenServer-HttpSvr/1\.0$:McAfee ePolicy Orchestrator Agent version 3.1.0.211
200:200:400:200:200:200:400:200:200:400:400:400:200:200:200:400:200:501:501:400:400:400:400:400:400:^Agent-ListenServer-HttpSvr/1\.0$:McAfee ePolicy Orchestrator Agent version 3.1.1.186
200:200:---:200:200:200:---:200:200:200:---:---:200:200:200:---:200:---:---:---:---:---:---:---:+++::Apt-proxy 1.2.9.2
# AXIS 540+/542+ Network Print Server V6.00 Jul  5 1999.
# AXIS 540+/542+ print servers with OS versions of V5.55 and V5.51
# have the same signature.
400:200:400:200:200:200:400:200:200:200:400:400:200:200:200:404:200:404:400:400:400:400:400:400:+++:.*:AXIS 540+/542+ Network Print Server
200:200:501:HTM:HTM:HTM:501:501:HTM:501:501:501:200:400:400:400:200:404:501:501:501:501:501:501:+++:.*:AXIS 205 version 4.03 Webcam
404:200:---:200:200:200:---:200:200:200:---:---:---:404:404:+++:200:404:---:---:---:---:---:---:+++::3ware/1.0
# Device: Efficient 5865 DMT-ISDN Router (5865-002) v5.3.90 Ready
xxx:200:400:505:400:400:400:200:400:200:400:400:200:400:400:400:200:404:404:404:404:404:404:404:+++::Agranat-EmWeb/R4_01
# Agranat-EmWeb/R5_2_6
# Virata-EmWeb/R6_2_1
HTM:200:200:505:400:400:400:200:400:200:400:400:200:400:400:+++:400:404:404:404:404:200:404:404:+++:^(Agranat|Virata)-EmWeb/R[56]_2_[16]:Agranat-EmWeb/R5_2_6 or Virata-EmWeb/R6_2_1
xxx:200:200:505:400:400:400:200:400:200:400:400:200:400:400:400:400:404:404:404:404:200:404:404:+++::Virata-EmWeb/R6_0_1
HTM:200:200:505:400:400:400:200:400:200:400:400:200:400:400:400:400:405:405:405:200:200:405:405:+++:Virata-EmWeb/R5_3_0:Cisco VPN 3000 Concentrator Series Manager (Virata-EmWeb/R5_3_0)
HTM:200:200:505:400:400:400:200:400:200:400:400:---:400:400:+++:400:404:404:404:404:200:404:404:+++::Virata-EmWeb/R6_2_1
HTM:---:200:505:400:400:400:200:400:200:400:400:---:400:400:+++:400:404:404:404:404:200:404:404:+++::Virata-EmWeb/R6_2_1
# AOL application server
HTM:200:404:200:HTM:HTM:400:HTM:HTM:200:400:400:200:404:200:+++:200:404:404:404:404:404:404:404:200:AOLserver/3\.[45]\.:AOLserver/3.4.2 or 3.5.6
HTM:200:404:200:HTM:HTM:---:HTM:HTM:200:---:---:200:200:200:+++:+++:404:404:404:404:404:404:404:+++:AOLserver/4\.:AOLserver/4.0
# Apache2 on Linux Gentoo (2.0.46, 2.0.47, 2.0.47-r1, 2.0.48-r1, 2.0.48) 
# Apache/2.0.48 (Unix) PHP/4.3.4 mod_python/3.1.2b Python/2.3.2
HTM:200:200:200:200:200:HTM:501:200:200:HTM:HTM:200:400:400:+++:400:404:405:405:200:200:405:501:200:^Apache(/2(\.0(\.4[678])?)?)?:Apache/2.0.46-48 (Gentoo/Linux?)
# Apache 2.0.48 on Gentoo, with DAV enabled
# Apache/2.0.40 (Unix) DAV/2 PHP/4.3.3
HTM:200:200:200:200:200:HTM:501:200:200:HTM:HTM:200:400:400:+++:400:404:405:405:200:200:405:405:200:Apache(/2(\.0(\.4[0-8]( +\((Gentoo/Linux|Unix)\)( +DAV/2.*)?)?)?)?)?$:Apache/2.0.4x with DAV/2 on Linux
# Same signature as above??
# Apache/2.0.40 (Red Hat Linux)
# Apache/2.0.47 (Unix) DAV/2 SVN/0.32.1+
# Apache/2.0.48 (Unix) DAV/2
HTM:200:200:200:200:200:HTM:501:200:200:HTM:HTM:200:400:400:+++:400:404:405:405:200:200:405:405:+++::Apache/2.0.x w/ WebDAV?
# Apache/2.0.40 (Red Hat Linux) [httpd-2.0.40-21 on Redhat 9]
# Apache/2.0.47(Fedora)
HTM:200:200:200:200:200:HTM:200:200:200:HTM:HTM:200:400:400:400:400:404:405:405:200:200:405:405:200:^Apache/2\.0\.4[07] \(Fedora|Red Hat Linux\):Apache/2.0.4x on Redhat Linux 9 / Fedora
# Apache/1.3.22 (Unix)  (Red-Hat/Linux) mod_python/2.7.8 Python/1.5.2 mod_ssl/2.8.5 OpenSSL/0.9.6b DAV/1.0.2 PHP/4.0.6 mod_perl/1.26 mod_throttle/3.1.2
# Apache/1.3.22 (Unix)  (Red-Hat/Linux) Carrot-1.0.7 PHP/4.3.0 mod_perl/1.21
HTM:200:200:200:400:400:HTM:400:400:200:HTM:HTM:200:400:400:+++:400:404:403:403:200:200:404:501:+++::Apache/1.3.22 (Unix)  (Red-Hat/Linux)
HTM:200:200:200:400:400:HTM:400:400:200:HTM:HTM:200:400:400:+++:400:404:200:200:200:200:404:501:+++::Apache/1.3.22 (Unix)  (Red-Hat/Linux) mod_perl/1.23
# Apache/2.0.48 (Unix) PHP/4.3.4
# Apache/2.0.45 (Unix) mod_ssl/2.0.45 OpenSSL/0.9.7a PHP/4.3.3
HTM:200:200:200:200:200:HTM:200:200:200:HTM:HTM:200:400:400:400:400:404:405:405:200:200:405:501:200:^Apache/2\0\.4[5-8] .*PHP/4\.3\.[34]:Apache/2.0.4x PHP/4.3.x
# Apache/1.3.24 (Unix) PHP/4.2.1
# Apache/1.3.23 (Unix)  (Red-Hat/Linux) PHP/4.2.2
# Apache/1.3.23 (Unix) PHP/4.1.2
# Apache/1.3.12 (Unix) PHP/4.1.2
HTM:200:200:200:200:200:HTM:200:200:200:HTM:HTM:200:400:400:+++:400:404:405:404:200:200:404:501:+++:^Apache/1\.3\[12][234] .*Unix.*PHP/4\.[12]\.[12]:Apache/1.3.12-24 w/ PHP/4.x
# Apache/1.3.27 (Unix)  (Red-Hat/Linux)
# Apache/1.3.27 (Unix) PHP/4.2.2 mod_perl/1.27 mod_ssl/2.8.12 OpenSSL/0.9.6g
HTM:200:200:200:400:400:HTM:501:400:200:HTM:HTM:200:400:400:+++:400:200:405:200:200:200:200:501:+++::Apache/1.3.27 (Unix)
HTM:200:200:200:400:400:---:501:400:200:HTM:---:200:400:400:400:400:404:405:404:200:200:404:501:+++::Apache/1.3.27 (Unix) PHP/4.3.3
HTM:200:200:200:400:400:HTM:501:400:200:HTM:HTM:200:400:400:+++:400:404:403:403:200:200:404:501:+++::Apache/1.3.27 (Unix)  (Red-Hat/Linux) mod_python/2.7.8 Python/1.5.2 mod_ssl/2.8.12 OpenSSL/0.9.6b DAV/1.0.3 PHP/4.1.2 mod_perl/1.26 mod_throttle/3.1.2
HTM:200:200:200:400:400:HTM:501:400:200:HTM:HTM:200:302:302:302:400:404:405:404:200:200:404:501:+++::Apache/1.3.27 (Unix) mod_jk/1.2.2 mod_ssl/2.8.14 OpenSSL/0.9.7a
HTM:200:200:200:400:400:HTM:403:400:200:HTM:HTM:200:400:400:+++:400:404:403:403:200:200:403:403:+++::Apache/1.3.27 (Unix)  (Red-Hat/Linux) mod_jk/1.2.4 mod_ssl/2.8.12 OpenSSL/0.9.6b PHP/4.1.2 mod_perl/1.26
HTM:200:200:200:400:400:HTM:400:400:200:HTM:HTM:200:400:400:+++:+++:404:405:404:200:200:404:501:+++:^Apache(/1.3.2[36])?:Apache/1.3.26 (FreeBSD) or Apache/1.3.23 (Red-Hat/Linux)
HTM:200:200:200:400:400:HTM:400:400:200:HTM:HTM:200:400:400:+++:400:404:404:404:200:200:404:404:+++::Apache/1.3.26 (Unix) mod_perl/1.27 PHP/4.2.2
HTM:200:403:200:400:400:HTM:400:400:200:HTM:HTM:200:400:400:+++:400:403:403:403:403:200:403:403:+++::Apache/1.3.26 (Unix) mod_fastcgi/2.2.12
HTM:200:200:200:400:400:HTM:400:400:200:HTM:HTM:200:400:400:400:400:404:405:404:200:403:404:501:200:^Apache(/1\.3\.26)?:Apache/1.3.26 (Debian 3.0 woody)
xxx:200:200:200:400:400:xxx:200:400:200:xxx:xxx:200:400:400:400:400:404:405:405:200:200:501:501:200::IBM_HTTP_SERVER/1.3.26  Apache/1.3.26 (Unix)
# Unknown versions
HTM:200:200:200:400:400:HTM:400:400:200:HTM:HTM:200:400:400:+++:400:404:405:404:200:403:404:501:+++::Apache (please provide details!)
HTM:200:200:200:200:200:HTM:405:200:200:HTM:HTM:200:400:400:+++:400:404:405:405:200:200:405:501:+++::Apache (please provide details!)
xxx:200:200:200:200:200:xxx:501:200:200:HTM:xxx:200:400:400:+++:400:404:405:405:200:200:405:501:+++::Apache (please provide details!)
---:200:200:200:200:200:---:501:200:200:HTM:---:200:400:400:+++:400:404:405:405:200:200:405:501:+++::Apache (please provide details!)
#
---:200:200:200:200:200:---:501:200:200:HTM:---:200:400:400:400:400:404:403:403:200:200:404:501:200::Apache/1.3.12 (Unix)  (SuSE/Linux) mod_fastcgi/2.2.2 mod_perl/1.24 PHP/4.2.2 mod_ssl/2.6.5 OpenSSL/0.9.5a
# Apache1 on Linux Gentoo 1.4 (1.3.27-r3, 1.3.27-r4, 1.3.18, 1.3.28-r1, 1.3.29)
HTM:200:403:200:400:400:HTM:501:400:200:HTM:HTM:200:400:400:+++:400:404:405:404:200:200:404:501:200:^Apache(/1\.3\.2[789]( +\(Unix\) +\(Gentoo/Linux\))?)?$:Apache/1.3.2x on Gentoo/Linux
# Apache/1.3.29
# Apache/1.3.28 (Unix) PHP/4.3.3 on FreeBSD 4.9 x86, default install
# IBM_HTTP_SERVER/1.3.26.2  Apache/1.3.26 (Unix)
HTM:200:200:200:400:400:HTM:501:400:200:HTM:HTM:200:400:400:400:400:404:405:404:200:200:404:501:403:^(IBM_HTTP_SERVER/1\.3\.26\.2  Apache/1\.3\.26)|(Apache/1\.3\.2[789]):Apache/1.3.27-29 (Unix) PHP/4 or IBM_HTTP_SERVER/1.3.26.2
HTM:200:200:200:400:400:HTM:200:400:200:HTM:HTM:200:400:400:400:400:404:405:404:200:200:404:501:403::Apache/1.3.29
# Same signature??
# Apache/1.3.27 (Unix)  (Red-Hat/Linux) tomcat/1.0 mod_ssl/2.8.12 OpenSSL/0.9.6b DAV/1.0.3 PHP/4.1.2 mod_perl/1.26
# Apache/1.3.27 (Unix)  (Red-Hat/Linux) mod_ssl/2.8.12 OpenSSL/0.9.6b DAV/1.0.3 PHP/4.1.2 mod_perl/1.26
# Apache/1.3.27 (Unix) PHP/4.2.2 mod_perl/1.27 mod_ssl/2.8.12 OpenSSL/0.9.6g
# Apache/1.3.28 (Unix) mod_ssl/2.8.15 OpenSSL/0.9.7b
##HTM:200:200:200:400:400:HTM:501:400:200:HTM:HTM:200:400:400:+++:400:404:405:404:200:200:404:501:+++:^Apache/1\.3\.2[7-9] \(Unix\):Apache/1.3.27-28 on Redhat Linux
# Apache/1.2.6 Red Hat
# Apache/1.2.4
# Apache/1.3.0 (Unix)
# Apache/1.3.3 (Unix)
HTM:200:200:200:200:200:HTM:501:200:200:HTM:HTM:200:400:400:+++:400:404:405:404:200:200:501:501:+++:^Apache(/1\.(2\.[46]|3\.[03]))?:Apache/1.2.4 to 1.3.3
## A every common Apache signature ##
# Apache/1.3.4 (Unix)
# Apache/1.3.6 (Unix)
# Apache/1.3.9 (Unix)
# Apache/1.3.9 (Unix) mod_perl/1.21
# Apache/1.3.9 (Unix)  (SuSE/Linux)
# Apache/1.3.12 (Unix)
# Apache/1.3.12 (Unix)  (SuSE/Linux)
# Apache/1.3.12 (Unix) mod_perl/1.24 ApacheJserv/1.1.2
# Apache/1.3.12 (Unix)  (Red Hat/Linux) PHP/3.0.15
# Apache/1.3.14 (Unix)  (Red-Hat/Linux) PHP/4.1.2 ApacheJServ/1.1.2
# Apache/1.3.14 (Unix)  (Red-Hat/Linux) PHP/3.0.18 mod_perl/1.23
# Apache/1.3.19 (Unix)
# Apache/1.3.20 (Unix)
# Apache/1.3.22 (Unix)  (Red-Hat/Linux) PHP/4.1.2
# Apache/1.3.22 (Unix)  (Red-Hat/Linux) mod_ssl/2.8.5 OpenSSL/0.9.6b
# Apache/1.3.22 (Unix)  (Red-Hat/Linux) mod_ssl/2.8.5 OpenSSL/0.9.6b DAV/1.0.2 PHP/4.0.6 mod_perl/1.26
# Apache/1.3.22 (Unix)  (Red-Hat/Linux) mod_ssl/2.8.7 OpenSSL/0.9.6d
# Apache/1.3.22 (Unix) PHP/4.3.2
# Apache/1.3.23 (Unix)  (Red-Hat/Linux)
# Apache/1.3.23 (Unix) PHP/4.1.2
# Apache/1.3.23 (Unix)  (Red-Hat/Linux) mod_ssl/2.8.7 OpenSSL/0.9.6b DAV/1.0.3 PHP/4.1.2 mod_perl/1.26
# Apache/1.3.24 (Unix) mod_jk
# Apache/1.3.24 (Unix)
# Oracle9iAS/9.0.2 Oracle HTTP Server
# Oracle9iAS/9.0.2.2.0 Oracle HTTP Server
# Oracle9iAS/9.0.3.1 Oracle HTTP Server
# Oracle HTTP Server Powered by Apache/1.3.12 (Unix) ApacheJServ/1.1 mod_perl/1.24
# Oracle HTTP Server Powered by Apache/1.3.19 (Unix) mod_fastcgi/2.2.10 mod_perl/1.25 mod_oprocmgr/1.0
# Oracle HTTP Server Powered by Apache/1.3.19 (Unix) mod_plsql/3.0.9.8.3b mod_ssl/2.8.1 OpenSSL/0.9.5a mod_fastcgi/2.2.10 mod_perl/1.25 mod_oprocmgr/1.0
# Oracle HTTP Server Powered by Apache/1.3.19 (Unix) mod_plsql/3.0.9.8.3c mod_fastcgi/2.2.10 mod_perl/1.25 mod_oprocmgr/1.0
# MS-IIS/4.0-3  (WNT)	[is this a fake?]
HTM:200:200:200:200:200:HTM:501:200:200:HTM:HTM:200:400:400:+++:400:404:405:404:200:200:404:501:+++:^(Apache(/1\.3.(9|1[249]|2[0234])[^0-9])?|Oracle9iAS/9\.0\.[23]|Oracle HTTP Server Powered by Apache/1\.3\.1[29]):Apache/1.3.9 to 1.3.24
## Same as above but more precise ##
# IBM_HTTP_SERVER/1.3.19.2  Apache/1.3.20 (Unix)
# IBM_HTTP_SERVER/1.3.19  Apache/1.3.20 (Unix)
HTM:200:200:200:200:200:HTM:501:200:200:HTM:HTM:200:400:400:400:400:404:405:404:200:200:404:501:403:^IBM_HTTP_SERVER/1\.3\.19(\.2)?  Apache/1\.3\.20 \(Unix\):IBM_HTTP_SERVER/1.3.19.2  Apache/1.3.20 (Unix)
HTM:200:200:200:200:200:HTM:501:200:200:HTM:HTM:200:400:400:400:400:404:405:404:200:200:404:501:200::IBM_HTTP_SERVER/1.3.19.5  Apache/1.3.20 (Unix)
# Slightly different
xxx:200:200:200:200:200:xxx:501:200:200:HTM:xxx:200:400:400:400:400:404:405:404:200:200:404:501:200::IBM_HTTP_SERVER/1.3.19.2  Apache/1.3.20 (Unix)
HTM:200:200:200:200:200:HTM:501:200:200:HTM:HTM:200:400:400:400:400:404:405:---:200:200:404:501:403::IBM_HTTP_SERVER/1.3.19.5  Apache/1.3.20 (Unix)
# Apache-AdvancedExtranetServer/1.3.23 (Mandrake Linux/4mdk) PHP/4.1.2
# Apache-AdvancedExtranetServer/1.3.23 (Mandrake Linux/4mdk) mod_perl/1.26
HTM:200:403:200:200:200:HTM:501:200:200:HTM:HTM:200:400:400:+++:400:404:405:404:200:200:404:501:+++::Apache-AdvancedExtranetServer/1.3.23 (Mandrake Linux/4mdk)
# Apache-AdvancedExtranetServer/1.3.28 (Mandrake Linux/3.1.92mdk)
# Apache-AdvancedExtranetServer/1.3.28 (Mandrake Linux/3.1.92mdk) mod_fastcgi/2.4.0 sxnet/1.2.4 mod_ssl/2.8.15 OpenSSL/0.9.7b PHP/4.3.3
# Apache/1.3.29 (Debian GNU/Linux) PHP/4.3.3 mod_ssl/2.8.14 OpenSSL/0.9.7b
# Apache/1.3.27 (Unix)  (Red-Hat/Linux) mod_ssl/2.8.12 OpenSSL/0.9.6b DAV/1.0.3 PHP/4.1.2 mod_perl/1.26
# I suspect that the common denominator is mod_fastcgi
HTM:200:200:200:400:400:HTM:501:400:200:HTM:HTM:200:400:400:400:400:404:405:404:200:200:404:501:200:^Apache(-AdvancedExtranetServer)?/1\.3.2[789]:Apache/1.3.27-9 on Linux w/ mod_fastcgi?E
---:200:200:200:400:400:---:501:400:200:---:---:200:400:400:400:---:404:405:404:200:403:404:501:200::Apache-AdvancedExtranetServer/1.3.28 (Mandrake Linux/3.1.92mdk) mod_fastcgi/2.2.12 sxnet/1.2.4 mod_ssl/2.8.15 OpenSSL/0.9.7b PHP/4.3.3
# Also  Communique/2.5.0 (build 4850)
HTM:200:200:200:400:400:HTM:501:400:200:HTM:HTM:200:400:400:+++:+++:404:405:404:200:403:404:501:+++::Apache/1.3.27 (Solaris 8)
HTM:200:200:200:400:400:HTM:501:400:200:HTM:HTM:200:400:302:+++:+++:404:405:404:200:200:404:501:+++::Apache/1.3.27 (Red-Hat/Linux)
# Apache on Debian GNU/Linux
---:302:200:---:400:400:---:400:400:302:HTM:---:302:400:400:+++:+++:404:405:404:200:403:404:501:302::Apache/1.3.26 (Unix) Debian GNU/Linux
HTM:200:200:200:400:400:HTM:501:400:200:HTM:HTM:200:400:400:+++:+++:404:405:404:200:403:404:501:200::Apache/1.3.27 (Unix) Debian GNU/Linux
xxx:200:200:200:400:400:xxx:200:400:200:xxx:xxx:200:400:400:+++:+++:404:405:404:200:200:404:501:400::Apache/1.3.27 (Unix) Debian GNU/Linux
xxx:200:200:200:400:---:xxx:200:400:200:xxx:xxx:200:400:400:400:400:404:405:404:200:403:404:501:+++::Apache/1.3.27 (Unix) Debian GNU/Linux
xxx:200:403:200:400:400:xxx:501:400:200:HTM:xxx:200:400:400:+++:+++:404:405:404:200:403:404:501:+++::Apache/1.3.28 (FreeBSD/locked)
HTM:200:200:200:400:400:HTM:501:400:200:HTM:HTM:200:400:301:301:400:404:405:404:200:200:404:501:403::Apache/1.3.28 (Unix) mod_deflate/1.0.19 mod_accel/1.0.30
HTM:200:200:200:400:400:HTM:501:400:200:---:HTM:200:400:400:400:400:404:403:403:200:200:404:501:200::Apache/1.3.29 (Unix) mod_auth_passthrough/1.8 mod_log_bytes/1.2 mod_bwlimited/1.2 PHP/4.3.3 FrontPage/5.0.2.2634 mod_ssl/2.8.16 OpenSSL/0.9.6b
# Apache/1.3.29 (Unix) mod_auth_passthrough/1.8 mod_log_bytes/1.2 mod_bwlimited/1.4 PHP/4.3.4 FrontPage/5.0.2.2634 mod_ssl/2.8.16 OpenSSL/0.9.6b
# Apache/1.3.29 (Unix)  (PLD/Linux) mod_ssl/2.8.15 OpenSSL/0.9.6j mod_fastcgi/2.2.12 PHP/4.2.3 mod_perl/1.27
HTM:200:200:200:400:400:HTM:200:400:200:HTM:HTM:200:400:400:400:400:404:405:404:200:200:404:501:200:^Apache/1\.3\.29 \(Unix\):Apache/1.3.29 mod_ssl/2.8 OpenSSL/0.9.6 PHP/4
# Although cover the previous case (should be improved)
HTM:200:200:200:400:400:HTM:200:400:200:HTM:HTM:200:400:400:+++:+++:404:405:404:200:200:404:501:+++::Apache/1.3.28
---:302:200:200:302:302:---:501:302:302:HTM:---:302:400:400:400:400:404:405:405:200:403:405:501:302::Apache/2.0.48 (Unix) Debian GNU/Linux
# Apache 1.3.9 on Linux 2.2.16 (gcc version 2.7.2.3)
HTM:200:403:200:200:200:HTM:501:200:200:HTM:HTM:200:400:400:400:400:404:405:404:200:403:404:501:+++::Apache/1.3.9 (Unix) PHP/4.2.3 PHP/3.0.18
# Linux 2.2.19-6.2.1 (RedHat 6.2) Apache 1.3.29 modssl 2.8.16 openssl 0.9.7c
HTM:200:200:200:400:400:HTM:501:400:200:HTM:HTM:200:400:400:400:400:200:405:200:200:403:200:501:200:^Apache:Apache/1.3.29 (RedHat 6.2) modssl/2.8.16 OpenSSL/0.9.7c
# Apache/1.3.29 (Unix) PHP/4.3.4 mod_perl/1.29
# Apache/1.3.28 (Unix) PHP/4.3.3 mod_ssl/2.8.15 OpenSSL/0.9.7b
# Apache/1.3.4 (Unix)
# Apache/1.3.29 (Unix)  (PLD/Linux) mod_fastcgi/2.2.12 PHP/4.2.3
# Apache/1.3.29 (Unix) mod_perl/1.29 PHP/4.3.4 mod_ssl/2.8.16 OpenSSL/0.9.7c
HTM:200:200:200:400:400:HTM:501:400:200:HTM:HTM:200:400:400:400:400:404:405:404:200:200:404:501:+++:^Apache/1\.3\.(4|28|29) \(Unix\):Apache/1.3.4-29 (Unix)
HTM:403:200:403:400:400:HTM:501:400:403:HTM:HTM:403:400:400:400:400:404:405:404:200:200:404:501:403::Apache/1.3.29 (Unix) mod_perl/1.29 PHP/4.3.4 mod_ssl/2.8.16 OpenSSL/0.9.7c
HTM:200:200:302:200:200:HTM:501:200:200:HTM:HTM:200:400:400:+++:400:404:403:403:200:200:404:501:+++::Apache/1.3.11 (Unix) mod_perl/1.21 AuthMySQL/2.20
HTM:200:200:200:200:200:HTM:501:200:200:HTM:HTM:200:400:400:400:400:404:403:403:200:200:404:501:403::Apache/1.3.11 (Unix) mod_fastcgi/2.2.2 ApacheJServ/1.1 FrontPage/4.0.4.3 mod_perl/1.21
# Cobalt
HTM:302:200:200:302:302:HTM:302:302:302:HTM:HTM:302:400:400:400:400:404:405:404:200:200:501:501:302::Apache/1.3.3 Cobalt (Unix)  (Red Hat/Linux)
# Apache/1.3.20 Sun Cobalt (Unix) mod_ssl/2.8.4 OpenSSL/0.9.6b PHP/4.1.2 mod_auth_pam_external/0.1 FrontPage/4.0.4.3 mod_perl/1.25
# Apache/1.3.20 Sun Cobalt (Unix) mod_ssl/2.8.4 OpenSSL/0.9.6b PHP/4.3.3 mod_auth_pam_external/0.1 FrontPage/4.0.4.3 mod_perl/1.25
HTM:302:200:200:302:302:HTM:302:302:302:HTM:HTM:302:400:400:400:400:404:405:404:200:200:404:501:302::Apache/1.3.20 Sun Cobalt (Unix) mod_ssl/2.8.4 OpenSSL/0.9.6b PHP/4
# Unknown versions
HTM:200:200:200:200:200:HTM:501:200:200:HTM:HTM:200:400:400:+++:400:404:405:200:200:200:404:501:+++::Apache
HTM:200:200:200:400:400:---:501:400:200:HTM:---:200:400:400:+++:400:404:405:404:200:200:404:501:+++::Apache
# Apache/1.3.27 (Darwin) DAV/1.0.3
# Apache/1.3.27 (Darwin) tomcat/1.0 mod_ssl/2.8.13 OpenSSL/0.9.6i
HTM:200:200:200:400:400:---:501:400:---:---:---:---:400:400:+++:400:404:405:404:200:200:404:501:+++::Apache/1.3.27 (Darwin)
HTM:200:200:200:400:400:---:501:400:---:---:---:---:400:400:+++:400:404:401:401:200:200:401:405:+++::Apache/1.3.27 (Darwin) DAV/1.0.3
HTM:200:200:200:400:400:HTM:501:400:200:HTM:HTM:200:400:400:+++:400:404:401:401:200:200:401:405:+++::Apache/1.3.27 (Darwin) DAV/1.0.3
# Apache Win32
HTM:200:200:200:200:200:HTM:501:200:200:HTM:HTM:200:200:400:+++:400:404:405:404:200:200:404:501:+++::Apache/1.3.24 (Win32) PHP/4.2.0
HTM:200:200:200:200:200:HTM:200:200:200:HTM:HTM:200:200:400:+++:400:404:405:404:200:200:404:501:+++::Apache/1.3.24 (Win32) PHP/4.2.0
xxx:200:200:200:200:200:xxx:200:200:200:xxx:xxx:200:200:400:+++:400:404:405:404:200:200:404:501:+++::Apache/1.3.24 (Win32) PHP/4.2.0
xxx:200:200:200:400:400:xxx:400:400:200:HTM:xxx:200:200:400:+++:400:404:405:404:200:200:404:501:+++::Apache/1.3.26 (Win32)
HTM:200:200:200:400:400:HTM:400:400:200:HTM:HTM:200:200:400:+++:400:404:405:404:200:200:404:501:+++::Apache/1.3.26 (Win32) PHP/4.2.2
---:200:403:200:200:200:---:501:200:200:HTM:---:200:200:400:400:400:404:405:404:200:200:404:501:403::IBM_HTTP_SERVER/1.3.19.3 Apache/1.3.20 (Win32)
HTM:404:403:200:404:404:HTM:501:404:404:HTM:HTM:404:404:400:400:400:200:200:200:200:200:200:200:403::IBM_HTTP_SERVER/1.3.19.3  Apache/1.3.20 (Win32)
HTM:301:501:200:400:400:400:400:400:---:HTM:---:301:301:400:400:400:404:405:405:501:501:501:501:301::IBM_HTTP_SERVER/1.3.26.2  Apache/1.3.26 (Win32)
HTM:200:403:200:200:200:HTM:200:200:200:HTM:HTM:200:200:400:400:400:200:200:200:200:200:200:200:200::Apache/1.3.17 (Win32)
# Apache/2.0.39 (Win32) w/ PHP/4.1.2
HTM:200:200:200:200:200:HTM:200:200:200:HTM:HTM:200:200:400:+++:400:404:405:405:200:200:405:501:+++::Apache/2.0.39 (Win32)
# More specific signature
HTM:200:200:200:200:200:HTM:200:200:200:HTM:HTM:200:200:400:400:400:404:405:405:200:200:405:501:200::Apache/2.0.43 (Win32) JRun/4.0
# Apache/2.0.45 (Win32)
# Apache/2.0.47 (Win32) mod_python/3.0.3 Python/2.2.3
# Apache/2.0.47 (Win32) PHP/4.3.3
# Apache/2.0.48 (Win32)
HTM:200:403:200:200:200:HTM:501:200:200:HTM:HTM:200:200:400:+++:400:404:405:405:200:200:405:501:+++:^Apache/2\.0\.4[5-8] \(Win32\):Apache/2.0.45-48 (Win32)
# Apache/2.0.40 (Win32)
# Apache/2.0.35 (Win32)
HTM:200:200:200:200:200:HTM:501:200:200:HTM:HTM:200:200:400:+++:400:404:405:405:200:200:405:501:+++:^Apache/2\.0\.[34][05].*Win32:Apache/2.0.35-40 (Win32)
# Apache/2.0.47 (Win32) PHP/4.3.2
# Apache/2.0.47 (Win32) mod_python/3.0.3 Python/2.2.3
HTM:200:403:200:200:200:HTM:200:200:200:HTM:HTM:200:200:400:+++:400:404:405:405:200:200:405:501:+++::Apache/2.0.47 (Win32)
# Oracle HTTP Server Powered by Apache/1.3.12 (Win32) ApacheJServ/1.1 mod_ssl/2.6.4 OpenSSL/0.9.5a mod_perl/1.24
# Apache/1.3.12 (Win32) ApacheJServ/1.1 mod_ssl/2.6.4 OpenSSL/0.9.5a mod_perl/1.22
# Apache/1.3.17 (Win32)
HTM:200:403:200:200:200:HTM:501:200:200:HTM:HTM:200:200:400:+++:400:404:405:404:200:200:404:501:+++:Apache/1\.3\.1[27] (Win32):Apache/1.3.12-17 (Win32)
# Apache/1.3.27 (Win32)
# Apache/1.3.28 (Win32)
# Apache/1.3.28 (Win32) PHP/4.3.2
# Apache/1.3.28 (Win32) PHP/4.3.3
HTM:200:200:200:400:400:HTM:501:400:200:HTM:HTM:200:200:400:+++:400:404:405:404:200:200:404:501:+++:^Apache/1\.3\.2[78]:Apache/1.3.27-28 (Win32)
# Same as above but more precise
# IBM_HTTP_SERVER/1.3.26.2  Apache/1.3.26 (Win32)
# IBM_HTTP_SERVER/1.3.26  Apache/1.3.26 (Win32)
HTM:200:200:200:400:400:HTM:501:400:200:HTM:HTM:200:200:400:400:400:404:405:404:200:200:404:501:403:^IBM_HTTP_SERVER/1\.3\.26(\.2)?  Apache/1\.3\.26 \(Win32\):IBM_HTTP_SERVER/1.3.26  Apache/1.3.26 (Win32)
# Novell 6 server running Apache Tomcat 3.2.2 and 3.3 with Novell JVM 1.3.0_02.
HTM:200:403:200:400:400:HTM:501:400:200:HTM:HTM:200:400:400:400:400:404:405:404:200:200:404:501:+++::Apache/1.3.27 (NETWARE) mod_jk/1.2.2-dev
# Same as above but more precise
HTM:200:403:200:400:400:HTM:501:400:200:HTM:HTM:200:400:400:400:400:404:405:404:200:200:404:501:403:^Apache/1\.3\.2[789] \(NETWARE\):Apache/1.3.27-29 (NETWARE) mod_jk/1.2.2-dev
################
# What is BATM?
200:200:---:200:200:200:404:200:200:200:---:404:200:404:404:+++:200:---:---:---:---:---:---:---:+++::BATM
# See http://www.myipis.com/
404:200:404:200:200:200:404:200:200:404:404:404:---:404:404:404:200:404:404:404:404:404:404:404:404::BlackcombHTTP Server (beta 0.4)
HTM:200:400:200:200:200:HTM:400:HTM:200:HTM:HTM:200:403:403:+++:200:500:403:403:400:400:400:400:+++::CERN/3.0
HTM:200:400:200:200:200:HTM:400:HTM:200:HTM:HTM:200:403:403:+++:200:200:403:403:400:400:400:400:+++::CERN/3.0
HTM:200:400:200:200:200:HTM:400:HTM:200:HTM:HTM:200:403:403:+++:200:403:403:403:400:400:400:400:+++::CERN/3.0pre6vms3
# Boa 0.94.12 or 0.94.13
HTM:200:501:HTM:HTM:HTM:501:501:HTM:501:501:501:200:400:400:+++:200:400:501:501:501:501:501:501:200:Boa/0\.94\.1[23]:Boa/0.94
HTM:200:400:200:200:HTM:400:HTM:HTM:200:400:400:200:404:404:+++:200:404:400:400:400:400:400:400:+++::Boa/0.92o
#
200:200:200:200:400:400:400:400:400:400:400:400:200:404:404:+++:400:404:501:501:200:200:400:400:+++::Canon Http Server 1.00
200:200:200:200:200:200:400:200:200:400:400:400:200:200:200:+++:+++:200:200:200:200:200:200:200:+++::Cassini/1.0.1403.33443
# Caudium/1.3.5 + X-Got-Fish: Pike v7.3 release 58
500:200:501:200:200:200:xxx:501:200:500:500:xxx:---:404:302:+++:200:404:405:405:501:501:405:501:+++::Caudium/1.3.5 DEVEL (Debian GNU/Linux)
xxx:200:405:505:400:400:400:200:400:200:400:400:200:400:400:400:400:411:501:501:404:404:404:404:+++::cisco-IOS
400:200:501:200:200:400:---:200:400:200:---:---:200:200:200:501:200:200:501:501:501:501:501:501:+++:^$:cisco-IOS 11.2
---:200:501:200:200:400:---:200:400:200:---:---:200:200:200:501:200:200:501:501:501:501:501:501:200:^$:cisco-IOS 11.2
200:200:---:200:200:200:---:---:200:---:---:---:200:200:200:---:200:200:---:---:---:---:---:---:+++:^$:DSL modem Cisco 678 running CBOS
400:302:---:505:505:505:400:302:505:400:400:400:302:404:404:404:400:404:403:404:404:404:501:501:---::CL-HTTP/70.182 (Symbolics Common Lisp)
# CUPS
200:200:200:505:400:400:400:400:400:200:400:400:200:405:405:+++:200:401:403:---:200:---:400:400:+++::CUPS/1.1
200:200:200:505:400:400:400:400:400:200:400:400:200:405:405:+++:200:404:403:---:200:---:400:400:+++::CUPS/1.1
# Compaq (what's that?)
---:404:510:---:404:---:---:---:---:---:---:---:404:200:404:+++:404:404:405:---:510:---:---:---:+++::CompaqHTTPServer/5.7
# Compaq Insight (std install) on Windows 2000
---:404:510:---:404:---:---:---:---:---:---:---:404:404:404:405:404:404:405:---:510:---:---:---:+++:^CompaqHTTPServer/[45]\.[12]:Compaq Insight 4.1 or 5.2 on Windows 2000
---:200:510:---:200:---:---:---:---:---:---:---:200:200:200:+++:+++:200:405:---:510:---:---:---:+++::CompaqHTTPServer/5.0
# Is Comunique built upon Apache?
xxx:200:200:200:400:400:xxx:501:400:200:HTM:xxx:200:400:400:+++:400:404:405:404:200:403:404:501:+++::Communique/2.5.0 (build 4850)
# IBM Desktop On Call 4.0 (?) on eComStation 1.1 (aka OS/2)
HTM:200:---:200:200:200:404:200:200:404:404:404:---:200:404:+++:200:---:---:---:---:---:---:---:+++::Desktop On-Call HTTPD V3.0
#
HTM:200:400:HTM:HTM:HTM:HTM:HTM:HTM:200:HTM:HTM:200:400:400:+++:200:500:405:405:405:405:501:501:+++::DECORUM/2.0
HTM:200:405:HTM:HTM:HTM:HTM:HTM:HTM:200:HTM:HTM:200:200:404:+++:200:405:405:405:405:405:501:501:+++::DECORUM/2.0
505:200:400:505:505:505:505:505:505:200:505:505:---:404:404:404:200:400:400:400:400:400:400:400:200::DNHTTPD/0.6
505:200:400:505:505:505:505:505:505:200:505:505:---:404:404:403:200:400:400:400:400:400:400:400:200::Ranquel-0.1.2
# This must be AnswerBook. The server is broken and there is a special character in the banner 
# dwhttpd/4.2a7 (Inso\n Sun5)
200:200:---:200:---:200:200:200:200:200:200:200:---:200:200:+++:200:---:---:---:---:---:---:---:+++::dwhttpd/4.2a7 (Inso
200:200:---:200:200:200:200:---:200:200:200:200:---:200:200:+++:200:---:---:---:---:---:---:---:+++::ELOG HTTP 2.3.6
200:200:404:200:200:200:---:200:200:---:---:---:---:404:404:+++:200:---:---:404:404:404:404:404:+++::FileMakerPro/4.0
# typical for CheckPoint Firewall-1 NG FP3 or NG AI versions
200:200:---:200:200:200:---:200:200:---:---:---:---:200:200:---:200:---:---:---:---:---:---:---:+++:^$:Checkpoint FW-1 NG HTTP authentication proxy
# Gordano (installed by Messaging Suite)
200:200:---:200:200:200:200:200:200:200:200:200:200:---:---:+++:+++:200:200:200:200:200:200:200:+++::Gordano Web Server v5.06.0016
200:200:400:200:200:200:501:200:200:501:501:501:200:400:400:+++:+++:302:501:501:501:501:501:501:+++::Gordano Messaging Suite Web Server v9.01.3158
# HP JetDirect 600N (J3110A)
# Version: ROM G.08.08, EPROM G.08.20
HTM:200:404:xxx:xxx:xxx:xxx:xxx:xxx:xxx:xxx:xxx:xxx:404:404:404:200:404:404:404:404:404:404:404:+++:HTTP/1\.0:HP JetDirect 600N (J3110A)
xxx:200:200:200:200:200:xxx:501:200:200:HTM:xxx:200:200:400:+++:400:404:405:405:200:200:405:501:+++::HP Web Jetadmin/2.0.39 (Win32) mod_ssl/2.0.39 OpenSSL/0.9.6c
# HP JetDirect 600N (J3113A) with latest firmware (G.08.49)
# Probably the same signature as above; the HTML identification code changed recently
HTM:200:404:HTM:HTM:HTM:xxx:HTM:HTM:xxx:xxx:xxx:xxx:404:404:404:200:404:404:404:404:404:404:404:+++:HTTP/1\.0:HP JetDirect 600N (J3113A) with G.08.49 firmware
# Two signatures from HP RX 2600
HTM:200:501:200:HTM:HTM:HTM:HTM:HTM:200:HTM:HTM:200:404:404:+++:200:501:501:501:501:501:501:501:+++:.*:HP Web Console
HTM:200:501:200:HTM:---:---:---:---:---:---:---:---:---:---:+++:---:---:---:---:---:---:---:---:+++:.*:HP Web Console
#
HTM:200:500:HTM:200:HTM:HTM:505:HTM:HTM:HTM:HTM:200:200:302:+++:200:500:500:500:500:500:500:500:+++::Inktomi Search 4.2.0
# Ipswitch
VER:200:501:VER:VER:VER:VER:VER:VER:501:501:501:---:200:200:404:400:---:501:501:501:501:501:501:200::Ipswitch-IMail/8.02
# Ipswitch older (obsolete?) signatures
HTM:200:501:HTM:HTM:HTM:HTM:HTM:HTM:501:501:501:---:200:200:404:400:---:501:501:501:501:501:501:+++:Ipswitch:Ipswitch Web Calendaring /8.04 or Ipswitch-IMail/8.04
200:200:---:200:200:200:---:404:404:---:---:---:---:200:200:200:200:---:---:---:---:---:---:---:+++::IMail_Monitor/8.04
400:200:405:400:200:400:400:400:400:200:400:200:500:200:401:+++:400:404:405:405:405:405:405:405:+++::Intel NMS 1.0
500:200:501:200:200:200:500:405:200:500:500:500:200:200:200:200:200:404:405:405:405:405:405:405:200::Servertec-IWS/1.11
# Oracle?
HTM:200:200:505:---:400:400:501:200:400:HTM:400:200:400:400:+++:400:404:403:403:200:200:501:501:+++::JavaWebServer/2.0
404:404:501:404:404:404:400:501:404:404:501:400:404:404:404:+++:404:501:501:501:501:501:501:501:+++::Java Cell Server
# Jetty - I got the same sig for two versions
# Jetty/5.0.alpha3 (Linux/2.4.20-gentoo-r8 i386 java/1.4.1)
# Jetty/4.2.14 (Linux/2.4.20-gentoo-r8 i386 java/1.4.1)
HTM:200:200:200:200:200:---:200:200:---:---:---:200:404:302:+++:+++:404:404:404:404:200:404:404:200:Jetty/[45]\.:Jetty 4.2 or 5.0alpha
# JBoss (default installation, w/ no200)
HTM:200:200:200:200:200:---:200:200:---:---:---:200:404:404:+++:+++:100:100:404:404:200:405:405:404:Jetty/4\.:Jetty 4.2 in JBoss 3.0.6 (out of the box)
# also Jetty/4.2.9 (Windows 2000/5.0 x86 java/1.4.2)
HTM:200:200:200:200:200:---:200:200:---:---:---:200:404:404:+++:+++:404:404:404:404:200:405:405:404:Jetty/4\.:Jetty 4.2 in JBoss 3.2.1 (out of the box) or Jetty/4.2.9
xxx:200:200:503:503:503:xxx:500:503:200:HTM:xxx:200:400:400:400:400:200:200:200:200:200:200:200:200::Jetty/4.2.11 (Linux/2.4.20-8smp x86 java/1.4.1)
HTM:200:404:200:200:200:---:200:200:---:---:---:200:404:302:+++:400:100:100:404:404:200:404:404:+++::Jetty/4.1.4 (Windows XP 5.1 x86)
#
HTM:200:200:200:---:HTM:---:501:---:200:---:---:200:404:404:+++:---:404:404:404:404:404:404:404:200:1\.0beta:Jigsaw 1.0beta2
HTM:200:200:200:---:HTM:---:501:---:200:---:---:200:404:404:+++:400:404:404:404:404:404:404:404:200::Jigsaw/2.0.5
HTM:200:200:200:---:HTM:---:501:---:200:---:---:200:404:404:+++:+++:404:404:404:404:200:404:404:200::Jigsaw/2.2.2
400:404:200:200:404:400:400:400:400:400:400:400:404:400:400:400:404:405:200:200:200:200:200:200:404::Jigsaw 2.2.1 (Windows 2000)
400:404:404:200:404:400:400:400:400:400:400:400:404:400:400:400:404:405:404:404:404:404:404:404:404::Jigsaw 2.2.1(windows 2000)
# Kazaa - not a real web server
501:404:---:404:404:404:501:---:501:501:501:501:404:501:501:501:404:501:501:---:---:---:---:---:404:.*:Kazaa servent (not a real web server)
# Lotus Domino
HTM:200:200:200:200:200:HTM:200:HTM:200:HTM:HTM:200:200:403:+++:400:500:405:405:200:200:501:501:+++::Lotus-Domino/4.6
HTM:200:---:200:200:200:HTM:200:HTM:200:HTM:HTM:200:403:403:500:400:500:405:405:405:405:501:501:403::Lotus-Domino/5.0.5
HTM:200:405:200:200:200:HTM:200:HTM:200:HTM:HTM:200:200:403:500:400:500:405:405:405:405:501:501:+++::Lotus-Domino/5.0.11
# More precise than above
HTM:200:405:200:200:200:HTM:200:HTM:200:HTM:HTM:200:200:403:500:400:500:405:405:405:405:501:501:500:^Lotus-Domino/0$:Lotus Domino 5.0.12 on Windows 2000 SP4 w/ AD
400:200:200:200:400:400:400:200:400:200:400:400:200:200:200:200:400:404:404:404:200:200:404:405:+++:^Lotus-Domino$:Lotus-Domino/R6.5
# Domino-Go-Webserver/4.6.2.2
# Domino-Go-Webserver/4.6.2.51
HTM:200:200:200:200:200:HTM:HTM:HTM:200:HTM:HTM:200:200:403:403:400:500:405:405:200:200:501:501:404::Domino-Go-Webserver/4.6.2.
HTM:200:200:200:200:200:HTM:200:HTM:200:HTM:HTM:200:403:403:403:400:500:405:405:200:200:501:501:404::Domino-Go-Webserver/4.6.2.5
#
HTM:200:501:200:200:HTM:xxx:200:200:200:HTM:200:---:302:404:+++:200:404:501:501:501:501:501:501:+++::LV_HTTP/1.0
HTM:200:---:200:---:---:---:---:---:200:---:200:---:200:200:+++:200:---:---:---:---:---:---:---:+++::LabVIEW/7.0
200:200:501:200:200:200:400:400:400:400:400:400:200:404:404:+++:200:501:501:501:501:501:501:501:+++::LseriesWeb/1.0-beta (LSERIES)
200:200:400:200:200:200:400:200:200:400:400:400:---:400:400:+++:200:404:401:400:400:400:400:400:+++::PersonalNetFinder/1.0 ID/ACGI
# PersonalNetFinder/1.0 ID/ACGI
# MACOS_Personal_Websharing
200:200:400:200:200:200:400:200:200:400:400:400:---:400:400:+++:200:404:403:400:400:400:400:400:+++:MACOS_Personal_Websharing|PersonalNetFinder:MacOS PersonalNetFinder
HTM:200:HTM:200:200:---:HTM:HTM:200:200:HTM:HTM:200:HTM:HTM:+++:400:200:HTM:HTM:HTM:HTM:HTM:HTM:+++::AppleShareIP/6.0.0
#
HTM:200:501:xxx:HTM:HTM:HTM:HTM:HTM:200:HTM:HTM:200:404:301:301:400:404:501:501:501:501:501:501:200::HTTPi/1.4 (xinetd/Linux)
HTM:404:501:400:505:400:---:501:400:404:---:---:404:400:400:400:404:404:501:501:501:501:501:501:400::Mathopd/1.4p1
---:400:501:505:400:400:---:---:---:400:---:---:400:400:400:400:400:411:501:501:501:501:501:501:414::Mathopd/1.5b11
400:200:501:200:200:200:400:200:200:400:400:400:200:400:400:501:200:501:501:501:501:501:501:501:400::micro_httpd
# Belkin 54g Wireless AP model F5D7130 - version 1000
---:200:501:200:200:200:---:200:200:---:---:---:200:400:400:501:200:404:501:501:501:501:501:501:+++::micro_httpd
HTM:200:400:200:200:200:400:400:200:400:400:400:---:404:404:+++:200:400:501:501:400:400:400:501:+++::Micro-HTTP/1.0
HTM:200:501:200:200:200:400:501:200:400:400:400:200:404:404:+++:200:400:501:501:501:501:501:501:+++::Micro-HTTP/1.0
HTM:200:501:200:200:200:400:501:200:400:400:400:200:404:404:+++:200:400:501:501:501:501:501:HTM:+++::Micro-HTTP/1.0
HTM:200:501:200:200:200:400:HTM:200:400:400:400:200:404:404:+++:200:400:HTM:501:HTM:HTM:HTM:HTM:+++::Micro-HTTP/1.0
HTM:200:501:200:200:200:400:501:200:400:400:400:200:404:404:+++:200:400:HTM:501:501:HTM:HTM:501:+++::Micro-HTTP/1.0
HTM:200:HTM:200:200:200:400:HTM:200:400:400:400:200:404:404:+++:200:400:HTM:HTM:501:501:501:HTM:+++::Micro-HTTP/1.0
# MS IIS
HTM:200:404:200:200:HTM:400:501:HTM:200:400:400:200:200:404:404:200:501:501:501:501:501:501:501:200::Microsoft-IIS/3.0
HTM:200:200:200:200:HTM:400:400:400:400:400:400:200:400:400:+++:400:405:403:403:200:200:501:501:200:^Microsoft-IIS/4\.0$:Microsoft-IIS/4.0 (Windows NT4 SP6a)
HTM:200:200:200:200:HTM:400:400:400:400:400:400:200:400:400:+++:+++:405:411:404:200:200:501:501:+++::Microsoft-IIS/4.0
HTM:200:200:200:200:HTM:400:400:400:400:400:400:200:400:400:400:400:405:403:403:200:200:501:501:+++::Microsoft-IIS/4.0
404:404:200:200:404:404:400:400:400:400:400:400:404:400:400:+++:+++:405:501:501:200:200:501:501:+++::Microsoft-IIS/5.0
404:404:200:200:404:404:400:400:400:400:400:400:404:400:400:+++:404:405:411:404:200:200:400:411:+++::Microsoft-IIS/5.0
200:200:200:200:200:200:400:400:400:400:400:400:200:400:400:400:400:405:501:501:200:200:501:501:200::Microsoft-IIS/5.0
200:200:404:200:200:200:400:400:400:400:400:400:200:400:400:+++:400:405:404:404:404:404:404:404:+++::Microsoft-IIS/5.0
# There is a similar signature below
200:200:200:200:200:200:400:400:400:400:400:400:200:400:400:+++:400:405:403:403:200:404:400:411:+++::Microsoft-IIS/5.0
HTM:200:200:200:200:HTM:400:400:400:400:400:400:200:400:400:+++:400:405:411:404:200:200:400:411:+++::Microsoft-IIS/5.0
# Suspicious signature
404:404:404:200:404:404:400:400:400:400:400:400:404:400:400:400:404:405:404:404:404:404:404:404:404:Microsoft-IIS/5\.0:MS IIS 5.0 w/ URLScan 2.5 (6.0.3615.0) on Win2000 server up to date (2004-01-14)
# Windows 2000 server SP4 w/ urlscan, w/o OWA
HTM:200:404:200:200:HTM:---:400:400:400:400:400:200:400:400:400:400:404:404:404:404:404:404:404:+++:Microsoft-IIS/5\.0:MS IIS 5.0 with UrlScan, without Outlook Web Access, on Win2000 SP4
# X-Powered-By: ASP.NET
# Windows 2000 Advanced Server, SP-4 Build 2195; IIS5 with .NET
200:200:200:200:200:200:400:400:400:400:400:400:200:400:400:400:400:405:403:403:200:404:400:411:+++:Microsoft-IIS/5\.0:MS IIS 5.0 with .NET on Win2000 SP4
200:200:200:200:200:200:400:400:400:400:400:400:200:400:400:400:400:405:403:403:200:200:400:411:200:^Microsoft-IIS/5\.[01]:MS IIS 5.0 on Win2000 SP4 or 5.1 on WinXP SP1
# IIS 5.0 on Win 2000 SP4 server english with all patches (2003-12-16) & .NET & without Lockdown
xxx:200:200:200:200:xxx:400:400:400:400:400:400:200:400:400:400:400:405:403:403:200:200:400:411:+++:^Microsoft-IIS/5\.0:MS IIS 5.0 with .NET on Win2000 SP4
HTM:200:200:200:200:HTM:400:400:400:400:400:400:200:400:400:400:400:405:403:403:200:200:400:411:200:^Microsoft-IIS/5\.0:MS IIS 5.0 on Win2000 with latest patches (2003-12-29)
# The next signature is too imprecise and clashes the previous IIS/5.0 signature
HTM:200:200:200:200:HTM:400:400:400:400:400:400:200:400:400:+++:+++:405:403:403:200:200:400:411:+++:Microsoft-IIS/5\.1:MS IIS 5.1 on WinXP
HTM:200:500:200:200:HTM:400:400:400:400:400:400:200:400:400:+++:400:405:500:500:500:200:500:500:+++::Microsoft-IIS/5.1
# IIS 5, Windows 2000 SP-4 running OWA on exchange 5.5
400:200:404:200:200:400:400:400:400:400:400:400:200:400:400:400:400:405:404:404:404:404:404:404:200:.*:Microsoft-IIS/5 (OWA on Exchange 5.5)
# Unpatched IIS 5.0 protected by Checkpoint Firewall-1 Smart Defense
xxx:200:200:200:200:xxx:---:400:400:---:---:---:200:400:400:400:400:405:403:403:200:200:400:400:+++:Microsoft-IIS/5\.0:Microsoft-IIS/5\.0 (behind FW-1)
# IIS/6
HTM:200:200:505:400:---:400:400:400:200:400:400:---:400:400:+++:400:411:411:501:200:501:501:501:+++::Microsoft-IIS/6.0
200:200:200:505:400:---:400:400:400:200:400:400:---:400:400:+++:400:411:411:403:200:501:400:411:+++:Microsoft-IIS/6\.0:Microsoft-IIS/6.0 (w/ ASP.NET 1.1.4322)
# MS PWS
HTM:200:404:200:200:HTM:400:501:HTM:200:400:400:200:200:404:+++:200:501:501:501:501:501:501:501:+++::Microsoft-PWS/3.0
# MS ISA Server 2000
400:403:500:403:400:400:400:400:400:403:400:400:403:500:500:500:403:403:403:403:403:403:403:403:403:^$:MS ISA Server 2000 reverse proxy (rejecting connections)
# Mini HTTPD
xxx:200:501:VER:VER:VER:xxx:VER:xxx:200:xxx:xxx:200:400:400:400:200:404:501:501:501:501:501:501:400:mini_httpd/1\.1[78]:mini_httpd/1.17beta1 or 1.18
400:200:400:400:200:400:400:400:400:200:400:400:200:200:200:+++:200:200:400:400:400:400:400:400:+++::MiniServ/0.01
---:200:---:---:200:---:---:---:---:200:---:---:200:200:200:200:200:200:---:---:---:---:---:---:+++::MiniServ/0.01
# Monkey
400:200:403:200:200:200:400:405:200:400:400:400:200:404:404:+++:+++:411:405:405:405:405:405:405:+++::Monkey/0.7.1 (Linux)
---:---:---:200:---:---:---:---:---:---:---:---:---:---:---:---:---:404:404:404:---:404:---:---:+++:PLT Scheme:mzserver 203-6 on Debian 
# aEGiS_nanoweb/2.1.3 (Linux; PHP/4.3.3)
# aEGiS_nanoweb/2.2.0 (Linux; PHP/4.3.3)
# aEGiS_nanoweb/2.2.1 (Linux; PHP/4.3.3)
200:200:200:200:200:200:200:501:200:501:501:200:200:404:302:404:200:404:501:501:200:501:501:501:200:^aEGiS_nanoweb/2\.(1\.3)|(2\.[01]):aEGiS_nanoweb/2.1.3 or 2.2.0 or 2.2.1
400:200:200:200:200:200:400:501:400:501:501:400:200:404:302:404:200:404:501:501:200:501:501:501:200::aEGiS_nanoweb/2.2.2 (Linux; PHP/4.3.3)
# Good old NCSA
HTM:200:HTM:HTM:HTM:HTM:400:HTM:HTM:200:HTM:400:200:404:404:+++:+++:404:404:404:400:400:400:400:+++::NCSA/1.5.2
HTM:200:400:HTM:HTM:HTM:400:400:HTM:200:HTM:400:200:404:404:+++:200:404:404:404:400:400:400:400:+++::NCSA/1.5.2
#
200:200:400:200:200:200:400:200:200:400:400:400:200:400:400:+++:200:400:400:400:400:400:400:400:+++::NUD/3.6
400:200:501:400:400:400:400:400:400:400:400:400:400:400:400:+++:200:501:501:501:501:501:501:501:+++::NUD/4.0.3
200:200:---:200:200:200:---:---:---:---:---:---:200:200:200:+++:200:200:---:---:---:---:---:---:+++::NetPresenz/4.1
# Netscape / iPlanet / Sun ONE
HTM:200:404:200:200:200:400:500:200:400:400:400:200:404:404:404:200:500:500:500:500:500:500:500:+++::Netscape-Commerce/1.12
HTM:200:200:400:200:200:400:500:200:400:400:400:200:404:404:+++:400:500:401:401:200:200:500:400:+++::Netscape-FastTrack/3.01
HTM:200:200:200:200:200:400:500:200:200:400:200:200:404:404:+++:200:500:401:401:200:200:500:400:+++::Netscape-FastTrack/3.01B
HTM:200:404:200:200:200:---:200:200:200:400:200:200:200:404:+++:+++:500:500:500:500:500:500:500:+++::Netscape-Enterprise/3.5-For-NetWare
HTM:200:200:200:200:400:400:400:400:200:400:200:200:404:404:+++:200:---:401:401:200:200:---:404:+++::Netscape-Enterprise/3.6 SP3
HTM:200:200:400:400:400:400:400:400:400:400:400:200:404:404:+++:400:500:401:401:200:200:500:404:+++::Netscape-Enterprise/3.6 SP3
HTM:200:200:200:HTM:HTM:HTM:200:HTM:200:HTM:HTM:200:HTM:HTM:+++:+++:200:200:200:200:200:200:200:+++:Netscape-Enterprise/6\.0:SunONE 6.0 on Solaris 7
# Which SP?
200:200:200:505:HTM:HTM:---:501:HTM:200:---:---:200:HTM:HTM:---:400:405:401:401:200:200:501:501:200::Netscape-Enterprise/4.1 (which SP?)
HTM:200:200:505:HTM:HTM:HTM:501:HTM:200:HTM:HTM:200:HTM:HTM:+++:+++:404:401:401:200:200:501:501:+++::Netscape-Enterprise/4.1
HTM:401:200:505:HTM:HTM:HTM:501:HTM:401:HTM:HTM:401:HTM:HTM:+++:+++:401:401:401:401:200:501:501:401:Netscape-Enterprise/4\.1:Netscape Enterprise 4.1 SP13 console (access denied) on Linux
HTM:200:200:505:HTM:HTM:HTM:501:HTM:200:HTM:HTM:200:HTM:HTM:+++:+++:405:401:401:200:200:501:501:200:Netscape-Enterprise/(4\.1|6\.0): iPlanet 4.1 SP13 or SunONE 6.0 SP1/SP6 on Linux
HTM:401:200:505:HTM:HTM:HTM:501:HTM:401:HTM:HTM:401:HTM:HTM:+++:+++:500:500:500:500:200:501:501:401:Netscape-Enterprise/6\.0:SunONE 6.0 SP1 or SP6 console (access denied) on Linux
HTM:302:200:505:HTM:HTM:HTM:501:HTM:302:HTM:HTM:302:HTM:HTM:+++:+++:500:500:500:500:200:501:501:401:Netscape-Enterprise/6\.0:SunONE 6.0 SP1 or SP6 console (access granted) on Linux
# Broken banner?
HTM:200:200:505:HTM:HTM:HTM:501:HTM:200:HTM:HTM:200:HTM:HTM:HTM:400:404:401:401:200:501:501:501:+++:.USBR.:SunONE 6.1 on Solaris 8
HTM:200:200:505:HTM:HTM:HTM:501:HTM:200:HTM:HTM:200:HTM:HTM:+++:400:404:405:405:200:200:501:501:+++::Sun-ONE-Application-Server/7.0.0_01
#
HTM:200:404:200:200:400:400:403:200:200:400:200:200:200:404:404:200:500:403:403:403:200:403:403:+++::NetWare-Enterprise-Web-Server/5.1
HTM:---:400:---:---:200:---:501:200:---:---:---:---:---:---:+++:400:404:403:403:403:403:501:501:+++::OmniHTTPd/2.10
500:200:501:200:200:200:500:200:200:500:500:500:200:302:302:302:200:404:405:405:405:405:405:405:302:.*:OMSA (Dell OpenManage Server Administrator)
# Oracle9iAS (9.0.3.0.0) Containers for J2EE
# Oracle9iAS (9.0.4.0.0) Containers for J2EE
# Oracle Application Server Containers for J2EE 10g (9.0.4.0.0)
---:200:400:200:200:---:---:400:200:---:---:---:---:400:400:+++:200:100:404:404:404:404:404:404:+++:^(Oracle9iAS|Oracle Application Server).*Containers for J2EE:Oracle AS containers for J2EE (9i or 10g)
# Oracle9iAS (9.0.2.0.0) Containers for J2EE
# Oracle9iAS (1.0.2.2.1) Containers for J2EE
---:200:400:200:200:---:---:200:200:---:400:200:---:400:400:+++:200:100:404:404:404:404:404:404:+++:^Oracle9iAS \([19]\.0\.2\.[02]\.[01]\) Containers for J2EE:Oracle9iAS Containers for J2EE
# Unreliable signature: a proxy was on the way
xxx:200:200:200:200:200:xxx:200:200:200:HTM:xxx:200:400:400:+++:400:404:404:404:404:404:404:404:+++::Oracle9iAS (1.0.2.2.1) Containers for J2EE
200:200:200:200:400:400:400:501:400:200:400:400:200:400:400:+++:400:404:405:404:200:200:404:501:+++::Oracle AS10g/9.0.4 Oracle HTTP Server OracleAS-Web-Cache-10g/9.0.4.0.0 (N)
200:200:501:200:400:400:400:200:400:200:400:400:200:400:400:+++:400:404:501:501:501:501:501:501:+++::OracleAS-Web-Cache-10g/9.0.4.0.0
400:200:200:200:400:400:400:501:400:400:400:400:200:400:400:+++:400:100:100:404:200:200:404:501:+++::Oracle9iAS/9.0.2 Oracle HTTP Server Oracle9iAS-Web-Cache/Oracl
###
# Orion (java server) 
200:200:400:200:200:---:---:200:200:404:400:200:---:400:400:+++:+++:100:404:404:404:404:404:404:+++::Orion/2.0.1
# VMS web server
HTM:200:403:200:200:200:xxx:xxx:xxx:200:xxx:xxx:200:403:403:403:200:501:401:501:501:501:501:501:401::OSU/3.10a;UCX
HTM:200:403:200:200:200:xxx:xxx:xxx:200:xxx:xxx:200:403:403:+++:200:403:403:403:403:403:403:403:+++::OSU/3.2alpha2
xxx:200:403:200:200:200:HTM:xxx:xxx:200:xxx:HTM:200:403:403:403:200:403:403:403:403:403:403:403:+++::OSU/3.6b;Multinet
#
400:200:400:200:200:200:400:200:200:400:400:400:---:400:400:+++:200:---:---:---:---:---:---:---:+++::Polycom-WS/1.0
# Quicktime?
400:200:400:400:200:400:400:400:400:200:400:400:200:302:302:+++:200:404:400:400:400:400:400:400:+++::QTSS 3.0 Admin Server/1.0
HTM:200:200:505:400:400:400:200:400:500:400:400:200:400:400:+++:400:404:404:404:404:200:404:404:+++::Rapid Logic/1.1
---:200:501:200:200:200:---:200:200:---:---:---:---:404:404:+++:200:500:501:501:501:501:501:501:+++::RapidLogic/1.1
404:200:---:200:200:200:---:200:200:---:---:---:---:404:404:+++:200:---:---:---:---:---:---:---:+++::RapidLogic/1.1
# Resin/2.1.11 (Windows)
# Resin/2.1.9 (Gentoo/Linux) - standard & EE
# Resin/2.0.4
HTM:200:HTM:200:200:HTM:---:200:200:200:---:---:200:HTM:HTM:HTM:400:404:501:501:501:501:501:501:200::Resin/2
xxx:302:HTM:200:302:xxx:---:302:302:302:---:---:302:xxx:xxx:xxx:400:200:501:501:501:501:501:501:302::Resin/2.1.6
# Very odd - I got two different signatures on a Win32 machine (the Resin/2 above and this one)
400:200:500:200:400:400:400:400:400:200:400:400:200:500:500:500:200:404:501:501:200:200:501:501:200::Resin/2.1.11
# sh-httpd 0.3 or 0.4 (who uses this gizmo?)
200:200:501:200:200:200:200:501:200:200:501:200:---:404:404:+++:200:501:501:501:501:501:501:501:404:ShellHTTPD/:sh-httpd
#
200:200:400:200:200:200:400:200:200:400:400:400:200:200:200:404:200:---:400:400:400:400:400:400:+++::AnalogX SimpleServer 1.23
---:200:400:200:200:200:400:400:200:400:400:400:400:200:200:+++:200:404:404:400:400:400:400:400:+++::SonicWALL
---:200:400:200:200:200:400:400:200:400:400:400:---:200:200:+++:200:404:404:400:400:400:400:400:+++::SonicWALL
# PRO 330 / Firmware 6.5.0.4 / ROM  6.4.0.0 / VPN Hardware Accelerator
---:200:---:200:---:---:---:---:---:---:---:---:---:200:200:---:200:---:---:---:---:---:---:---:+++::SonicWALL
# Spyglass_MicroServer/2.01FC1
# Spyglass_MicroServer/2.00FC4
HTM:200:404:200:400:HTM:HTM:200:HTM:HTM:HTM:HTM:200:404:404:+++:400:100:100:404:404:404:404:404:+++::Spyglass_MicroServer/2.0
# Tiny HTTPD
HTM:200:501:VER:VER:VER:xxx:VER:xxx:200:xxx:xxx:200:200:200:200:400:404:501:501:501:501:501:501:400::thttpd/2.24
HTM:200:501:HTM:HTM:HTM:HTM:200:HTM:200:HTM:HTM:200:200:200:+++:+++:404:501:501:501:501:501:501:400:thttpd/2\.2:thttpd/2.24
HTM:200:501:HTM:HTM:HTM:400:200:HTM:200:400:400:200:400:400:+++:+++:404:501:501:501:501:501:501:200::thttpd/2.20c
#
200:200:---:200:200:200:---:200:200:---:---:---:200:HTM:HTM:+++:200:---:---:---:---:---:---:---:+++::Toaster 
# Tomcat  4.0.1 on a Sun Management Console (SMC 3.5)
HTM:200:400:200:200:200:400:501:400:400:400:414:414:400:400:+++:+++:405:405:405:200:200:501:501:+++::Apache Tomcat/2.1
HTM:200:200:200:200:200:400:200:200:200:400:400:200:200:200:+++:200:200:200:200:200:200:200:200:+++::Apache Tomcat Web Server/3.3.1 Final
---:200:400:505:505:505:---:505:505:---:---:---:200:404:400:+++:+++:404:403:403:200:200:501:501:+++:Apache Coyote/1\.0:Apache Tomcat 4.2.24
---:---:200:505:---:---:---:---:---:---:---:---:---:---:---:---:---:404:403:403:200:200:501:501:+++:Apache-Coyote/1\.1:Apache Tomcat 5.0.14 Beta
HTM:200:200:505:505:505:---:505:505:---:---:---:200:200:400:+++:400:404:403:403:200:200:501:501:+++::Apache-Coyote/1.1
#
404:200:404:404:404:404:404:404:404:404:404:404:404:404:404:+++:404:404:404:404:404:404:404:404:+++::TUX/2.0 (Linux)
# VM
HTM:200:400:200:200:200:HTM:200:HTM:HTM:HTM:HTM:200:404:200:+++:+++:404:400:400:400:400:400:400:200::Webshare/1.2.3 VM_ESA/2.3.0.9808 CMS/14.808 REXX/4.01 CMS_Pipelines/1.0110 REXX_SOCKETS/3.01
# 
---:200:---:200:200:200:---:---:---:---:---:---:---:404:404:+++:200:---:---:---:---:---:---:---:+++::VCS-VideoJet-Webserver
---:200:---:200:200:200:---:404:---:---:---:---:---:404:404:+++:200:---:---:---:---:---:---:---:+++::VCS-VideoJet-Webserver
404:200:501:200:200:200:400:200:200:404:501:400:200:400:400:+++:200:404:501:501:501:501:501:501:+++::Viavideo-Web
# VNC HTTPD (no banner!)
200:200:---:200:200:200:---:---:200:200:404:---:200:404:404:---:200:---:---:---:---:---:---:---:404:^$:VNC HTTPD (RFB 003.003)
200:200:---:200:200:200:---:---:200:---:---:---:200:404:404:+++:200:---:---:---:---:---:---:---:+++:^$:VNC HTTPD
#
400:200:501:200:200:200:400:501:200:200:400:400:200:404:404:+++:200:501:501:501:501:501:501:501:+++::RealVNC/4.0
# Found on a Wago Ethernet Buscoupler 750-342
404:200:501:200:200:200:400:501:200:501:501:400:200:404:404:+++:200:404:501:501:501:501:501:501:+++:.*:WAGO-I/O-System
HTM:200:400:HTM:HTM:HTM:---:200:HTM:200:---:---:200:400:400:+++:400:---:403:403:403:403:403:403:+++::WALT HTTP Server, v2.11 (22.04.03)
# Webfs (another gizmo?)
400:200:400:200:400:400:400:400:400:400:400:400:200:400:400:+++:+++:501:501:400:400:400:400:400:+++::webfs/1.20
# Webmin
---:200:200:200:200:200:---:200:200:200:200:200:200:200:200:+++:+++:200:200:200:200:200:200:200:200:MiniServ/:Webmin (MiniServ/0.01)
# WebLogic
---:200:200:200:200:200:---:200:200:200:---:---:200:200:200:404:200:200:200:200:200:200:200:200:+++::WebLogic Portal 8.1 Thu Jul 10 20:09:22 PDT 2003 84868 with
# WAS - probably not a very reliable banner, as 408 = TimeOut
408:200:408:200:200:200:408:200:200:408:408:408:200:408:408:+++:408:200:200:200:200:200:200:200:+++::WebSphere Application Server/5.0
HTM:200:HTM:200:200:200:HTM:200:200:HTM:HTM:HTM:200:HTM:HTM:+++:400:200:200:200:200:200:200:200:+++::WebSphere Application Server/5.0
# 4D WebStar
---:500:200:200:---:500:---:---:---:500:---:---:500:500:500:500:500:404:405:405:200:405:405:405:500:^4D_WebSTAR_S/5\.[23]\.[0124] \(MacOS X\):4D_WebSTAR_S/5.2.4-5.3.2 (MacOS X)
---:200:200:200:---:200:---:---:---:200:---:---:200:404:404:404:200:404:405:405:200:405:405:405:200:^4D_WebSTAR_S/5\.[23]\.[1234] \(MacOS X\):4D_WebSTAR_S/5.2.3-5.3.2 (MacOS X)
---:200:200:200:---:200:---:---:---:200:---:---:200:404:404:404:200:404:401:401:401:401:401:401:200:^4D_WebSTAR_S/5\.3\.[12] \(MacOS X\):4D_WebSTAR_S/5.3.1-2 (MacOS X)
---:500:501:200:400:400:400:400:400:---:---:---:500:500:500:500:500:404:405:405:501:501:501:501:500::4D_WebSTAR_S/5.3.1 (MacOS X)
---:302:200:200:---:302:---:---:---:302:---:---:302:404:404:404:302:404:405:405:200:405:405:405:---::4D_WebSTAR_S/5.3.1 (MacOS X)
---:500:200:200:---:500:---:---:---:500:---:---:500:500:500:500:500:404:401:401:401:401:401:401:500::4D_WebSTAR_S/5.3.2 (MacOS X)
#
HTM:200:200:HTM:HTM:HTM:HTM:501:HTM:200:HTM:HTM:200:200:200:+++:400:404:501:501:404:200:501:501:+++::WN/2.2.10
200:200:501:200:200:200:400:200:200:501:501:501:---:200:200:+++:200:501:501:501:501:501:501:501:+++::XES 8830 WindWeb/1.0
HTM:200:400:200:400:HTM:HTM:---:HTM:HTM:HTM:HTM:200:400:400:+++:400:100:100:200:200:200:200:200:+++::Xerox_MicroServer/Xerox11
# YaWS, a web server written in Erlang; I got those banners
# Yaws/1.01 Yet Another Web Server
# Yaws/1.22 Yet Another Web Server
200:200:200:---:---:---:---:---:---:200:---:---:200:404:404:---:200:---:---:---:200:---:---:---:---:Yaws/1\.[02][12] Yet Another Web Server:Yaws/1.01 or Yaws/1.22
# New version, new behaviour...
200:200:200:---:400:400:400:400:400:200:400:400:200:404:404:---:200:---:501:501:200:501:501:501:200::Yaws/1.30 Yet Another Web Server
200:200:200:---:400:400:400:400:400:200:400:400:200:404:404:403:200:---:501:501:200:501:501:501:200::Yaws/1.31 Yet Another Web Server
#
HTM:404:501:400:404:400:400:501:400:404:400:400:404:400:400:400:400:404:404:501:501:501:501:501:404::Zeus/3.3
HTM:404:501:400:404:400:---:501:400:404:---:---:404:404:404:---:404:404:404:501:501:501:501:501:404::Zeus/3.3
HTM:200:501:400:200:400:400:501:400:200:400:400:200:200:200:200:400:200:200:501:501:501:501:501:200::Zeus/3.3
HTM:200:501:400:200:400:400:501:400:200:400:400:200:400:400:400:400:404:404:501:501:501:501:501:200::Zeus/3.3
HTM:200:501:400:200:400:400:501:400:200:400:400:200:400:400:400:200:404:404:501:501:501:501:501:200::Zeus/3.3
xxx:200:501:400:200:400:400:501:400:200:400:400:200:400:400:400:400:404:404:501:501:501:501:501:200::Zeus/3.3
HTM:200:400:400:200:400:400:501:400:200:400:400:200:400:400:400:400:405:405:501:501:501:501:501:200::Zeus/4.0
HTM:404:400:400:400:400:400:501:400:404:400:400:404:400:400:400:400:405:405:405:405:405:405:501:404::Zeus/4.1
HTM:403:400:400:400:400:400:501:400:403:400:400:403:400:400:400:400:405:405:405:405:405:405:501:403::Zeus/4.1
HTM:404:400:400:400:400:400:501:400:404:400:400:404:404:404:404:400:405:405:405:405:405:405:501:404::Zeus/4.2
HTM:404:400:400:400:400:500:501:400:404:500:500:404:400:400:400:404:405:405:405:405:405:405:501:404::Zeus/4.2
HTM:404:400:400:400:400:500:501:400:404:500:500:404:400:400:400:404:405:403:403:405:405:405:501:404::Zeus/4.2
HTM:404:400:400:400:400:400:501:400:404:400:400:404:400:400:400:400:405:403:403:405:405:405:501:404::Zeus/4.2
HTM:404:400:400:400:400:---:---:400:---:---:---:---:404:404:404:404:405:405:405:405:405:405:---:404::Zeus/4.2
HTM:404:400:400:400:400:500:400:400:400:500:500:404:404:404:404:404:405:405:405:405:405:405:501:404::Zeus/4.2
HTM:200:400:400:400:400:400:501:400:200:400:400:200:400:400:400:400:405:405:405:405:405:405:501:200::Zeus/4.2
# Zope/(Zope 2.5.1 (OpenBSD package zope-2.5.1p1)
# And also Linux Gentoo, according to some old tests? I m not sure any more
500:200:404:VER:400:400:400:400:400:400:400:400:---:404:404:404:200:404:404:404:200:404:404:404:200::Zope/(Zope 2.5.1 (OpenBSD package zope-2.5.1p1)
# Zope/(Zope 2.6.2 (source release, python 2.1, linux2), python 2.1.3, linux2) ZServer/1.1b1
# Zope/(Zope 2.6.1 (source release, python 2.1, linux2), python 2.1.3, linux2) ZServer/1.1b1
# Zope/(Zope 2.6.1 (binary release, python 2.1,linux2-x86), python 2.1.3, linux2) ZServer/1.1b1
# Zope/(Zope 2.5.1 (OpenBSD package zope-2.5.1p1) [yes the same server can give a different signature!]
500:200:404:VER:400:400:400:400:400:400:400:400:---:404:404:404:200:404:401:404:200:404:404:404:200:^Zope/\(Zope 2\.[56]\.:Zope 2.5.or 2.6
#
400:404:501:VER:404:400:400:404:400:400:400:400:404:400:400:400:404:404:501:501:501:501:501:501:404::0W/0.6e
400:404:501:VER:404:400:400:404:400:400:400:400:404:400:400:400:404:400:501:501:501:501:501:501:404::0W/0.7e [no /]
400:200:501:VER:200:400:400:200:400:400:400:400:200:400:400:400:200:400:501:501:501:501:501:501:200::0W/0.7
#End of list";


#### Start of main code

include("http_func.inc");
include("misc_func.inc");

port = get_kb_item("Services/www");
if (! port) port = 80;
if (! get_port_state(port)) exit(0);

ver = int(get_kb_item("http/" + port));
no404 = get_kb_item("www/no404/" + port);

bad = 0;
debug = 0;

####

global_var	wa;	# Reused by "no200" detection

function testreq(port, request, no404, no200)
{
  local_var	s, i, c, h, b;

  for (i = 0; i < 3; i ++)
  {
    s = http_open_socket(port);
    if (!s)
      sleep(1);
    else
      break;
  }
  if (! s) return NULL;	# Server is dead
  send(socket: s, data: request);
  c = recv_line(socket: s, length: 1024);
  if (c)
  {
    h = http_recv_headers(s);
    if (h)
      b = http_recv_body(socket: s, headers: h);
   }
  http_close_socket(s);
  if (! c) return '---';

  wa = strcat(c, h, '\r\n', b);	# Whole answer

  if (debug > 3) display("code=", c, "\n");

  if (! ereg(string: c, pattern: "^HTTP(/[0-9]\.[0-9])? +[0-9][0-9][0-9] "))
  {
    if (c =~ "^HTTP/[0-9A-Z.]* ")
      return 'VER';

    if (wa =~ '^[ \t\r\n]*<\\?xml')
      return 'XML';	# Maybe I should return HTM ?

    if (wa =~ '^[ \t\r\n]*<[ \t\r\n]*(HTML|TITLE|HEAD|BODY)[ \t\r\n]*>' ||
	wa =~ '^[ \t\r\n]*<[ \t\r\n]*META[ \t\r\n]' ||
	wa =~ '^[ \t\r\n]*<[ \t\r\n]*H[1-9]>.*' ||
	wa =~ '^[ \t\r\n]*<script +language="JavaScript"' ||
	wa =~ '^[ \t\r\n]*<!DOCTYPE +HTML' ||
	# If we get an HTML comment, there is a high probability that what 
	# comes next is HTML
	wa =~ '^[ \t\r\n]*<!--.*-->')
      return 'HTM';
    else if (wa =~ '501 Method not implemented')
      return 501;
    else
    {
      if (debug > 1)
        display("\n**** Request ****\n", request, "**** answer ****\n", wa, "****\n");
      return 'xxx';
    }
  }

  if (c =~ "^HTTP(/[0-9.]+)? 200" && no404 && no404 >< wa)
    return 404;
  if (c=~ "^HTTP(/[0-9.]+)? 404" && no200 && no200 >< wa)
    return 200;

  c = strstr(c, ' ');
  return int(substr(c, 1, 3));
}

function same_start(s1, s2)
{
  local_var	l, l2, i;

  l = strlen(s1);
  l2 = strlen(s2);
  if (l > l2) l = l2;

  for (i = 0; i < l; i ++)
   if (s1[i] != s2[i])
     return 0;
  return 1;
}

#### Banner

banner = get_http_banner(port: port);
if (banner)
{
  xheaders = ""; b = banner;
  while (1)
  {
    # Interesting headers: X-Powered-By, Ms-Author-Via, ETag,
    # and Via (a proxy may disturb the signature)
    xx = egrep(pattern: '^(([a-zA-Z-]*Via)|(X-[a-zA-Z-]+)|ETag):', string: b);
    if (!xx) break;
    # egrep may return a multiline result
    foreach x (split(xx)) {
      b -= x;
      x -= '\r';
      xheaders += x;
    }
  }    
  banner = egrep(pattern: '^Server:', string: banner);
}
if (debug > 0 && xheaders)
  display("Server=", banner, "\n**** X ****\n", xheaders, "***********\n");

if (banner)
{
  banner = ereg_replace(string: banner, pattern: "^Server: *(.*)$", replace: "\1");
  banner -= '\r\n';
}

#### Reference request

r = http_get(port: port, item: "/");
t = testreq(port: port, request: r, no404: no404);
no200="";

redir = NULL;
slash_is_forbidden = NULL;

if (! t)
{
  # Very unreliable!
  if (debug > 0) display("hmap: server is dead or very slow\n");
  exit(0);
}
else if (t == 'H')
{
  if (ver > 9)
  {
    display("hmap: inconsistent HTTP/0.9 answer with version ", ver, "\n");
    exit(0);
  }
  ver = 9;
}
else if (t == 301 || t == 302 || t == 303)
{
  if (debug > 0) display("hmap: / is redirected, signature may be unreliable\n");
  redir = t;
  if (debug > 1) display("redir=", redir, "\n");
  bad ++;	# Is this so bad?
}
else if (t == 404)
{
  if (debug > 0) display("hmap: / is not found, expect problems\n");
  # Try to fix
  no200 = egrep(string: wa, pattern: ".*(<h1>[^<]*</h1>).*", icase: 1);
  if (! no200)
    no200 = egrep(string: wa, pattern: ".*(<h2>[^<]*</h2>).*", icase: 1);
  if (no200)
    no200 = ereg_replace(string: no200, pattern: ".*(<h[12]>[^<]*</h[12]>).*", icase: 1, replace: "\1");
  if (no200 && debug > 1) display("no200=", no200, "\n");
  if (! no200) bad ++;
}
else if (t == 401)
{
# Note that we should not do this with 403, because it might be returned by
# some servers which "forbid" some odd requests.
  slash_is_forbidden = "401";
}
else if (t != 200)
{
  if (debug > 0)
   display("hmap: / is forbidden or in error, expect problems (code=", t, ")\n");
  bad ++;
}

last_code = t;
broken_srv = 1;

####

h = get_host_name();

reqL1 = make_list(
'GET /\r\n\r\n',				# HTTP/0.9
'GET / HTTP/1.0\r\n\r\n',			# HTTP/1.0
## Removed: always got 200
##'GET / HTTP/1.1\r\nHost: ' + h + '\r\n\r\n',	# HTTP/1.1
'OPTIONS * HTTP/1.1\r\nHost: ' + h + '\r\n\r\n',# OPTIONS *
'GET / HTTP/3.14\r\nHost: ' + h + '\r\n\r\n',	# SciFi
'GET / HTTP/1.X\r\n\r\n',			# Alphanum HTTP version
'GET / HTTP/\r\n\r\n',				# Incomplete
'GET\r\n\r\n',					# Very incomplete!
'get / http/1.0\r\n\r\n',			# Lowercase method
'GET / NESSUS/1.0\r\n\r\n',			# Unknown protocol
'GET\t/\tHTTP/1.0\r\n\r\n',			# Tab separator
'GET/HTTP/1.0\r\n\r\n',				# No separator
'GET\n/\nHTTP/1.0\r\n\r\n',			# \n instead of blank
'GET / HTTP/1.0\n\n',				# LF instead of CRLF
'GET \\ HTTP/1.0\r\n\r\n',			# Windows like URI
'GET . HTTP/1.0\r\n\r\n',			# relative URI
'HEAD .. HTTP/1.0\r\n\r\n',			# relative + forbidden
'GET / HTTP/1.1\r\n\r\n'			# Incomplete HTTP/1.1 request
);
# 16 requests

methods = make_list(
## GET & HEAD removed: always returned 404
	'POST',
	'PUT', 'DELETE',
	'OPTIONS', 'TRACE',
## MOVE, MKCOL, PROPFIND, PROPPATCH, LOCK, UNLOCK 
## returned the same results as COPY
	'COPY', 'SEARCH'
	);

# Dangerous requests
reqL2 = make_list(
string("GET ", crap(data: "////////", length: 1024), " HTTP/1.0\r\n\r\n")
);

sign = ""; 
rawsign = "";

# Ignore safe_checks if server is supposed to be Apache:
# 1. the server is not vulnerable to a too long request
# 2. we need such request to differentiate close versions or 
#    configurations.
no_dangerous_req = safe_checks() && (banner !~ "^Apache");

# Get authorization string - we do not support complex schemes here
a = get_kb_item("/tmp/http/auth/"+port);
if (! a)
 a = get_kb_item("http/auth");

foreach r (reqL1)
{
  if (a)
    r = str_replace(find: '\n', string: r, replace: '\n'+a+'\r\n', count: 1);
  t = testreq(port: port, request: r, no404: no404, no200: no200);
  if (isnull(t)) break;
  if (t != last_code) broken_srv = 0;
  rawsign = strcat(rawsign, t, ":");
  if (t == redir || t == slash_is_forbidden) t = "200";
  sign = strcat(sign, t, ":");
}

foreach m (methods)
{
  if (a)
    r = str_replace(find: '\n', string: r, replace: '\n'+a+'\r\n', count: 1);
  r = http_get(item: "/" + rand_str(), port: port);
  r = ereg_replace(pattern: "^GET", replace: m, string: r);
  t = testreq(port: port, request: r, no404: no404, no200: no200);
  if (isnull(t)) break;
  if (t != last_code) broken_srv = 0;
  rawsign = strcat(rawsign, t, ":");
  if (t == redir || t == slash_is_forbidden) t = "200";
  sign = strcat(sign, t, ":");
}

if (! no_dangerous_req)
  foreach r (reqL2)
  {
    t = testreq(port: port, request: r, no404: no404, no200: no200);
    if (isnull(t)) break;
    if (t != last_code) broken_srv = 0;
    rawsign = strcat(rawsign, t, ":");
    if (t == redir || t == slash_is_forbidden) t = "200";
    sign = strcat(sign, t, ":");
  }

if (debug > 0) display("sign   = ", sign, "\n");
if (debug > 0) display("rawsign= ", rawsign, "\n");

if (xheaders && debug > 0)
  display("--- xheaders ---\n", xheaders, "----------------\n");
s = egrep(string: fingerprints, pattern :  "^"+rawsign+"[^:]*:.*$");
if (!s)
s = egrep(string: fingerprints, pattern :  "^"+sign+"[^:]*:.*$");

# TBD: if Etag is present, there should be a way to match it.

if (broken_srv)
{
  security_warning(port: port, data: "
The software that is listening on this port always returns 
the same code to any request. It is not a real web server and 
it may confuse Nessus.

Risk: none");
  set_kb_item(name: "www/fake/"+port, value: TRUE);
  exit(0);
}

#### Fuzzy match

if (!s) 
{
results = split(sign, sep: ":");	# keep: 0

foreach sig (split(fingerprints))	# keep: 0
{
  if (! match(string: sig, pattern: "#*")) {
    v = split(sig, sep: ":");	# keep: 0
    n = max_index(v);
    if (n > 22)	# ?
    {
      srv = v[n-1] - '\n';
      re = v[n-2];
      diff = 0;
      for (i = 0; i < n-2; i ++)
        if (v[i] != '+++:' && v[i] != results[i])
          diff ++;
      differences[srv] = diff;
      if (diff == 0 && !s)
      {
        #display("S=", sign, "\n matches: \nS=", sig, "\n");
        s = sig; 
        break;
       }
     }
  }
}

m = 999999;
foreach d (differences) { if (d < m) m = d; }
hyp = ""; prev = ""; nb_hyp = 0;
foreach i (keys(differences))
  if (differences[i] == m)
  {
    if (i != prev)
      hyp = string(hyp, i, "\n");
    prev = i;
    nb_hyp ++;
  }
## display("nb_hyp=", nb_hyp, "\n");
}

if (no_dangerous_req)	# Add joker
  for (i = max_index(reqL2); i > 0; i --)
    sign = strcat(sign, "+++:");

set_kb_item(name: "www/hmap/"+port+"/signature", value: sign);

if (s)
{
  r = split(s, sep: ":");
  n = max_index(r); re = r[n-2] - ":"; srv = r[n-1]; srv -= '\n';
  ##display("banner=", banner, "\nRE=", re, "\nSRV=", srv, "\n");

  if (re)
    set_kb_item(name: "www/hmap/"+port+"/banner_regex", value: re);
  if (srv)
    set_kb_item(name: "www/hmap/"+port+"/description", value: srv);

  if (! banner)
  {
    if (re == "^$")
      security_note(port: port, 
                    data: strcat("This web server was fingerprinted as: ", srv));
    else
    security_note(port: port, 
                  data: strcat("Although it tries to hide its version, 
this web server was fingerprinted as: ", srv));
  }
  else if (	re && ereg(string: banner, pattern: re) ||
		! re && banner == srv )
  {
    security_note(port: port, 
                  data: strcat("This web server was fingerprinted as ", 
	srv, "
which is consistent with the displayed banner: ", banner));
    set_kb_item(name: "www/hmap/"+port+"/banner_ok", value: 1);
  }
  else if (! re && same_start(s1: banner, s2: srv))
  {
    security_note(port: port, 
                  data: strcat("This web server was fingerprinted as ", 
	srv, "
This seems to be consistent with the displayed banner: ", banner));
    set_kb_item(name: "www/hmap/"+port+"/banner_ok", value: 1);
  }
  else
  {
    rep = strcat("This web server was fingerprinted as: ", srv, "
which is not consistent with the displayed banner: ", banner);
    if (!bad)
    {
      rep = strcat(rep, '\n\n', 
	"If you think that Nessus was wrong, please send this signature 
to www-signatures@nessus.org :
", sign + "FIXME:" + banner + '\n');
      if (xheaders)
        rep = rep + 'Including these headers:\n' + xheaders;
    }
    security_note(port: port, data: rep);
    set_kb_item(name: "www/hmap/"+port+"/banner_ok", value: 0);
  }
  exit(0);
}

####

rep = "Nessus was not able to ";
if (bad)
  rep = string(rep, "reliably");
else
  rep = string(rep, "exactly");
rep = string(rep, " identify this server. It might be:\n", 
	hyp, "The fingerprint differs from these known signatures on ", 
	m, " point(s)\n");

# Should I store this results in the KB?

####

if (!bad)
{
  rep = rep + "
If you know what this server is and if you are using an up to date version
of this script, please send this signature to www-signatures@nessus.org :
" + sign + ":" + banner + '\n';
  if (xheaders)
    rep = rep + 'Including these headers:\n' + xheaders;
 rep += "
Try to provide as much information as you can: software & operating 
release, sub-version, patch numbers, and specific configuration option, 
if any.";
}

security_note(port: port, data: rep);
