#  This script was written by David Maciejak <david dot maciejak at kyxar dot fr>
#  based on work from
#  (C) Tenable Network Security
#
# Ref:
#  Date: Wed, 9 Jun 2004 15:00:04 +0200
#  From: Stefan Esser <s.esser@e-matters.de>
#  To: full-disclosure@lists.netsys.com, bugtraq@securityfocus.com,
#        red@heisec.de, news@golem.de
#  Subject: Advisory 09/2004: More CVS remote vulnerabilities
#
# This script is released under the GNU GPL v2

if(description)
{
 script_id(12265);
 script_version ("$Revision: 1.5 $");
 script_bugtraq_id(10499);
 script_cve_id("CAN-2004-0414");
 script_cve_id("CAN-2004-0416");
 script_cve_id("CAN-2004-0417"); 
 script_cve_id("CAN-2004-0418"); 
 if ( defined_func("script_xref") ) script_xref(name:"RHSA", value:"RHSA-2004:233-017");
 
 name["english"] = "CVS malformed entry lines flaw";
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote CVS server, according to its version number, might allow an 
attacker to execute arbitrary commands on the remote system because of
a flaw relating to malformed Entry lines which lead to a
missing NULL terminator.

Among the issues deemed likely to be exploitable were:

- a double-free relating to the error_prog_name string (CAN-2004-0416)
- an argument integer overflow (CAN-2004-0417)
- out-of-bounds writes in serv_notify (CAN-2004-0418)

Solution : Upgrade to CVS 1.12.9 or 1.11.17
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Logs into the remote CVS server and asks the version";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 David Maciejak");
 family["english"] = "General";
 script_family(english:family["english"]);
 script_require_ports("Services/cvspserver", port);
 script_dependencies("find_service.nes", "cvs_public_pserver.nasl");
 exit(0);
}

port = get_kb_item("Services/cvspserver");
if(!port)port = 2401;
if(!get_port_state(port))exit(0);

login = get_kb_item(string("cvs/", port, "/login"));
pass  = get_kb_item(string("cvs/", port, "/pass"));
dir   = get_kb_item(string("cvs/", port, "/dir"));

if(!login || !dir) {
	soc = open_sock_tcp(port);
	if(!soc)exit(0);

	req = string("BEGIN AUTH REQUEST\n",
	"/\n",
	"\n",
	"A\n",
	"END AUTH REQUEST\n");
	send(socket:soc, data:req);
	r = recv_line(socket:soc, length:4096);
	if("repository" >< r || "I HATE" >< r)
		{
		str = 
string("The remote host is running a CVS server on this port, but
Nessus could not determine which version is running.

Some remote CVS servers might allow an attacker to execute arbitrary 
commands on the remote system because because of a flaw relating to malformed Entry
lines which lead to a missing NULL terminator.

Among the issues deemed likely to be exploitable were:

- a double-free relating to the error_prog_name string (CAN-2004-0416)
- an argument integer overflow (CAN-2004-0417)
- out-of-bounds writes in serv_notify (CAN-2004-0418)

*** This may be a false positive, check the version of CVS locally

Solution : Upgrade to CVS 1.12.9 or 1.11.17
Risk factor : High");

		security_hole(port:port, data:str);
		}
	}

soc = open_sock_tcp(port);
if(!soc)exit(0);

req = string("BEGIN AUTH REQUEST\n",
dir, "\n",
login,"\n",
"A", pass,"\n",
"END AUTH REQUEST\n");

  send(socket:soc, data:req);
  r = recv_line(socket:soc, length:4096);
  if("I LOVE YOU" >< r)
  {
    send(socket:soc, data:string("version\n"));
    r = recv_line(socket:soc, length:4096);
    if("Concurrent" >< r)
    {
     set_kb_item(name:string("cvs/", port, "/version"), value:r);
     if(ereg(pattern:".* 1\.([0-9]\.|10\.|11\.([0-9][^0-9]|1[0-6])|12\.[0-8][^0-9]).*", string:r))
     	security_hole(port);
    }
  }
  close(soc);
 
