# This script was automatically generated from 
#  http://www.gentoo.org/security/en/glsa/glsa-200503-01.xml
# It is released under the Nessus Script Licence.
# The messages are release under the Creative Commons - Attribution /
# Share Alike license. See http://creativecommons.org/licenses/by-sa/2.0/
#
# Avisory is copyright 2001-2005 Gentoo Foundation, Inc.
# GLSA2nasl Convertor is copyright 2004 Michel Arboi

if (! defined_func('bn_random')) exit(0);

if (description)
{
 script_id(17248);
 script_version("$Revision: 1.1 $");
 script_xref(name: "GLSA", value: "200503-01");

 desc = 'The remote host is affected by the vulnerability described in GLSA-200503-01
(Qt: Untrusted library search path)


    Tavis Ormandy of the Gentoo Linux Security Audit Team has
    discovered that Qt searches for shared libraries in an untrusted,
    world-writable directory.
  
Impact

    A local attacker could create a malicious shared object that would
    be loaded by Qt, resulting in the execution of arbitrary code with the
    privileges of the Qt application.
  
Workaround

    There is no known workaround at this time.
  

Solution: 
    All Qt users should upgrade to the latest version:
    # emerge --sync
    # emerge --ask --oneshot --verbose ">=x11-libs/qt-3.3.4-r2"
  

Risk factor : Medium
';
 script_description(english: desc);
 script_copyright(english: "(C) 2005 Michel Arboi");
 script_name(english: "[GLSA-200503-01] Qt: Untrusted library search path");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Gentoo Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys('Host/Gentoo/qpkg-list');
 script_summary(english: 'Qt: Untrusted library search path');
 exit(0);
}

include('qpkg.inc');
if (qpkg_check(package: "x11-libs/qt", unaffected: make_list("ge 3.3.4-r2"), vulnerable: make_list("lt 3.3.4-r2")
)) { security_warning(0); exit(0); }
