#TRUSTED 904e566ef745b9d59e3fea60e90298380b7f96f91b399e359d5928f95a1b2608803ae91b41e3e0ed5c027fe80f6f76a03931ac75ab8a421d085a34f1c54cd717ba4a5cf0607687d2760428e571315af141483e7a324cbd05146d9c87e3ab89a58fc70f5fbecfd616cdb6406b5004a8bff555b04c8b7e500a1a096294058dc4faf5064f4de219ecce53c7ea617bca47f5614bdccaa99a01d23aaf1057c9afae6328fc34e5bcbb45d1b74d1f47fe84a0f90f635eba171a471e457589202e2d919fe1d0c043afa09f7c16b7fcf862768c50e55337829c0ca0c49255ccde503c92b1942598e0faa33a94c1cb7d6d22cb2d414a9ff1f78a70993769cd0e3f1ca0c8991276ad7f0a2790b45ff632e24dce9c27c9b49dc474a66b43571e780bc5382f607f0d35b0dc099161a4d6342a0d6bf8a763c749a132b036a9183cb3f693abea21a5e27a5fb5689a1c1b68e216b0c6f2cd4a4b11a39b62bd581a66b9283dc91a50ed3cbf2c3293656fccf5f7083ea061bd0278d834b6b022d24b91e59982a8bb2f6920b263aa4025dfa6c8f740fbc7013ae1eea16477dc8a77d023effc5c042958986287a3d49a2aa524b7cf33fb21053890db215df8bd59c9c0d151060033358d6827176f9be4264ea12b3aa286edb31659e5e19eeb7cd72ba8a149be5df31a9a27117d32a021a36d5f14b0a4a7a398c3dae635a7657036dea796a4e32f1792cc
#
# This script was written by Michel Arboi <arboi@alussinan.org>
#
# GPL
#

if (! defined_func("script_get_preference_file_location")) exit(0);
if (! find_in_path("hydra")) exit(0);


if(description)
{
 script_id(15870);
 script_version ("1.2");
 name["english"] = "Hydra: Cisco enable";
 script_name(english:name["english"]);
 
 desc["english"] = "
This plugin runs Hydra to find Cisco 'enable' passwords by brute force.

See the section 'plugins options' to configure it
";

 script_description(english:desc["english"]);
 
 summary["english"] = "Brute force 'Cisco enable' authentication with Hydra";
 script_summary(english:summary["english"]);
 
 script_category(ACT_ATTACK);
 
 script_add_preference(name: "Logon password : ", type: "entry", value: "");

 script_copyright(english:"This script is Copyright (C) 2004 Michel Arboi");
 script_family(english:"Brute force attacks");
 script_require_keys("Secret/hydra/passwords_file");
 script_require_ports("Services/telnet", 23);
 script_dependencies("hydra_options.nasl", "find_service.nes", "doublecheck_std_services.nasl", "hydra_cisco.nasl");
 exit(0);
}

#

throrough = get_kb_item("global_settings/thorough_tests");
if ("yes" >!< throrough) exit(0);
passwd = get_kb_item("Secret/hydra/passwords_file");
if (passwd == NULL) exit(0);

port = get_kb_item("Services/telnet");
if (! port) port = 23;
if (! get_port_state(port)) exit(0);
soc = open_sock_tcp(port);
if (! soc) exit(0);
r = recv(socket: soc, length: 1024);
close(soc);
if ("Password:" >!< r) exit(0);

# Logon password is required
pass = script_get_preference("Logon password : ");
if (! pass)
{
 l = get_kb_list("Hydra/cisco/"+port);
 if (isnull(l)) exit(0);
 foreach pass (l)
   if (! pass)
    break;
 if (! pass) exit(0);
}

timeout = get_kb_item("/tmp/hydra/timeout"); timeout = int(timeout);
tasks = get_kb_item("/tmp/hydra/tasks"); task = int(tasks);

empty = get_kb_item("/tmp/hydra/empty_password");
exit_asap = get_kb_item("/tmp/hydra/exit_ASAP");
tr = get_kb_item("Transports/TCP/"+port);

i = 0;
argv[i++] = "hydra";
argv[i++] = "-s"; argv[i++] = port;
argv[i++] = "-P"; argv[i++] = passwd;
if (empty)
{
  argv[i++] = "-e"; argv[i++] = "n";
}
if (exit_asap) argv[i++] = "-f";
if (tr >= ENCAPS_SSLv2) argv[i++] = "-S";

if (timeout > 0)
{
  argv[i++] = "-w";
  argv[i++] = timeout;
}
if (tasks > 0)
{
  argv[i++] = "-t";
  argv[i++] = tasks;
}

argv[i++] = get_host_ip();
argv[i++] = "cisco-enable";
argv[i++] = pass;

report = "";
results = pread(cmd: "hydra", argv: argv, nice: 5);
foreach line (split(results))
{
  v = eregmatch(string: line, pattern: 'host:.*(login: *.*)? password: *(.*)$');
  if (! isnull(v))
  {
    # l = chomp(v[1]);
    p = chomp(v[2]);
    report = strcat(report, p, '\n');
    set_kb_item(name: "Hydra/cisco-enable/"+port, value: p);
  }
}

if (report)
  security_hole(port: port, 
    data: 'Hydra was able to find the following Cisco enable passwords:\n' + report);
