#TRUSTED aafa0e83b3a21a7c49045a4baea49498b4facc034a29c8e90db72914ee8ead16a07649b68b98f80e482363483743e243210586655ebba6ea6d24397d5496bcf108c7dbe6d91f1c045a25d23fa907e4c6e52ab9c269819e289d62f7ced406c352917f8dc5f9c0aa849bc6670db8266e5dff69cd1b8fa3fb3eb453b96aa8073d5ee8502d30bc02128edcbe272bb148199d2209f0d6a3cf9eba0fe0cb0ea358876d3c458f55e392fe2dcde4fde92f2b86b956ac1f07095ba576426564573008c869b150e35e618fb701265eeb35ac73424b42706ff5560c051089118171e903d353dae86bc79275e2567344b63875836ba96801d623570bab0f1d84ed18424c5221d692545eec1a724b59dc523541ecc491e9ec5647752aa11f59c85235a925c66c5e0fddb4fc9ab2b633c1fe0653364d960fbc408898bbd61c383ff967ed2cd6f33a8375db1494dcf52c197313303a15746007b0e9b77306096f90d0a88ae7dbf1fbf09e5bdd9afffc995c51807fcde5f2572a75656baa1595837626d1f3ba36366287d7870760f66a7e53bb6b67949b5e6f82276a28061e197c1cec460b6b7b50baf3bb11f890dbd3ac984376e3ffa482fd138b8f2ae75b9b3c8627850388f37c6b07f398c2bc55ac1ee22a9939e6b92c4f73473f86d53d8e99ad30293ac93ccca98f40f33f0a33a29e6c7943475ce7d2354f667ea6d78eb28c2130950b1ea98c
#
# This script was written by Michel Arboi <arboi@alussinan.org>
#
# GPL
#

if (! defined_func("script_get_preference_file_location")) exit(0);
if (! find_in_path("hydra")) exit(0);


if(description)
{
 script_id(15872);
 script_version ("1.2");
 name["english"] = "Hydra: FTP";
 script_name(english:name["english"]);
 
 desc["english"] = "
This plugin runs Hydra to find FTP accounts & passwords by brute force.

See the section 'plugins options' to configure it
";

 script_description(english:desc["english"]);
 
 summary["english"] = "Brute force FTP authentication with Hydra";
 script_summary(english:summary["english"]);
 
 script_category(ACT_ATTACK);
 
 script_copyright(english:"This script is Copyright (C) 2004 Michel Arboi");
 script_family(english:"Brute force attacks");
 script_require_keys("Secret/hydra/logins_file", "Secret/hydra/passwords_file");
 script_require_ports("Services/ftp", 21);
 script_dependencies("hydra_options.nasl", "find_service.nes", "doublecheck_std_services.nasl", "find_service_3digits.nasl");
 exit(0);
}

#
throrough = get_kb_item("global_settings/thorough_tests");
if ("yes" >!< throrough) exit(0);
logins = get_kb_item("Secret/hydra/logins_file");
passwd = get_kb_item("Secret/hydra/passwords_file");
if (logins == NULL || passwd == NULL) exit(0);

port = get_kb_item("Services/ftp");
if (! port) port = 21;
if (! get_port_state(port)) exit(0);

timeout = get_kb_item("/tmp/hydra/timeout"); timeout = int(timeout);
tasks = get_kb_item("/tmp/hydra/tasks"); task = int(tasks);

empty = get_kb_item("/tmp/hydra/empty_password");
login_pass = get_kb_item("/tmp/hydra/login_password");
exit_asap = get_kb_item("/tmp/hydra/exit_ASAP");
tr = get_kb_item("Transports/TCP/"+port);

i = 0;
argv[i++] = "hydra";
argv[i++] = "-s"; argv[i++] = port;
argv[i++] = "-L"; argv[i++] = logins;
argv[i++] = "-P"; argv[i++] = passwd;
s = "";
if (empty) s = "n";
if (login_pass) s+= "s";
if (s)
{
  argv[i++] = "-e"; argv[i++] = s;
}
if (exit_asap) argv[i++] = "-f";
if (tr >= ENCAPS_SSLv2) argv[i++] = "-S";

if (timeout > 0)
{
  argv[i++] = "-w";
  argv[i++] = timeout;
}
if (tasks > 0)
{
  argv[i++] = "-t";
  argv[i++] = tasks;
}

argv[i++] = get_host_ip();
argv[i++] = "ftp";

report = "";
results = pread(cmd: "hydra", argv: argv, nice: 5);
foreach line (split(results))
{
  v = eregmatch(string: line, pattern: 'host:.*login: *(.*) password: *(.*)$');
  if (! isnull(v))
  {
    l = chomp(v[1]);
    p = chomp(v[2]);
    report = strcat(report, 'username: ', l, '\tpassword:', p, '\n');
    set_kb_item(name: 'Hydra/ftp/'+port, value: l + '\t' + p);
  }
}

if (report)
  security_hole(port: port, 
    data: 'Hydra was able to break the following FTP accounts:\n' + report);
