#TRUSTED 54f842d0da0fa4146b87c080889cb6346ad2f2a72df4bfa2490a309d46d5250a2b4e4675e107cbd33f54c1208bad6c50ce454b234e79573c45a7d3dd33490a4c28ec50106e3cbea0eb6c6f6579518eb3eceab7c1c34bd57036d1a4af1ea4b24831891f680dd2fa0a4186d87ff4d714ea019e626c4086a1bc07650eaac4f5ecdeae449badb39d3750cf8f10d10b2a3d9f2169170ad3173baf3538dc193982298a4a78492fc476eaed13b3d288ba766af368509fa8b4ab3da654b9fb618104d335cf75502277e9cee59046e729e6fa5f3535f3984743d7c964d11c984388d860cd0b51cbf48448e2caef42c3b3dcf904689a6f8496585a026e71b7e7d229ac77aa5a8f59d440ca77a2720b23848bb8c8e41ca9aa77076dcbf1d11e5db4af5704e07e941dd835d0e2a54e777ec04a18c1282b5c4f4649541bfd237647d9b94c3cc5a8235ac2a758513649e7b084acfeb8698aebf7f894475d10df4a6020908344b8db81c612c15b6261b1ab37c13b92107b9887ee7ffa169737951a30f065e56ee9e70a41afc4e55fa325a6173047d0871983575c7689565ec24ee4a2e95e15f09cda93a98f79e446ab843fb2d2c77fa60a14c00ec25ec46d28b07b59962a6510ad901e71da3b060c9ce81847b7cdd02a4a94f150c0880546b8eb88ffee07374cd5336c1ff2bf382383e02c0d2cb31b12425267e197724a462d32f1a12c31bd8c90
#
# This script was written by Michel Arboi <arboi@alussinan.org>
#
# GPL
#

if (! defined_func("script_get_preference_file_location")) exit(0);
if (! find_in_path("hydra")) exit(0);


if(description)
{
 script_id(15873);
 script_version ("1.2");
 name["english"] = "Hydra: HTTP";
 script_name(english:name["english"]);
 
 desc["english"] = "
This plugin runs Hydra to find HTTP passwords by brute force.

See the section 'plugins options' to configure it
";

 script_description(english:desc["english"]);
 
 summary["english"] = "Brute force HTTP authentication with Hydra";
 script_summary(english:summary["english"]);
 
 script_category(ACT_ATTACK);
 
 script_add_preference(name: "Web page (required) :", value: "/", type: "entry");

 script_copyright(english:"This script is Copyright (C) 2004 Michel Arboi");
 script_family(english:"Brute force attacks");
 script_require_keys("Secret/hydra/logins_file", "Secret/hydra/passwords_file");
 script_require_ports("Services/www", 80);
 script_dependencies("hydra_options.nasl", "find_service.nes", "doublecheck_std_services.nasl");
 exit(0);
}

#

throrough = get_kb_item("global_settings/thorough_tests");
if ("yes" >!< throrough) exit(0);
logins = get_kb_item("Secret/hydra/logins_file");
passwd = get_kb_item("Secret/hydra/passwords_file");
if (logins == NULL || passwd == NULL) exit(0);

port = get_kb_item("Services/www");
if (! port) port = 80;
if (! get_port_state(port)) exit(0);

timeout = get_kb_item("/tmp/hydra/timeout"); timeout = int(timeout);
tasks = get_kb_item("/tmp/hydra/tasks"); task = int(tasks);

empty = get_kb_item("/tmp/hydra/empty_password");
login_pass = get_kb_item("/tmp/hydra/login_password");
exit_asap = get_kb_item("/tmp/hydra/exit_ASAP");
tr = get_kb_item("Transports/TCP/"+port);

i = 0;
argv[i++] = "hydra";
argv[i++] = "-s"; argv[i++] = port;
argv[i++] = "-L"; argv[i++] = logins;
argv[i++] = "-P"; argv[i++] = passwd;
s = "";
if (empty) s = "n";
if (login_pass) s+= "s";
if (s)
{
  argv[i++] = "-e"; argv[i++] = s;
}
if (exit_asap) argv[i++] = "-f";
if (tr >= ENCAPS_SSLv2) argv[i++] = "-S";

if (timeout > 0)
{
  argv[i++] = "-w";
  argv[i++] = timeout;
}
if (tasks > 0)
{
  argv[i++] = "-t";
  argv[i++] = tasks;
}

argv[i++] = get_host_ip();
argv[i++] = "http";

opt = script_get_preference("Web page (required) :");
if (! opt) exit(0);
argv[i++] = opt;

report = "";
results = pread(cmd: "hydra", argv: argv, nice: 5);
foreach line (split(results))
{
  v = eregmatch(string: line, pattern: 'host:.*login: *(.*) password: *(.*)$');
  if (! isnull(v))
  {
    l = chomp(v[1]);
    p = chomp(v[2]);
    report = strcat(report, 'username: ', l, '\tpassword: ', p, '\n');
    set_kb_item(name: 'Hydra/http/'+port, value: l + '\t' + p);
  }
}

if (report)
  security_hole(port: port, 
    data: 'Hydra was able to break the following HTTP accounts:\n' + report);
