#TRUSTED 820f588bad839fce376c5f1dca09ae8c112b53e1cd45e6fab2ccab1846710ad8eb5b4add0cfb22763c90887ee7f3b25eb572ba26f560967f091b55438d0f3b903fefc0bc2ef24e412875f971e2e9c19965872d021c7d4ea0478628856b3cbe5f8699757a17f4472848b3021fefdaabc75bad3331809927ebdea200a32968e744a31be141d9d3213a77bc706d385f200868757238da5154ff0674e5e2e01419633fc9487558d9646ea21560db0ffeb9038f398b09a41868e4393a47e07eeb4a21e289cc775e5fd2564dc40daaf8e2b0f14e52765777cc007fd454dd0d9be5cbcb3669ec28fdc5e66b7c69bbe857b245d59e6c8c37bd0939fac5eb5b0b6b8fba29538dceab7711a98249f2b82fce39e000c741b1d89c102ee2816c8e86c5158f2ab404db2b88cf85abf184ae62e78bcdfb74bf0d965229581825d4a128384939500709ec99e8e388416d0f9157a45d2e7ff6c6f3bc8bce1ba48d1bf142d91f9350d57b122599659f188e4129515ee1a015c7ba12d20e984a7b50b083b767bd8732182e22eec4730f4646616bdf3670dcf235c6dd28aa61b035219fce9236ccb5aa92b0b7b59658e75b2eb67b8daed1b9394fe4eb808c9b3d202def97d674da746e50cab5c623dc081e05e6eb0bb775e150832d9c65b4443f14b7a6ddbbf62e11d424d67784f5d83f95ef266fe6170141bb25c629086acdce79925a895ef854b8bd
#
# This script was written by Michel Arboi <arboi@alussinan.org>
#
# GPL
#

if (! defined_func("script_get_preference_file_location")) exit(0);
if (! find_in_path("hydra")) exit(0);


if(description)
{
 script_id(15876);
 script_version ("1.2");
 name["english"] = "Hydra: IMAP";
 script_name(english:name["english"]);
 
 desc["english"] = "
This plugin runs Hydra to find IMAP accounts & passwords by brute force.

See the section 'plugins options' to configure it
";

 script_description(english:desc["english"]);
 
 summary["english"] = "Brute force IMAP authentication with Hydra";
 script_summary(english:summary["english"]);
 
 script_category(ACT_ATTACK);
 
 script_copyright(english:"This script is Copyright (C) 2004 Michel Arboi");
 script_family(english:"Brute force attacks");
 script_require_keys("Secret/hydra/logins_file", "Secret/hydra/passwords_file");
 script_require_ports("Services/imap", 143);
 script_dependencies("hydra_options.nasl", "find_service.nes", "doublecheck_std_services.nasl");
 exit(0);
}

#

throrough = get_kb_item("global_settings/thorough_tests");
if ("yes" >!< throrough) exit(0);
logins = get_kb_item("Secret/hydra/logins_file");
passwd = get_kb_item("Secret/hydra/passwords_file");
if (logins == NULL || passwd == NULL) exit(0);

port = get_kb_item("Services/imap");
if (! port) port = 143;
if (! get_port_state(port)) exit(0);

timeout = get_kb_item("/tmp/hydra/timeout"); timeout = int(timeout);
tasks = get_kb_item("/tmp/hydra/tasks"); task = int(tasks);

empty = get_kb_item("/tmp/hydra/empty_password");
login_pass = get_kb_item("/tmp/hydra/login_password");
exit_asap = get_kb_item("/tmp/hydra/exit_ASAP");
tr = get_kb_item("Transports/TCP/"+port);

i = 0;
argv[i++] = "hydra";
argv[i++] = "-s"; argv[i++] = port;
argv[i++] = "-L"; argv[i++] = logins;
argv[i++] = "-P"; argv[i++] = passwd;
s = "";
if (empty) s = "n";
if (login_pass) s+= "s";
if (s)
{
  argv[i++] = "-e"; argv[i++] = s;
}
if (exit_asap) argv[i++] = "-f";
if (tr >= ENCAPS_SSLv2) argv[i++] = "-S";

if (timeout > 0)
{
  argv[i++] = "-w";
  argv[i++] = timeout;
}
if (tasks > 0)
{
  argv[i++] = "-t";
  argv[i++] = tasks;
}

argv[i++] = get_host_ip();
argv[i++] = "imap";

report = "";
results = pread(cmd: "hydra", argv: argv, nice: 5);
foreach line (split(results))
{
  v = eregmatch(string: line, pattern: 'host:.*login: *(.*) password: *(.*)$');
  if (! isnull(v))
  {
    l = chomp(v[1]);
    p = chomp(v[2]);
    report = strcat(report, 'username: ', l, '\tpassword: ', p, '\n');
    set_kb_item(name: 'Hydra/imap/'+port, value: l + '\t' + p);
  }
}

if (report)
  security_hole(port: port, 
    data: 'Hydra was able to break the following IMAP accounts:\n' + report);
