#TRUSTED a7f328c94e2b2e0298ea151210e8cfc61b9218f005f115fdc9f2a14c9ea834320dd0973c5c459a4dcd75ea1af6d5ee6c4fb71bac4f6b2956a1c6fa77e4c4675b00b60f527ff745a63cd46d2320ff53844e95f016cf0978ea6605ba383a3d81752177e3b2ddbadad686dbb28f58d1a35ffb190a42154ced0e5d4b5a3aacbe7a5cd569be70c4b540f47052fe3c31609c4af1a868936f151463d7a05b2abf9d8a9b32c205e8efdacb2a6a8773f7e1972b8498ecd492030b84ddf00714ca853b35e3cb6e902b0bb425458b158854060cf4afa3537ff8dceca9e01d7e77bbac17b3ac922750f4d8ef1d036f9d12346124e7987bc7eb26e7521d19027626b95ad07634f3d807a24d383514ec324ef0bcfed4be46929f07cd123e77247cde7c4253e25e6fd042aaf6cf1ad3ddc9589a3daab89307277ef250982645daf9aba3f19bc05e742c26a54425073113a030d541d248107b950fbde5b17389ccdfa8f9d003b0931f7edca703c9ece5fcbd981581100b9c92e09c45023e6cdaf3d774144fca92910b04fbb3c9a73e519f79767c9cc162da60f82baadfdd7bff182d7e5242c4711e70bb998347f00d25daea324069028a1d105d3765aa5e18fcc6ea3ce795f755dc28f8106eef90000544874cc6c75b10716d2b3d94665859da188e25ecb7295342f2afeb04710985fb56641b77dbc03b189cd4e9d733be219d54c8b655b200d11a
#
# This script was written by Michel Arboi <arboi@alussinan.org>
#
# GPL
#

if (! defined_func("script_get_preference_file_location")) exit(0);
if (! find_in_path("hydra") ) exit(0);


if(description)
{
 script_id(15882);
 script_version ("1.2");
 name["english"] = "Hydra: rexec";
 script_name(english:name["english"]);
 
 desc["english"] = "
This plugin runs Hydra to find rexec accounts & passwords by brute force.

See the section 'plugins options' to configure it
";

 script_description(english:desc["english"]);
 
 summary["english"] = "Brute force rexec authentication with Hydra";
 script_summary(english:summary["english"]);
 
 script_category(ACT_ATTACK);
 
 script_copyright(english:"This script is Copyright (C) 2004 Michel Arboi");
 script_family(english:"Brute force attacks");
 script_require_keys("Secret/hydra/logins_file", "Secret/hydra/passwords_file");
 script_require_ports("Services/rexecd", 512);
 script_dependencies("hydra_options.nasl", "find_service.nes", "rexecd.nasl");
 exit(0);
}

#

throrough = get_kb_item("global_settings/thorough_tests");
if ("yes" >!< throrough) exit(0);
logins = get_kb_item("Secret/hydra/logins_file");
passwd = get_kb_item("Secret/hydra/passwords_file");
if (logins == NULL || passwd == NULL) exit(0);

port = get_kb_item("Services/rexecd");
if (! port) port = 512;
if (! get_port_state(port)) exit(0);

timeout = get_kb_item("/tmp/hydra/timeout"); timeout = int(timeout);
tasks = get_kb_item("/tmp/hydra/tasks"); task = int(tasks);

empty = get_kb_item("/tmp/hydra/empty_password");
login_pass = get_kb_item("/tmp/hydra/login_password");
exit_asap = get_kb_item("/tmp/hydra/exit_ASAP");
tr = get_kb_item("Transports/TCP/"+port);

i = 0;
argv[i++] = "hydra";
argv[i++] = "-s"; argv[i++] = port;
argv[i++] = "-L"; argv[i++] = logins;
argv[i++] = "-P"; argv[i++] = passwd;
s = "";
if (empty) s = "n";
if (login_pass) s+= "s";
if (s)
{
  argv[i++] = "-e"; argv[i++] = s;
}
if (exit_asap) argv[i++] = "-f";
if (tr >= ENCAPS_SSLv2) argv[i++] = "-S";

if (timeout > 0)
{
  argv[i++] = "-w";
  argv[i++] = timeout;
}
if (tasks > 0)
{
  argv[i++] = "-t";
  argv[i++] = tasks;
}

argv[i++] = get_host_ip();
argv[i++] = "rexec";

report = "";
results = pread(cmd: "hydra", argv: argv, nice: 5);
foreach line (split(results))
{
  v = eregmatch(string: line, pattern: 'host:.*login: *(.*) password: *(.*)$');
  if (! isnull(v))
  {
    l = chomp(v[1]);
    p = chomp(v[2]);
    report = strcat(report, 'login: ', l, '\tpassword: ', p, '\n');
    set_kb_item(name: 'Hydra/rexec/'+port, value: l + '\t' + p);
  }
}

if (report)
  security_hole(port: port, 
    data: 'Hydra was able to break the following Rexec accounts:\n' + report);
