#TRUSTED 0e48bc1e25610e427205ee11684e52fa25c8d60b44c3cf14ebb1a5f92161f85effb8e91d09e11cf351204748d8c01d9232cd2d000ce83e3f3f89e1a1e072d370c7cad88d5c60a1628a6d4866ccd62751f8cc6088d2824779d4507afb7dd8d2ac17805eaeb0788550f2fba90ad71c4856d1154f51ca69b5c7fba6e4dc64da11169d065d41d3ffc1a0827a4a54b3b3c5ff50540dd188b9275b1ce137d40cd08d37e3f79f62e7b2c502d0db5240e9b5df07180cc2f8a6f53fdbc6b14a669ca8adb2c746f53f011b7b60ca5de87a8f58fbd1cadd0d6fa700e5fe960d2cee7c6cb547c77d3de74da63f9a65f3547c246068f1780233057cdeda40b930abdcbc206d593365a6ac984cf35f981696467e44570fbd9336bf9f9070fdbb9fa29fd1431d091a31d170bd896983976e8cd57212593daacfb7d62d0081f951f6d5ec25ea5efa320895985be78171baa58ced8a48a61658ee0d0ba9890c7ec8c0f08201ad8d58de0b9ecc05b793dcfd4089ec2d4533857253dc65717f8bf3f9391dd8304a676590092606fe7b1d735b9d73c5f5acb74ec5d8e762db7c73f8a33377e5c25fea9ae3a556c8e8d95256351f292d58659d1a1856bf8205e3e1740ea75f5dfd428ae7e28a76d6c6380b3329e2aa5c35063ea1ffad439c463fc5c4ae533cac005ea892b6f8d6488151707af12cc0ec2cb1c4b5b1bcc27c5bfa10e873da0a2a40dcdf2e
#
# This script was written by Michel Arboi <arboi@alussinan.org>
#
# GPL
#

if (! defined_func("script_get_preference_file_location")) exit(0);
if (! find_in_path("hydra") ) exit(0);


if(description)
{
 script_id(15886);
 script_version ("1.2");
 name["english"] = "Hydra: SNMP";
 script_name(english:name["english"]);
 
 desc["english"] = "
This plugin runs Hydra to find SNMP passwords by brute force.

See the section 'plugins options' to configure it
";

 script_description(english:desc["english"]);
 
 summary["english"] = "Brute force SNMP authentication with Hydra";
 script_summary(english:summary["english"]);
 
 script_category(ACT_ATTACK);
 
 script_copyright(english:"This script is Copyright (C) 2004 Michel Arboi");
 script_family(english:"Brute force attacks");
 script_require_keys("Secret/hydra/passwords_file");
 script_require_udp_ports(161, 32789);
 script_dependencies("hydra_options.nasl", "snmp_default_communities.nasl");
 exit(0);
}

#

throrough = get_kb_item("global_settings/thorough_tests");
if ("yes" >!< throrough) exit(0);
passwd = get_kb_item("Secret/hydra/passwords_file");
if (passwd == NULL) exit(0);

port = get_kb_item("SNMP/port");
if (port) exit(0);
# Yes! We exit if we know the port, and thus some common community name
port = 161;
if (! get_udp_port_state(port)) exit(0);

timeout = get_kb_item("/tmp/hydra/timeout"); timeout = int(timeout);
tasks = get_kb_item("/tmp/hydra/tasks"); task = int(tasks);

empty = get_kb_item("/tmp/hydra/empty_password");
exit_asap = get_kb_item("/tmp/hydra/exit_ASAP");

i = 0;
argv[i++] = "hydra";
argv[i++] = "-s"; argv[i++] = port;
argv[i++] = "-P"; argv[i++] = passwd;
if (empty)
if (s)
{
  argv[i++] = "-e"; argv[i++] = "n";
}
if (exit_asap) argv[i++] = "-f";

if (timeout > 0)
{
  argv[i++] = "-w";
  argv[i++] = timeout;
}
if (tasks > 0)
{
  argv[i++] = "-t";
  argv[i++] = tasks;
}

argv[i++] = get_host_ip();
argv[i++] = "snmp";

report = "";
results = pread(cmd: "hydra", argv: argv, nice: 5);
foreach line (split(results))
{
  v = eregmatch(string: line, pattern: 'host:.*(login: *.*)? password: *(.*)$');
  if (! isnull(v))
  {
    p = chomp(v[2]);
    report = strcat(report, p, '\n');
    set_kb_item(name: 'Hydra/snmp/'+port, value: p);
  }
}

if (report)
  security_hole(port: port, 
    data: 'Hydra was able to break the following SNMP communities:\n' + report);
