/*
 * Copyright (C) 2009 Canonical Ltd
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as 
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Neil Jagdish Patel <neil.patel@canonical.com>
 *
 */

#ifndef _NL_FAVORITE_H_
#define _NL_FAVORITE_H_

#include <glib.h>
#include <clutter/clutter.h>
#include <clutk/clutk.h>

#define NL_TYPE_FAVORITE (nl_favorite_get_type ())

#define NL_FAVORITE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj),\
        NL_TYPE_FAVORITE, NlFavorite))

#define NL_FAVORITE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass),\
        NL_TYPE_FAVORITE, NlFavoriteClass))

#define NL_IS_FAVORITE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj),\
        NL_TYPE_FAVORITE))

#define NL_IS_FAVORITE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass),\
        NL_TYPE_FAVORITE))

#define NL_FAVORITE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj),\
        NL_TYPE_FAVORITE, NlFavoriteClass))

typedef struct _NlFavorite        NlFavorite;
typedef struct _NlFavoriteClass   NlFavoriteClass;

typedef enum
{
  NL_FAVORITE_VIEW_FIXED,
  NL_FAVORITE_VIEW_FLOATING
} NlFavoriteViewType; 

struct _NlFavorite
{
  CtkBin        parent;	
};

struct _NlFavoriteClass
{
  CtkBinClass   parent_class;

  /*< signals >*/
  void (*begin_drag_move) (NlFavorite *self, ClutterMotionEvent *event);
  void (*remove_me)       (NlFavorite *self);
  void (*active)          (NlFavorite *self);

  /*< vtable >*/
  const gchar        * (*get_name) (NlFavorite *self);
  GdkPixbuf          * (*get_icon) (NlFavorite *self);
  void                 (*removed)  (NlFavorite *self);
  NlFavoriteViewType   (*get_view_type) (NlFavorite *self);
};

GType                nl_favorite_get_type   (void) G_GNUC_CONST;

const gchar        * nl_favorite_get_name (NlFavorite *self);

GdkPixbuf          * nl_favorite_get_icon (NlFavorite *self);

void                 nl_favorite_removed  (NlFavorite *self);

NlFavoriteViewType   nl_favorite_get_view_type (NlFavorite *self);


#endif /* _NL_FAVORITE_H_ */

