from twisted.application import service, strports

from nevow import inevow, rend, loaders, tags, appserver, static, guard, liveevil

import sys

try:
    import customform
    import disktemplates
    import disktemplates_stan
    import simple
    import simplehtml
    import tree
    import formpost2
    import formpost
    import children
    import childrenhtml
    import tablehtml
    import irenderer
    import simple_irenderer
    import formbuilder
    import db
    import hellohtml
    import hellostan
    import canvas
    import manualform
    import guarded
    import guarded2
    import xul_nevow
    import advanced_manualform
    import liveanimal
    import most_basic
    import http_auth
    import logout_guard
    import logout_guard2
    import objcontainer
    from chatola import chatola
    from i18n import i18n, xmli18n
    import cal
    import tabbed
    import progress
    from nevow import livetest
    import testexamples
except ImportError, e:
    if str(e).find('No module named') != -1:
        msg = """Please check the following things:
* You are not root
* You are running examples.tac from examples directory or examples
    directory is in the PYTHONPATH

A possible fix could be to run examples.tac with the following
command:
    PYTHONPATH=/path/to/examples/ twistd -noy examples.tac"""
        raise Exception(msg)
    raise e
except AttributeError, e:
    if str(e).find("'module' object has no attribute") != -1:
        msg = """Please check that nevow and formless are correctly installed"""
        raise Exception(msg)
    raise e

class Sources(rend.Page):
    def __init__(self, path, _):
        rend.Page.__init__(self, path)

    def render_htmlizer(self, ctx, path):
        from twisted.python import htmlizer
        from StringIO import StringIO
        output = StringIO()
        htmlizer.filter(open(path), output, writer=htmlizer.SmallerHTMLWriter)
        return tags.xml(output.getvalue())

    docFactory = loaders.stan(
    tags.html[
        tags.head[
            tags.title["Python source file: ", str],
            tags.link(type='text/css', rel='stylesheet', href='/cssfile')],
        tags.body[
            render_htmlizer]])


class Examples(rend.Page):
    addSlash = True ## This is a directory-like resource
    docFactory = loaders.xmlfile('index.html')
    child_sources = static.File('.', defaultType='text/plain')
    child_sources.processors['.py'] = Sources
    child_sources.contentTypes = {}
    child_cssfile = static.File('index.css')
    children = dict(
        customform=customform.Root(),
        disktemplates=disktemplates.Mine(),
        disktemplates_stan=disktemplates_stan.Mine(),
        simple=simple.Simple(),
        simplehtml=simplehtml.Simple(),
        tree=tree.Tree('base', 'base'),
        formpost2=formpost2.FormPage(formpost2.Implementation()),
        formpost=formpost.FormPage(),
        children=children.RootPage(),
        childrenhtml=childrenhtml.RootPage(),
        tablehtml=tablehtml.Table(),
        irenderer=irenderer.Page(),
        simple_irenderer=simple_irenderer.Page(),
        formbuilder=formbuilder.FormBuilder(),
        db=db.DBBrowser(),
        hellohtml=hellohtml.Page(),
        hellostan=hellostan.Page(),
        canvas=canvas.createResource(),
        manualform=manualform.Page(),
        guarded=guarded.createResource(),
        guarded2=guarded2.createResource(),
        xul_nevow=xul_nevow.createResource(),
        advanced_manualform=advanced_manualform.Page(),
        liveanimal=liveanimal.createResource(),
        chatola=chatola.createResource(),
        http_auth=http_auth.AuthorizationRequired(),
        most_basic=most_basic.root,
        logout_guard=logout_guard.createResource(),
        logout_guard2=logout_guard2.createResource(),
        objcontainer=objcontainer.createResource(),
        i18n=i18n.createResource(),
        xmli18n=xmli18n.createResource(),
        calendar=cal.Calendar(),
        tabbed=tabbed.TabbedPage(),
        progress=progress.createResource(),
        tests=testexamples.createResource(),
        livetests=testexamples.createLiveSuite(),
        testtests=livetest.createResource(),
        )

application = service.Application("examples")
strports.service("8080", appserver.NevowSite(Examples(), logPath="web.log")).setServiceParent(application)
