BEGIN TRANSACTION;

    CREATE TEMPORARY TABLE instances_backup (
        created_at DATETIME,
        updated_at DATETIME,
        deleted_at DATETIME,
        deleted BOOLEAN,
        id INTEGER NOT NULL,
        internal_id INTEGER,
        admin_pass VARCHAR(255),
        user_id VARCHAR(255),
        project_id VARCHAR(255),
        image_ref VARCHAR(255),
        kernel_id VARCHAR(255),
        ramdisk_id VARCHAR(255),
        server_name VARCHAR(255),
        launch_index INTEGER,
        key_name VARCHAR(255),
        key_data TEXT,
        state INTEGER,
        state_description VARCHAR(255),
        memory_mb INTEGER,
        vcpus INTEGER,
        local_gb INTEGER,
        hostname VARCHAR(255),
        host VARCHAR(255),
        user_data TEXT,
        reservation_id VARCHAR(255),
        scheduled_at DATETIME,
        launched_at DATETIME,
        terminated_at DATETIME,
        display_name VARCHAR(255),
        display_description VARCHAR(255),
        availability_zone VARCHAR(255),
        locked BOOLEAN,
        os_type VARCHAR(255),
        launched_on TEXT,
        instance_type_id INTEGER,
        vm_mode VARCHAR(255),
        uuid VARCHAR(36),
        architecture VARCHAR(255),
        PRIMARY KEY (id),
        CHECK (locked IN (0, 1)),
        CHECK (deleted IN (0, 1))
    );

    INSERT INTO instances_backup
        SELECT created_at,
               updated_at,
               deleted_at,
               deleted,
               id,
               internal_id,
               admin_pass,
               user_id,
               project_id,
               image_ref,
               kernel_id,
               ramdisk_id,
               server_name,
               launch_index,
               key_name,
               key_data,
               state,
               state_description,
               memory_mb,
               vcpus,
               local_gb,
               hostname,
               host,
               user_data,
               reservation_id,
               scheduled_at,
               launched_at,
               terminated_at,
               display_name,
               display_description,
               availability_zone,
               locked,
               os_type,
               launched_on,
               instance_type_id,
               vm_mode,
               uuid,
               architecture
        FROM instances;

    DROP TABLE instances;

    CREATE TABLE instances (
        created_at DATETIME,
        updated_at DATETIME,
        deleted_at DATETIME,
        deleted BOOLEAN,
        id INTEGER NOT NULL,
        internal_id INTEGER,
        admin_pass VARCHAR(255),
        user_id VARCHAR(255),
        project_id VARCHAR(255),
        image_ref VARCHAR(255),
        kernel_id VARCHAR(255),
        ramdisk_id VARCHAR(255),
        server_name VARCHAR(255),
        launch_index INTEGER,
        key_name VARCHAR(255),
        key_data TEXT,
        state INTEGER,
        state_description VARCHAR(255),
        memory_mb INTEGER,
        vcpus INTEGER,
        local_gb INTEGER,
        hostname VARCHAR(255),
        host VARCHAR(255),
        user_data TEXT,
        reservation_id VARCHAR(255),
        scheduled_at DATETIME,
        launched_at DATETIME,
        terminated_at DATETIME,
        display_name VARCHAR(255),
        display_description VARCHAR(255),
        availability_zone VARCHAR(255),
        locked BOOLEAN,
        os_type VARCHAR(255),
        launched_on TEXT,
        instance_type_id INTEGER,
        vm_mode VARCHAR(255),
        uuid VARCHAR(36),
        architecture VARCHAR(255),
        mac_address VARCHAR(255),
        PRIMARY KEY (id),
        CHECK (locked IN (0, 1)),
        CHECK (deleted IN (0, 1))
    );

    INSERT INTO instances
        SELECT created_at,
               updated_at,
               deleted_at,
               deleted,
               id,
               internal_id,
               admin_pass,
               user_id,
               project_id,
               image_ref,
               kernel_id,
               ramdisk_id,
               server_name,
               launch_index,
               key_name,
               key_data,
               state,
               state_description,
               memory_mb,
               vcpus,
               local_gb,
               hostname,
               host,
               user_data,
               reservation_id,
               scheduled_at,
               launched_at,
               terminated_at,
               display_name,
               display_description,
               availability_zone,
               locked,
               os_type,
               launched_on,
               instance_type_id,
               vm_mode,
               uuid,
               architecture,
               NULL AS mac_address
        FROM instances_backup;

    DROP TABLE instances_backup;

    UPDATE instances SET mac_address=(SELECT address
                                      FROM virtual_interfaces
                                      WHERE virtual_interfaces.instance_id = instances.id);

    CREATE TEMPORARY TABLE networks_backup (
        created_at DATETIME,
        updated_at DATETIME,
        deleted_at DATETIME,
        deleted BOOLEAN,
        id INTEGER NOT NULL,
        injected BOOLEAN,
        cidr VARCHAR(255),
        netmask VARCHAR(255),
        bridge VARCHAR(255),
        gateway VARCHAR(255),
        broadcast VARCHAR(255),
        dns VARCHAR(255),
        vlan INTEGER,
        vpn_public_address VARCHAR(255),
        vpn_public_port INTEGER,
        vpn_private_address VARCHAR(255),
        dhcp_start VARCHAR(255),
        project_id VARCHAR(255),
        host VARCHAR(255),
        cidr_v6 VARCHAR(255),
        gateway_v6 VARCHAR(255),
        label VARCHAR(255),
        netmask_v6 VARCHAR(255),
        bridge_interface VARCHAR(255),
        PRIMARY KEY (id),
        CHECK (injected IN (0, 1)),
        CHECK (deleted IN (0, 1))
    );

    INSERT INTO networks_backup
        SELECT created_at,
               updated_at,
               deleted_at,
               deleted,
               id,
               injected,
               cidr,
               netmask,
               bridge,
               gateway,
               broadcast,
               dns,
               vlan,
               vpn_public_address,
               vpn_public_port,
               vpn_private_address,
               dhcp_start,
               project_id,
               host,
               cidr_v6,
               gateway_v6,
               label,
               netmask_v6,
               bridge_interface
        FROM networks;

    DROP TABLE networks;

    CREATE TABLE networks (
        created_at DATETIME,
        updated_at DATETIME,
        deleted_at DATETIME,
        deleted BOOLEAN,
        id INTEGER NOT NULL,
        injected BOOLEAN,
        cidr VARCHAR(255),
        netmask VARCHAR(255),
        bridge VARCHAR(255),
        gateway VARCHAR(255),
        broadcast VARCHAR(255),
        dns VARCHAR(255),
        vlan INTEGER,
        vpn_public_address VARCHAR(255),
        vpn_public_port INTEGER,
        vpn_private_address VARCHAR(255),
        dhcp_start VARCHAR(255),
        project_id VARCHAR(255),
        host VARCHAR(255),
        cidr_v6 VARCHAR(255),
        gateway_v6 VARCHAR(255),
        label VARCHAR(255),
        netmask_v6 VARCHAR(255),
        PRIMARY KEY (id),
        CHECK (injected IN (0, 1)),
        CHECK (deleted IN (0, 1))
    );

    INSERT INTO networks
        SELECT created_at,
               updated_at,
               deleted_at,
               deleted,
               id,
               injected,
               cidr,
               netmask,
               bridge,
               gateway,
               broadcast,
               dns,
               vlan,
               vpn_public_address,
               vpn_public_port,
               vpn_private_address,
               dhcp_start,
               project_id,
               host,
               cidr_v6,
               gateway_v6,
               label,
               netmask_v6
        FROM networks_backup;

    DROP TABLE networks_backup;

    DROP TABLE virtual_interfaces;

    CREATE TEMPORARY TABLE fixed_ips_backup (
        created_at DATETIME,
        updated_at DATETIME,
        deleted_at DATETIME,
        deleted BOOLEAN,
        id INTEGER NOT NULL,
        address VARCHAR(255),
        network_id INTEGER,
        instance_id INTEGER,
        allocated BOOLEAN,
        leased BOOLEAN,
        reserved BOOLEAN,
        virtual_interface_id INTEGER,
        PRIMARY KEY (id),
        CHECK (reserved IN (0, 1)),
        CHECK (allocated IN (0, 1)),
        CHECK (leased IN (0, 1)),
        CHECK (deleted IN (0, 1)),
        FOREIGN KEY(instance_id) REFERENCES instances (id),
        FOREIGN KEY(network_id) REFERENCES networks (id)
    );

    INSERT INTO fixed_ips_backup
        SELECT created_at,
               updated_at,
               deleted_at,
               deleted,
               id,
               address,
               network_id,
               instance_id,
               allocated,
               leased,
               reserved,
               virtual_interface_id
        FROM fixed_ips;

    DROP TABLE fixed_ips;

    CREATE TABLE fixed_ips (
        created_at DATETIME,
        updated_at DATETIME,
        deleted_at DATETIME,
        deleted BOOLEAN,
        id INTEGER NOT NULL,
        address VARCHAR(255),
        network_id INTEGER,
        instance_id INTEGER,
        allocated BOOLEAN,
        leased BOOLEAN,
        reserved BOOLEAN,
        PRIMARY KEY (id),
        CHECK (reserved IN (0, 1)),
        CHECK (allocated IN (0, 1)),
        CHECK (leased IN (0, 1)),
        CHECK (deleted IN (0, 1)),
        FOREIGN KEY(instance_id) REFERENCES instances (id),
        FOREIGN KEY(network_id) REFERENCES networks (id)
    );

    INSERT INTO fixed_ips
        SELECT created_at,
               updated_at,
               deleted_at,
               deleted,
               id,
               address,
               network_id,
               instance_id,
               allocated,
               leased,
               reserved
        FROM fixed_ips_backup;

    DROP TABLE fixed_ips_backup;

COMMIT;
