/*
 * Copyright 2010 Inalogic® Inc.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License, as
 * published by the  Free Software Foundation; either version 2.1 or 3.0
 * of the License.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranties of
 * MERCHANTABILITY, SATISFACTORY QUALITY or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the applicable version of the GNU Lesser General Public
 * License for more details.
 *
 * You should have received a copy of both the GNU Lesser General Public
 * License along with this program. If not, see <http://www.gnu.org/licenses/>
 *
 * Authored by: Jay Taoko <jaytaoko@inalogic.com>
 *
 */


#ifndef TIMEGRAPH_H
#define TIMEGRAPH_H

#include "NuxGraphics/GpuDevice.h"
#include "NuxGraphics/GLDeviceObjects.h"
#include "NuxGraphics/GLSh_DrawFunction.h"
#include "TimerProc.h"

namespace nux
{

  typedef float (*FunctionCallback) (float);

  class VLayout;
  class HLayout;
  class Button;
  class StaticTextBox;
  class InputArea;

  class TimeGraph : public View
  {
    NUX_DECLARE_OBJECT_TYPE (TimeGraph, View);
  public:
    TimeGraph (const TCHAR *Title, NUX_FILE_LINE_PROTO);
    ~TimeGraph();
    virtual long ProcessEvent (IEvent &ievent, long TraverseInfo, long ProcessEventInfo);
    virtual void Draw (GraphicsEngine &GfxContext, bool force_draw);
    virtual void DrawContent (GraphicsEngine &GfxContext, bool force_draw);
    virtual void PostDraw (GraphicsEngine &GfxContext, bool force_draw);

    void AddValue (float Value);
    void SetYAxisBounds (float minY, float maxY);
    unsigned int AddGraph (Color PrimaryColor, Color SecondaryColor);
    void UpdateGraph (unsigned int index, float Value);

    void RecvShowBarGraphics (int x, int y, unsigned long button_flags, unsigned long key_flags);
    void RecvShowCurveGraphics (int x, int y, unsigned long button_flags, unsigned long key_flags);
    void RecvShowValue (int x, int y, unsigned long button_flags, unsigned long key_flags);
    void ShowGraphStyle();
    void ShowColumnStyle();
    void ShowNumberStyle();
  protected:
    void InitializeWidgets();
    void InitializeLayout();
    void DestroyLayout();

  private:
    static unsigned int sBufferSize;
    VLayout        *m_vlayout;
    HLayout        *m_hlayout;
    HLayout        *m_hlayout2;
    StaticTextBox  *m_GraphTitle;
    InputArea       *m_GraphArea;
    InputArea       *m_GraphIcon;
    InputArea       *m_GraphBarIcon;
    InputArea       *m_ValueIcon;
    NString m_Title;

    enum
    {
      SHOW_GRAPH = 0,
      SHOW_COLUMN,
      SHOW_VALUE
    };

    class Graph
    {
    public:
      Graph (Color PrimaryColor, Color SecondaryColor);
      Graph (const Graph &graph);
      Graph &operator = (const Graph &graph);
      ~Graph();
      void Update (float Value);
      void Clear();
      void Reset();
      std::list<float> m_ValueList;
      // ! Set to true if the graph has been updated during the graphic refresh period.
      bool m_HasBeenUpdated;
      Color m_PrimaryColor;
      Color m_SecondaryColor;
    };

    unsigned int m_Option;

    std::vector<Graph> m_DynValueArray;

    float m_minY, m_maxY;

    ObjectPtr<IOpenGLBaseTexture> Texture;
    TextureLayer *m_BackgroundLayer;
    GLSh_DrawFunction *m_DrawFunctionShader;
  };


}

#endif // TIMEGRAPH_H
