/***********************************************************************/
/*                                                                     */
/*                           Objective Caml                            */
/*                                                                     */
/*             Damien Doligez, projet Para, INRIA Rocquencourt         */
/*                                                                     */
/*  Copyright 1996 Institut National de Recherche en Informatique et   */
/*  en Automatique.  All rights reserved.  This file is distributed    */
/*  under the terms of the GNU Library General Public License, with    */
/*  the special exception on linking described in file ../LICENSE.     */
/*                                                                     */
/***********************************************************************/

/* $Id: major_gc.h,v 1.17 2002/11/15 16:15:19 doligez Exp $ */

#ifndef _major_gc_
#define _major_gc_


#include "freelist.h"
#include "misc.h"

typedef struct {
  void *block;           /* address of the malloced block this chunk live in */
  asize_t alloc;         /* in bytes, used for compaction */
  asize_t size;          /* in bytes */
  char *next;
} heap_chunk_head;

#define Chunk_size(c) (((heap_chunk_head *) (c)) [-1]).size
#define Chunk_alloc(c) (((heap_chunk_head *) (c)) [-1]).alloc
#define Chunk_next(c) (((heap_chunk_head *) (c)) [-1]).next
#define Chunk_block(c) (((heap_chunk_head *) (c)) [-1]).block

extern int gc_phase;
extern unsigned long allocated_words;
extern double extra_heap_memory;
extern unsigned long fl_size_at_phase_change;

#define Phase_mark 0
#define Phase_sweep 1
#define Phase_idle 2

#ifdef __alpha
typedef int page_table_entry;
#else
typedef char page_table_entry;
#endif

CAMLextern char *heap_start;
CAMLextern char *heap_end;
extern unsigned long total_heap_size;
CAMLextern page_table_entry *page_table;
extern asize_t page_low, page_high;
extern char *gc_sweep_hp;

#define In_heap 1
#define Not_in_heap 0
#define Page(p) ((unsigned long) (p) >> Page_log)
#define Is_in_heap(p) \
  (Assert (Is_block ((value) (p))), \
   (addr)(p) >= (addr)heap_start && (addr)(p) < (addr)heap_end \
   && page_table [Page (p)])

void init_major_heap (asize_t);           /* size in bytes */
asize_t round_heap_chunk_size (asize_t);  /* size in bytes */
void darken (value, value *);
long major_collection_slice (long);
void major_collection (void);
void finish_major_cycle (void);


#endif /* _major_gc_ */
