/*
 *  Copyright (c) 2008 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef _OPENSHIVA_COMPILER_H_
#define _OPENSHIVA_COMPILER_H_

#include <GTLCore/String.h>
#include <GTLCore/CompilerBase_p.h>

#include <map>

namespace llvm {
  class Module;
}

namespace GTLCore {
  class ModuleData;
  class Value;
}

namespace OpenShiva {
  /**
   * @internal
   * @ingroup OpenShiva
   */
  class Compiler : public GTLCore::CompilerBase {
    public:
      Compiler( bool _isKernel, int _channelsNb );
      ~Compiler();
      bool compile(bool _isStdLibrary, const GTLCore::String& _sourceCode, const GTLCore::String& _kernelName, GTLCore::ModuleData* _moduleData, llvm::Module* _module, GTLCore::String& _nameSpace, const std::map< GTLCore::String, GTLCore::Value >& parameters );
      bool importModule(const GTLCore::String& name);
      virtual GTLCore::TypesManager* typesManager();
      bool isKernel() const;
      bool isStdLib() const;
      const std::map< GTLCore::String, GTLCore::Value >& parameters() const;
      int channelsNb() const;
    public:
      GTLCore::AST::Expression* standardConstant( const GTLCore::String& _name );
    private:
      struct Private;
      Private* const d;
  };
  
}

#endif
