/*
 *  Copyright (c) 2007-2008 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * version 2 of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef _GTLCORE_EXPRESSION_RESULT_P_H_
#define _GTLCORE_EXPRESSION_RESULT_P_H_

namespace llvm {
  class Constant;
  class Value;
}

namespace GTLCore {
  class Type;
  /**
   * @internal
   * 
   * This class holds the result of an expression. This class contains the information
   * wether the result is a llvm::Constant or not.
   * 
   * @ingroup GTLCore
   */
  class ExpressionResult {
    public:
      /**
       * Construct an empty expression result.
       */
      ExpressionResult();
      explicit ExpressionResult(llvm::Value* _value, const GTLCore::Type* _type, bool _functionResult = false);
      explicit ExpressionResult(llvm::Constant* _constant, const GTLCore::Type* _type, bool _functionResult = false);
      ExpressionResult(const ExpressionResult& rhs );
      ExpressionResult operator=(const ExpressionResult& rhs );
      ~ExpressionResult();
      bool isConstant() const;
      llvm::Value* value() const;
      void setValue( llvm::Value* v);
      llvm::Constant* constant() const;
      void setConstant( llvm::Constant* v);
      const GTLCore::Type* type() const;
      bool functionResult() const;
    private:
      struct Private;
      Private* const d;
  };
}

#endif
