/*
 *  Copyright (c) 2008 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * version 2 of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef _GTLCORE_MACROS_P_H_
#define _GTLCORE_MACROS_P_H_

/**
 * @internal
 * 
 * Allows to execute code at library initialisation.
 *
 * @code
 * class CoolObject {};
 * static std::vector\<CoolObject*\> staticCoolInstances;
 * STATIC_INITIALISATION( CoolObjects )
 * {
 *  for(int i =0; i < 10; ++i)
 *    staticCoolInstances.push_back( new CoolObject() );
 * }
 * @endcode
 * 
 * This will create a CoolObjectsFactory that you can use
 * to declare a friend class.
 * 
 * @ingroup GTLCore
 */
#define STATIC_INITIALISATION(_name_) \
  class _name_##Factory { \
    public: \
      _name_##Factory(); \
  }; \
  _name_##Factory instance##_name_ ; \
  _name_##Factory::_name_##Factory()


/**
 * @internal
 * 
 * Allows to execute code at library deletion.
 *
 * @code
 * class CoolObject {};
 * static std::vector\<CoolObject*\> staticCoolInstances;
 * STATIC_DELETER( CoolObjects )
 * {
 *  for(int i =0; i \< staticCoolInstances.size(); ++i)
 *    delete staticCoolInstances[i];
 * }
 * @endcode
 * 
 * This will create a CoolObjectsDeleter that you can use
 * to declare a friend class.
 * 
 * @ingroup GTLCore
 */
#define STATIC_DELETER( _name_ ) \
  class _name_##Deleter { \
    public: \
      _name_##Deleter() {} \
      ~_name_##Deleter(); \
  }; \
  _name_##Deleter instance##_name_ ; \
  _name_##Deleter::~_name_##Deleter()
  
  
#define UNUSED( _var_) (void)_var_;

#endif
