/*
 *  Copyright (c) 2008 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * version 2 of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef _GTLCORE_REGION_H_
#define _GTLCORE_REGION_H_

namespace GTLCore {
  /**
   * Define a rectangle.
   * 
   * @ingroup GTLCore
   */
  class Region {
    public:
      Region();
      Region( int _x, int _y, int _width, int _height );
      ~Region();
      int x() const;
      int y() const;
      int width() const;
      void setWidth( int _width );
      int height() const;
      void setHeight( int _height );
      bool operator!=( const Region& _region ) const;
    private:
      int m_x, m_y, m_width, m_height;
  };
}

#endif
