/*
 *  Copyright (c) 2008 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * version 2 of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#include "TypeManager.h"

#include "Debug.h"
#include "TypeManager_p.h"

using namespace GTLCore;

std::map< const GTLCore::Type*, const GTLCore::Type*> TypeManager::Private::knownArrays;
std::map< const GTLCore::Type*, std::map< int, const GTLCore::Type* > > TypeManager::Private::knownVectors;

TypeManager::TypeManager() : d(new Private)
{
}

TypeManager::~TypeManager()
{
  for( std::map< GTLCore::String, const GTLCore::Type*>::iterator it = d->knownTypes.begin(); it != d->knownTypes.end(); ++it)
  {
    delete it->second;
  }
  delete d;
}

const GTLCore::Type* TypeManager::getStructure( const GTLCore::String& _name) const
{
  std::map< GTLCore::String, const GTLCore::Type*>::const_iterator it = d->knownTypes.find(_name);
  if( it == d->knownTypes.end())
  {
    return 0;
  }
  return it->second;
}

const GTLCore::Type* TypeManager::getArray( const GTLCore::Type* _type)
{
  GTL_ASSERT( _type );
  std::map< const GTLCore::Type*, const GTLCore::Type*>::const_iterator it = TypeManager::Private::knownArrays.find( _type );
  if( it == TypeManager::Private::knownArrays.end())
  {
    GTLCore::Type* at = new GTLCore::Type( _type );
    TypeManager::Private::knownArrays[ _type] = at;
    return at;
  }
  return it->second;
}

const GTLCore::Type* TypeManager::getArray( const GTLCore::Type* _type, int _levelsCount)
{
  GTL_ASSERT( _type );
  const GTLCore::Type* type = _type;
  for(int i = 0; i < _levelsCount; ++i )
  {
    type = getArray( type );
  }
  return type;
}

const GTLCore::Type* TypeManager::getVector( const GTLCore::Type* _type, int _size )
{
  GTL_ASSERT( _type );
  std::map< const GTLCore::Type*, std::map< int, const GTLCore::Type* > >::const_iterator it
      = TypeManager::Private::knownVectors.find( _type );
  const GTLCore::Type*& type = TypeManager::Private::knownVectors[ _type ][ _size ];
  if( type == 0 )
  {
    type = new GTLCore::Type( _size, _type );
  }
  return type;
}
