/*
 *  Copyright (c) 2008 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * version 2 of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#include "Suite.h"

#include "Result.h"

#include <iostream>
#include <list>

using namespace GTLTest;

struct Suite::Private {
  std::list<Case*> cases;
};

Suite::Suite(const std::string& _name) : Case(_name), d(new Private)
{
}

Suite::~Suite()
{
  for(std::list<Case*>::iterator it = d->cases.begin(); it != d->cases.end(); ++it)
  {
    delete *it;
  }
  delete d;
}

void Suite::runTest()
{
  for(std::list<Case*>::iterator it = d->cases.begin(); it != d->cases.end(); ++it)
  {
    std::cout << "Running test : " << (*it)->name() << std::endl;
    (*it)->run(result());
  }
}

void Suite::addCase(Case* tc)
{
  d->cases.push_back( tc );
}
