/*************************************************************************
 *
 *  $RCSfile: id_gener.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: hr $ $Date: 2003/03/18 14:11:35 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/


#include <precomp.h>
#include <id_gener.hxx>


// NOT FULLY DEFINED SERVICES
#include <stdio.h>


namespace ary
{

const UINT32  C_nTopProjectId = 1;
const UINT32  C_nGlobalNamespaceId = 2;
const UINT32  CID_START_OF_CIDS = 128;
const UINT32  CID_START_OF_TIDS = 1024;
const UINT32  CID_TID_ELLIPSE = 1;
const UINT32  CID_START_OF_BuiltInType_TIDS = 2;
const UINT32  CID_START_OF_LIDS = 1;
const UINT32  CID_START_OF_OSIDS = 1;
const UINT32  CID_START_OF_DIDS = 128;


Std_IdGenerator::Std_IdGenerator()
    :   nIds(CID_START_OF_CIDS),
        nTids(CID_START_OF_TIDS),
        nLids(CID_START_OF_LIDS),
        nOSids(CID_START_OF_OSIDS),
        nDids(CID_START_OF_DIDS),
        nAnonymous(1)
{
}

Std_IdGenerator::~Std_IdGenerator()
{
}

Cid
Std_IdGenerator::do_NewCid()
{
    return nIds++;
}

Tid
Std_IdGenerator::do_NewTid()
{
    return nTids++;
}

cpp::Did
Std_IdGenerator::do_NewDid()
{
    return nDids++;
}

Gid
Std_IdGenerator::do_NewGid()
{
    return nIds++;
}

Lid
Std_IdGenerator::do_NewLid()
{
    return nLids++;
}

OSid
Std_IdGenerator::do_NewOSid()
{
    return nOSids++;
}

udmstri
Std_IdGenerator::do_NewAnonymousName( char i_cStart )
{
 	char sResult[30];

    // convert for type safety in sprintf
    unsigned long nNr = nAnonymous++;

    sprintf( sResult,               // SAFE SPRINTF (#100211# - checked)
             "%c_Anonymous__%lu",
             i_cStart, nNr );

    return &sResult[0];
}

Gid
Std_IdGenerator::inq_Id_TopProject() const
{
    return C_nTopProjectId;
}

Cid
Std_IdGenerator::inq_Id_GlobalNamespace_Cpp() const
{
	return C_nGlobalNamespaceId;
}

Tid
Std_IdGenerator::inq_FirstId_BuiltInTypes() const
{
	return CID_START_OF_BuiltInType_TIDS;
}

Tid
Std_IdGenerator::inq_IdEllipse() const
{
 	return CID_TID_ELLIPSE;
}



}   // namespace ary




