/*************************************************************************
 *
 *  $RCSfile: pkgchk_classpath.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: vg $ $Date: 2003/05/26 08:37:54 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2002 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include "pkgchk_env.h"
#include "rtl/byteseq.hxx"
#include "rtl/strbuf.hxx"


using namespace ::std;
using namespace ::rtl;
using namespace ::osl;
using namespace ::com::sun::star::uno;

namespace pkgchk
{

//______________________________________________________________________________
void pkgchk_env::classpath_verify_init()
{
    if (! m_classpath_inited)
    {
        OUString path(
            path_concat(
                m_cache_path,
                RTL_CONSTASCII_STRINGPARAM("java_classpath") ) );
        File file( path );
        if (File::E_None == file.open( OpenFlag_Read ))
        {
            // read first line
            ByteSequence seq;
            if (File::E_None == file.readLine( seq ))
            {
                OString line(
                    (sal_Char const *)seq.getConstArray(), seq.getLength() );
                sal_Int32 index = 0;
                do
                {
                    // ascii file-url snippets: no spaces in
                    OString token( line.getToken( 0, ' ', index ).trim() );
                    if (token.getLength())
                    {
                        OUString ustr_token(
                            token.getStr(), token.getLength(),
                            RTL_TEXTENCODING_ASCII_US );
                        m_classpathes.insert( ustr_token );
                    }
                }
                while (index >= 0);
            }
            file.close();
            
            OUStringBuffer buf( 128 );
            buf.appendAscii(
                RTL_CONSTASCII_STRINGPARAM("reading classpath file ") );
            buf.append( path );
            buf.appendAscii( RTL_CONSTASCII_STRINGPARAM(": ok.") );
            log( buf.makeStringAndClear() );
        }
        m_classpath_modified = false;
        m_classpath_inited = true;
    }
}

//______________________________________________________________________________
void pkgchk_env::classpath_insert( OUString const & path )
{
    classpath_verify_init();
    pair< t_string_set::iterator, bool > insertion(
        m_classpathes.insert( path ) );
    if (insertion.second)
        m_classpath_modified = true;
}

//______________________________________________________________________________
void pkgchk_env::classpath_remove( OUString const & path )
{
    classpath_verify_init();
    size_t erased = m_classpathes.erase( path );
    if (0 < erased)
        m_classpath_modified = true;
}

//______________________________________________________________________________
void pkgchk_env::classpath_flush() const
{
    if (!m_classpath_inited || !m_classpath_modified)
        return;
    
    OUString path(
        path_concat(
            m_cache_path,
            RTL_CONSTASCII_STRINGPARAM("java_classpath") ) );
    
    // try to erase java_classpath file
    File::remove( path );
    if (! m_classpathes.empty())
    {
        oslFileHandle file = 0;
        // write classpath file
        if (osl_File_E_None != osl_openFile(
                path.pData, &file,
                osl_File_OpenFlag_Create | osl_File_OpenFlag_Write ))
        {
            throw RuntimeException(
                OUSTR("cannot write ") + path, Reference< XInterface >() );
        }
        
        OStringBuffer buf( 256 );
        for ( t_string_set::const_iterator iPos( m_classpathes.begin() );
              iPos != m_classpathes.end();
              ++iPos )
        {
            // ascii file-url snippets: no spaces in
            OString java(
                OUStringToOString( *iPos, RTL_TEXTENCODING_ASCII_US ) );
            buf.append( java );
            buf.append( ' ' );
        }
        file_write( file, buf.makeStringAndClear(), path );
        OSL_VERIFY( osl_File_E_None == osl_closeFile( file ) );
    }
    
    m_classpath_modified = false;
    
    OUStringBuffer buf( 128 );
    buf.appendAscii( RTL_CONSTASCII_STRINGPARAM("updated classpath file ") );
    buf.append( path );
    buf.appendAscii( RTL_CONSTASCII_STRINGPARAM(": ok.") );
    log( buf.makeStringAndClear() );
}

}
