/*************************************************************************
 *
 *  $RCSfile: InterfaceTypeDescription.java,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: vg $ $Date: 2001/12/03 11:00:41 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
package com.sun.star.comp.typedescriptionmanager;

import com.sun.star.uno.*;
import com.sun.star.lib.uno.typeinfo.*;
import com.sun.star.uno.RuntimeException;
import com.sun.star.container.XHierarchicalNameAccess;
import com.sun.star.container.NoSuchElementException;
import com.sun.star.reflection.XTypeDescription;
import com.sun.star.reflection.XInterfaceTypeDescription;
import com.sun.star.reflection.XInterfaceMemberTypeDescription;
import com.sun.star.reflection.XInterfaceMethodTypeDescription;
import com.sun.star.reflection.XMethodParameter;
import com.sun.star.reflection.XInterfaceAttributeTypeDescription;

import java.lang.reflect.Method;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;

import java.util.Vector;


//==================================================================================================
class InterfaceTypeDescription extends TypeDescription implements XInterfaceTypeDescription
{
	private TypeDescriptionManager	_tdmanager;
	private boolean					_bBaseTypeSet = false;
	private XTypeDescription		_xBaseType;
	private Uik						_uik = null;
	private XInterfaceMemberTypeDescription[] _members = null;
	
	//______________________________________________________________________________________________
	public InterfaceTypeDescription( TypeDescriptionManager tdmanager, Class c )
	{
		super( c, TypeClass.INTERFACE );
		this._tdmanager = tdmanager;
	}
	
	// XInterfaceTypeDescription
	//______________________________________________________________________________________________
    public XTypeDescription getBaseType()
		throws RuntimeException
	{
		if (! _bBaseTypeSet)
		{
			try
			{
				Class[] interfaces = _class.getInterfaces();
				if (interfaces.length > 0)
					_xBaseType = (XTypeDescription)_tdmanager.getByClass( interfaces[0], false, true );
			}
			catch (NoSuchElementException exc)
			{
			}
			catch (ClassCastException exc)
			{
			}
			_bBaseTypeSet = true;
		}
		return _xBaseType;
	}
	//______________________________________________________________________________________________
    public Uik getUik()
		throws RuntimeException
	{
		if (_uik == null)
		{
			try
			{
				return (_uik = (Uik)_class.getField( "UIK" ).get( null ));
			}
			catch (NoSuchFieldException exc)
			{
			}
			catch (java.lang.SecurityException exc)
			{
			}
			catch (IllegalAccessException exc)
			{
			}
			throw new RuntimeException( "cannot retrieve interface uik!", null );
		}
		return _uik;
	}
	//______________________________________________________________________________________________
    public XInterfaceMemberTypeDescription[] getMembers()
		throws RuntimeException
	{
		if (_members == null)
			init();
		return _members;
	}
	//______________________________________________________________________________________________
    private void init()
		throws RuntimeException
	{
		try
		{
			Class[] interfaces = _class.getInterfaces();
			int nMemberPos = ((interfaces.length > 0 && XInterface.class.isAssignableFrom( interfaces[0] ))
							  ? ((XInterfaceTypeDescription)_tdmanager.getByClass(
								  interfaces[0], false, true )).getMembers().length + 3
							  : 0);
			
			Method[] methods = _class.getDeclaredMethods();
			int nMethods = methods.length;
			Vector members = new Vector( nMethods );
			
			for ( int i = 0; i < nMethods; ++i )
			{
				AttributeTypeInfo m = isAttributeMethod( methods[i] );
				if (m != null)
				{
					XTypeDescription returnType = (XTypeDescription)_tdmanager.getByClass(
						methods[i].getReturnType(), m.isUnsigned(), m.isInterface() );
					if (! m.isReadOnly())
						++i;
					
					String memberName = methods[i].getName().substring(3);
					members.addElement( new AttributeTypeDescription(
						_class.getName() + "::" + memberName, memberName,
						returnType, nMemberPos, m.isReadOnly() ) );
				}
				else
				{
					members.addElement( makeMethodDescriptor( methods[i], nMemberPos ) );
				}
				++nMemberPos;
			}
			
			members.trimToSize();
			XInterfaceMemberTypeDescription[] ar = new XInterfaceMemberTypeDescription[members.size()];
			if (! members.isEmpty())
				members.copyInto( ar );
			_members = ar;
			return;
		}
		catch (NoSuchElementException exc)
		{
		}
		catch (java.lang.SecurityException exc)
		{
		}
		throw new RuntimeException( "init of InterfaceTypeDescription failed!", null );
	}
	// helper functions
	//______________________________________________________________________________________________
	private AttributeTypeInfo isAttributeMethod( Method method )
	{
		String name = method.getName();
		if ((name.startsWith("get")/* && m.getParameterTypes().length == 0*/) ||
			(name.startsWith("set")/* && m.getParameterTypes().length == 1 &&
									  m.getReturnType().getName().equals( "void" )*/))
		{
			TypeInfo m = getTypeInfo(name.substring(3));
			
			if (m != null && m instanceof AttributeTypeInfo)
				return (AttributeTypeInfo)m;
		}
		
		return null;	
	}
	//______________________________________________________________________________________________
	private ParameterTypeInfo checkParameterTypeInfo(String methodName, int pos)
	{
		if (_typeInfos == null)
			initTypeInfos();
		
		for ( int i=0; i < _typeInfos.length; i++ )
		{
			if (_typeInfos[i] instanceof ParameterTypeInfo)
			{
				if (((ParameterTypeInfo)_typeInfos[i]).getMethodName().equals(methodName) &&
					((ParameterTypeInfo)_typeInfos[i]).getIndex() == pos)
				{
					return (ParameterTypeInfo)_typeInfos[i];
				}
			}
		}
		return null;	
	}
	//______________________________________________________________________________________________
	private XInterfaceMethodTypeDescription makeMethodDescriptor(Method m, int pos)
		throws RuntimeException, NoSuchElementException
	{
		Class[] parameters = m.getParameterTypes();
		XMethodParameter[] params = new XMethodParameter[parameters.length];
		
		for ( int i=0; i < parameters.length; ++i )
		{
			boolean bIn = true;
			boolean bOut = false;
			boolean bUnsigned = false;
			boolean bIsInterface = false;
			ParameterTypeInfo paramInfo = checkParameterTypeInfo(m.getName(), i);
			if (paramInfo != null)
			{
				bIn = paramInfo.isIN();
				bOut = paramInfo.isOUT();
				bUnsigned = paramInfo.isUnsigned();
				bIsInterface = paramInfo.isInterface();
			}
			
			Class c = parameters[i];
			XTypeDescription xParamType = (XTypeDescription)_tdmanager.getByClass(
				((bOut && c.isArray()) ? c.getComponentType() : c), bUnsigned, bIsInterface );
			
			params[i] = new MethodParameter( "Parameter "+i, xParamType, i, bIn, bOut );
		}
		
		Class[] exceptions = m.getExceptionTypes();
		XTypeDescription[] exps = new XTypeDescription[exceptions.length];
		for ( int i=0; i < exceptions.length; ++i )
		{
			exps[i] = (XTypeDescription)_tdmanager.getByClass( exceptions[i], false, false );
		}
		
		String memberName = m.getName();
		
		return new MethodTypeDescription(
			_class.getName() + "::" + memberName, memberName,
			(XTypeDescription)_tdmanager.getByClass( m.getReturnType(), isUnsigned(m.getName()), isInterface(m.getName()) ),
			pos, isOneway(m.getName()), params, exps );
	}
}

