/*************************************************************************
 *
 *  $RCSfile: fmtools.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:32:59 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#pragma hdrstop

#include "fmtools.hxx"
#ifndef MAC
#include <memory.h>
#endif

#ifndef _USR_PERSIST_HXX
#include <usr/persist.hxx>
#endif

#ifndef _USR_REFL_HXX
#include <usr/refl.hxx>
#endif

#ifndef _USR_CONVER_HXX
#include <usr/conver.hxx>
#endif

#ifndef _TOOLS_DEBUG_HXX //autogen
#include <tools/debug.hxx>
#endif

#ifndef _SBXVAR_HXX //autogen
#include <svtools/sbxvar.hxx>
#endif

#ifndef _SV_SVAPP_HXX //autogen
#include <vcl/svapp.hxx>
#endif

#ifndef _INTN_HXX //autogen
#include <tools/intn.hxx>
#endif

#ifndef _SVX_DBTOOLS_HXX
#include "dbtools.hxx"
#endif

#ifndef __SVTOOLS_SVTNUMF_HXX__
#include <svtools/svtnumf.hxx>
#endif


SMART_UNO_IMPLEMENTATION(FmEnumerationByIndex, UsrObject);

//==================================================================
//	EnumerationAccess Interface
//==================================================================
//------------------------------------------------------------------------------
XInterface* FmEnumerationByIndex::queryInterface(Uik aUik)
{
	if (aUik == XEnumeration::getSmartUik())
		return (XEnumeration*) this;
	else
		return UsrObject::queryInterface(aUik);
}

//------------------------------------------------------------------------------
XIdlClassRef FmEnumerationByIndex::getIdlClass()
{
	static XIdlClassRef xClass =
		createStandardClass
		   ( "FmEnumerationByIndex",
			 UsrObject::getUsrObjectIdlClass(),
			 1,
			 XEnumeration_getReflection());
	return xClass;
}

//------------------------------------------------------------------------------
BOOL FmEnumerationByIndex::hasMoreElements(void)
{
	BOOL bRet = FALSE;
	if (m_xAccess.Is() && m_xAccess->getCount() >= nPos)
		bRet = TRUE;
	else if (m_xAccess.Is())
		m_xAccess = NULL;

	return bRet;
}

//------------------------------------------------------------------------------
XInterfaceRef FmEnumerationByIndex::nextElement(void)
{
	XInterfaceRef xInt;
	if (m_xAccess.Is())
		xInt = m_xAccess->getElementByIndex(nPos++);

	if (xInt.Is() && m_xAccess.Is() && nPos >= m_xAccess->getCount())
		m_xAccess = NULL;
	return xInt;
}

// Streaming
//------------------------------------------------------------------------------
const XObjectInputStreamRef& operator >> (const XObjectInputStreamRef& InStream, XubString& rStr)
{
	UINT16 nLen = (UINT16)InStream->readShort();
	rStr.Erase();
	if (nLen)
	{
		BYTESequence aSeq;
		InStream->readBytes(aSeq, nLen * 2);

		UINT16Sequence aUINTSeq(nLen);
		memcpy((void*)aUINTSeq.getConstArray(), aSeq.getConstArray(), aSeq.getLen());
		rStr = UniCodeToString(aUINTSeq, CHARSET_SYSTEM);
	}
	return InStream;
}

//------------------------------------------------------------------------------
const XObjectOutputStreamRef& operator << (const XObjectOutputStreamRef& OutStream, const XubString& rStr)
{
	UINT16 nLen = rStr.Len();
	OutStream->writeShort(nLen);
	if (nLen)
	{
		UINT16Sequence aUINTSeq = StringToUniCode(rStr, CHARSET_SYSTEM);
		BYTESequence aSeq(nLen*2);
		memcpy((void*)aSeq.getConstArray(), aUINTSeq.getConstArray(), aSeq.getLen());
		OutStream->writeBytes(aSeq);
	}
	return OutStream;
}

//------------------------------------------------------------------------------
const XObjectInputStreamRef& operator >> (const XObjectInputStreamRef& InStream, WSStringSequence& rSeq)
{
	INT32 nLen = InStream->readLong();
	rSeq.realloc(nLen);
	if (nLen)
	{
		XubString* pString = (XubString*)rSeq.getConstArray();
		for (INT32 i = 0; i < nLen; i++)
			InStream >> pString[i];
	}
	return InStream;
}

//------------------------------------------------------------------------------
const XObjectOutputStreamRef& operator << (const XObjectOutputStreamRef& OutStream, const WSStringSequence& rSeq)
{
	INT32 nLen = rSeq.getLen();
	OutStream->writeLong(nLen);
	if (nLen)
	{
		XubString* pString = (XubString*)rSeq.getConstArray();
		for (INT32 i = 0; i < nLen; i++)
			OutStream << pString[i];
	}
	return OutStream;
}

//------------------------------------------------------------------
XubString DBTypeConversion::toString(const UsrAny& rValue)
{
	XubString	aString;
	Reflection*	pRefl   = rValue.getReflection();
	void* pConv		    = TypeConversion::to(pRefl, rValue);
	if (pConv)
	{
		switch (pRefl->getTypeClass())
		{
			case TYPECLASS_BOOLEAN:
				aString  = (char)*(BOOL *)pConv; break;
			case TYPECLASS_CHAR:
				aString  = *(char *)pConv; break;
			case TYPECLASS_STRING:
				aString  = *(XubString *)pConv; break;
			case TYPECLASS_BYTE:
			case TYPECLASS_UNSIGNED_BYTE:
				aString  = (char)*(BYTE *)pConv; break;
			case TYPECLASS_INT:
				aString  = *(int *)pConv; break;
			case TYPECLASS_SHORT:
				aString = (short)*(INT16 *)pConv; break;
			case TYPECLASS_LONG:
				aString = (long)*(INT32 *)pConv; break;
			case TYPECLASS_UNSIGNED_SHORT:
				aString = (short) *(UINT16 *)pConv; break;
			case TYPECLASS_UNSIGNED_LONG:
			case TYPECLASS_UNSIGNED_INT:
				aString = (int)*(unsigned int *)pConv; break;
			case TYPECLASS_VOID:
			default:
				; // leerstring
		}
	}
	return aString;
}

//------------------------------------------------------------------
double toDouble(const UsrAny& rValue)
{
	double aRet = 0;
	Reflection*	pRefl   = rValue.getReflection();
	void* pConv		    = TypeConversion::to(pRefl, rValue);
	if (pConv)
	{
		switch (pRefl->getTypeClass())
		{
			case TYPECLASS_BOOLEAN:
				aRet = *(BOOL *)pConv; break;
			case TYPECLASS_CHAR:
				aRet = *(char *)pConv; break;
			case TYPECLASS_FLOAT:
				aRet  = *(float *)pConv; break;
				break;
			case TYPECLASS_DOUBLE:
				aRet  = *(double *)pConv; break;
				break;
			case TYPECLASS_BYTE:
			case TYPECLASS_UNSIGNED_BYTE:
				aRet  = (char)*(BYTE *)pConv; break;
			case TYPECLASS_INT:
				aRet  = *(int *)pConv; break;
			case TYPECLASS_SHORT:
				aRet = (short)*(INT16 *)pConv; break;
			case TYPECLASS_LONG:
				aRet = (long)*(INT32 *)pConv; break;
			case TYPECLASS_UNSIGNED_SHORT:
				aRet = (short) *(UINT16 *)pConv; break;
			case TYPECLASS_UNSIGNED_LONG:
			case TYPECLASS_UNSIGNED_INT:
				aRet = (int)*(unsigned int *)pConv; break;
			case TYPECLASS_VOID:
			default:
				; // leerstring
		}
	}
	return aRet;
}

//------------------------------------------------------------------------------
UsrAny DBTypeConversion::toDBValue(const XNumberFormatterRef& xFormatter, const UsrAny& rValue, UINT16 nFieldType, UINT32 nKey)
{
	UsrAny aRet;
	if (rValue.get())
	{
		// sonderbehandlung fuer strings
		Reflection*	pRefl   = rValue.getReflection();
		if (pRefl->getTypeClass() == TYPECLASS_STRING && xFormatter.is())
		{
			XubString aString = rValue.getString();
			if (nFieldType == DBTYPE_CHAR ||
				nFieldType == DBTYPE_VARCHAR ||
				nFieldType == DBTYPE_MEMO )
				aRet.setString(aString);
			else
			{
				SbxValue* pVal = new SbxValue();
				static double fValue = 0;
				if (aString.Len())
				{
					BOOL bNumber = xFormatter->getNumber(fValue, nKey, aString);
					if (bNumber)
						pVal->PutDouble(fValue);
					else
						pVal->PutString(aString);

					switch (nFieldType)
					{
						case DBTYPE_BOOL:
							aRet.setBOOL(pVal->GetBool());
							break;
						case DBTYPE_BYTE:
							aRet.setBYTE(pVal->GetByte());
							break;
						case DBTYPE_SMALLINT:
							aRet.setINT16(pVal->GetInteger());
							break;
						case DBTYPE_INT:
						case DBTYPE_COUNTER:
							aRet.setINT32(pVal->GetLong());
							break;
						case DBTYPE_SINGLE:
							aRet.setFloat(pVal->GetSingle());
							break;
						case DBTYPE_CURRENCY:
						case DBTYPE_BIGINT:
						case DBTYPE_DOUBLE:
						case DBTYPE_DECIMAL:
						case DBTYPE_DATE:
						case DBTYPE_TIME:
						case DBTYPE_DATETIME:
							aRet.setDouble(pVal->GetDouble());
							break;
						case DBTYPE_MEMO:
						case DBTYPE_BINARY:
						case DBTYPE_VARBINARY:
						case DBTYPE_IMAGE:
							aRet = rValue;
							break;
						default:
							DBG_ERROR("SbaXdbField::setValue: falscher Type, kann Daten nicht interpretieren");
					}
					pVal->AddRef();
					pVal->ReleaseRef();
				}
			}
		}
		else
		{
			aRet = rValue;
			switch (nFieldType)
			{
				case DBTYPE_CHAR:
				case DBTYPE_VARCHAR:
					aRet.setString(toString(rValue));
					break;
				case DBTYPE_BOOL:
					TypeConversion::to(BOOL_getReflection(), aRet);
					break;
				case DBTYPE_BYTE:
					TypeConversion::to(BYTE_getReflection(), aRet);
					break;
				case DBTYPE_SMALLINT:
					TypeConversion::to(INT16_getReflection(), aRet);
					break;
				case DBTYPE_INT:
				case DBTYPE_COUNTER:
					TypeConversion::to(INT32_getReflection(), aRet);
					break;
				case DBTYPE_SINGLE:
					TypeConversion::to(Float_getReflection(), aRet);
					break;
				case DBTYPE_DATE:
				case DBTYPE_TIME:
				case DBTYPE_DATETIME:
				case DBTYPE_CURRENCY:
				case DBTYPE_BIGINT:
				case DBTYPE_DOUBLE:
				case DBTYPE_DECIMAL:
					TypeConversion::to(Double_getReflection(), aRet);
					break;
				case DBTYPE_MEMO:
					if (TypeConversion::to(String_getReflection(), aRet) != NULL)
					{
						break;
					}
				case DBTYPE_BINARY:
				case DBTYPE_VARBINARY:
				case DBTYPE_IMAGE:
					TypeConversion::to(BYTESequence_getReflection(), aRet);
					break;
				default:
					DBG_ERROR("SbaXdbField::setValue: falscher Type, kann Daten nicht interpretieren");
			}
		}
	}
	return aRet;
}

//------------------------------------------------------------------------------
String DBTypeConversion::toOutputString(const XNumberFormatterRef& xFormatter, const UsrAny& rValue, UINT16 nFieldType, UINT32 nKey)
{
	String aText;
	if (!rValue.get())
		;	// fertig
	else if (!xFormatter.is())
		aText = toString(rValue);
	else
	{
		switch (nFieldType)
		{
			case DBTYPE_MEMO:
				aText = toString(rValue);
				break;
			case DBTYPE_CHAR:
			case DBTYPE_VARCHAR:
			case DBTYPE_BOOL:
			case DBTYPE_BYTE:
			case DBTYPE_SMALLINT:
			case DBTYPE_INT:
			case DBTYPE_COUNTER:
			case DBTYPE_SINGLE:
			case DBTYPE_DATE:
			case DBTYPE_TIME:
			case DBTYPE_DATETIME:
			case DBTYPE_CURRENCY:
			case DBTYPE_BIGINT:
			case DBTYPE_DOUBLE:
			case DBTYPE_DECIMAL:
			{
				double fValue;
				UINT32 nColor;
				String aString = toString(rValue);
				if (xFormatter->getNumber(fValue, nKey, aString))
				{
					// es wird noch kein Unterschid zwischen Output und Input gemacht
					if (nFieldType == DBTYPE_CURRENCY)
						aText = xFormatter->getInputString(fValue, nKey);
					else
						aText = xFormatter->getOutputString(nColor, fValue, nKey);
				}
				else
					aText = xFormatter->getOutputForString(nColor, aString, nKey);
			}	break;
		}
	}
	return aText;
}

//------------------------------------------------------------------------------
String DBTypeConversion::toInputString(const XNumberFormatterRef& xFormatter, const UsrAny& rValue, UINT16 nFieldType, UINT32 nKey)
{
	String aText;
	if (!rValue.get())
		;	// fertig
	else if (!xFormatter.is())
		aText = toString(rValue);
	else
	{
		switch (nFieldType)
		{
			case DBTYPE_MEMO:
				aText = toString(rValue);
				break;
			case DBTYPE_CHAR:
			case DBTYPE_VARCHAR:
			case DBTYPE_BOOL:
			case DBTYPE_BYTE:
			case DBTYPE_SMALLINT:
			case DBTYPE_INT:
			case DBTYPE_COUNTER:
			case DBTYPE_SINGLE:
			case DBTYPE_DATE:
			case DBTYPE_TIME:
			case DBTYPE_DATETIME:
			case DBTYPE_CURRENCY:
			case DBTYPE_BIGINT:
			case DBTYPE_DOUBLE:
			case DBTYPE_DECIMAL:
			{
				double fValue;
				UINT32 nColor;
				String aString = toString(rValue);
				if (xFormatter->getNumber(fValue, nKey, aString))
					aText = xFormatter->getInputString(fValue, nKey);
				else
					aText = xFormatter->getOutputForString(nColor, aString, nKey);
			}	break;
		}
	}
	return aText;
}


XInterface* queryIfaceImpl(UsrUik aUik, XInterfaceRef xRef)
{
	if (xRef.is())
		return xRef->queryInterface(aUik);
	else
		return NULL;
}

XInterface* queryIfaceImpl(UsrUik aUik, XInterface* pRef)
{
	XInterfaceRef aRef = pRef;
	return queryIfaceImpl(aUik, aRef);
}

XInterface* queryAggImpl(UsrUik aUik, XAggregationRef xRef)
{
	if (xRef.is())
		return xRef->queryAggregation(aUik);
	else
		return NULL;
}

XInterface* queryAggImpl(UsrUik aUik, XAggregation* pRef)
{
	XAggregationRef aRef = pRef;
	return queryAggImpl(aUik, aRef);
}



