/*************************************************************************
 *
 *  $RCSfile: KeyValueMap.hxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: vg $ $Date: 2003/04/15 17:47:08 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _KEYVALUEMAP_HXX_
#define _KEYVALUEMAP_HXX_

#ifdef NDEBUG
#define KEYVALUEMAP_HXX_HAD_NDEBUG
#undef NDEBUG
#endif
#if OSL_DEBUG_LEVEL == 0
#define NDEBUG
#endif
#include <assert.h>

#include <map>
#include <utility>

//----------------------------------------------------------------
// this class is not thread-safe
// KEY   - what key do we use
// VALUE - the type of values to be inserted
// LOCK  - a locking strategy ( can be a NullLock
//         if locking is not necessary)
//----------------------------------------------------------------

template< class KEY, class VALUE >
class CKeyValueMap
{

public:
	CKeyValueMap( );

	bool  insert( KEY aKey, VALUE aValue );
	void  remove( KEY aKey );
	VALUE get( KEY aKey );
	void  empty( );

	size_t size( ) const;

private:
	// prevent copy and assignment
	CKeyValueMap( const CKeyValueMap< KEY, VALUE >& theOther );
	CKeyValueMap< KEY, VALUE >& operator=( const CKeyValueMap< KEY, VALUE >& theOther );

private:
	::std::map< KEY, VALUE > m_aMap;
};

//---------------------------------------------------
// ctor
//---------------------------------------------------

template< class KEY, class VALUE >
CKeyValueMap< KEY, VALUE >::CKeyValueMap( )
{
}

//---------------------------------------------------
// insert a key/value pair
//---------------------------------------------------

template< class KEY, class VALUE >
bool CKeyValueMap< KEY, VALUE >::insert( const KEY aKey, const VALUE aValue )
{
	return ( m_aMap.insert( std::map< KEY, VALUE >::value_type( aKey, aValue ) ).second );
}

//---------------------------------------------------
// remove an item
//---------------------------------------------------

template< class KEY, class VALUE >
void CKeyValueMap< KEY, VALUE >::remove( KEY aKey )
{
	m_aMap.erase( aKey );
}

//---------------------------------------------------
// return an item based on a key
//---------------------------------------------------

template< class KEY, class VALUE >
VALUE CKeyValueMap< KEY, VALUE >::get( KEY aKey )
{
	std::map< KEY, VALUE >::iterator find_pos;
	VALUE retVALUE;

	find_pos = m_aMap.find( aKey );
	if ( m_aMap.end( ) != find_pos )
	{
		retVALUE = (*find_pos).second;
	}
	else
		// "KEY does not exist in CKeyValueMap"
		assert( false );

	return retVALUE;
}

//---------------------------------------------------
// clear all items
//---------------------------------------------------

template< class KEY, class VALUE >
void CKeyValueMap< KEY, VALUE >::empty( )
{
	m_aMap.clear( );
}

//---------------------------------------------------
// returns the number of entries
//---------------------------------------------------

template< class KEY, class VALUE >
size_t CKeyValueMap< KEY, VALUE >::size( ) const
{
	return ( m_aMap.size( ) );
}

// Restore NDEBUG state
#ifdef KEYVALUEMAP_HXX_HAD_NDEBUG
#define NDEBUG
#else
#undef NDEBUG
#endif

#endif
