/*************************************************************************
 *
 *  $RCSfile: fuslshw5.cxx,v $
 *
 *  $Revision: 1.8.106.1 $
 *
 *  last change: $Author: rt $ $Date: 2003/08/25 13:17:56 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#pragma hdrstop

#define FUSLIDESHOW_INTERN

#ifndef _SV_BMPACC_HXX //autogen
#include <vcl/bmpacc.hxx>
#endif
#include <svx/xoutx.hxx>
#include <svx/outliner.hxx>
#include <svx/outliner.hxx>
#include <svx/eeitemid.hxx>
#include <svx/colritem.hxx>
#ifndef _SVDOATTR_HXX //autogen
#include <svx/svdoattr.hxx>
#endif
#ifndef _SVDPAGE_HXX //autogen
#include <svx/svdpage.hxx>
#endif
#ifndef _SVX_XLINEIT0_HXX //autogen
#include <svx/xlineit0.hxx>
#endif
#ifndef SVX_XFILLIT0_HXX //autogen
#include <svx/xfillit0.hxx>
#endif
#ifndef _SVDORECT_HXX //autogen
#include <svx/svdorect.hxx>
#endif
#ifndef _SVDOGRAF_HXX //autogen
#include <svx/svdograf.hxx>
#endif
#ifndef _SV_GRAPH_HXX //autogen
#include <vcl/graph.hxx>
#endif
#ifndef _SVDOATTR_HXX //autogen
#include <svx/svdoattr.hxx>
#endif
#ifndef _SVDPAGE_HXX //autogen
#include <svx/svdpage.hxx>
#endif
#ifndef _OUTLOBJ_HXX //autogen
#include <svx/outlobj.hxx>
#endif
#ifndef _SVDOATTR_HXX //autogen
#include <svx/svdoattr.hxx>
#endif
#ifndef _SVDPAGE_HXX //autogen
#include <svx/svdpage.hxx>
#endif
#ifndef _SVDITER_HXX //autogen
#include <svx/svditer.hxx>
#endif
#ifndef _SVDOGRP_HXX
#include <svx/svdogrp.hxx>
#endif
#include "drawdoc.hxx"
#include "sdpage.hxx"
#include "anminfo.hxx"
#include "mover.hxx"
#include "glob.hrc"
#include "showview.hxx"
#include "outlinfo.hxx"
#include "fuslshow.hxx"

using namespace ::com::sun::star;

// ------------------
// - SdAnimPageList -
// ------------------

SdAnimPageList::SdAnimPageList() :
	mnCurPagePos( 0 ),
	mnNextPagePos( 0 ),
	mnRealNextPagePos( 0 ),
	mnPreparedPageNum( PAGE_NO_END ),
	mbEndlessMode( FALSE ),
	mbPauseMode( FALSE ),
	mbSoftendMode( FALSE ),
	mnCurrentHidenPage( -1 )
{
}

// -----------------------------------------------------------------------------

SdAnimPageList::~SdAnimPageList()
{
}

// -----------------------------------------------------------------------------

USHORT SdAnimPageList::GetCurrentPageNum()
{
	if( mnCurrentHidenPage != -1 )
		return mnCurrentHidenPage;

	return( mnCurPagePos < Count() ) ? (USHORT)(ULONG) GetObject( mnCurPagePos ) : mnCurPagePos;
}

// -----------------------------------------------------------------------------

USHORT SdAnimPageList::GetNextPageNum()
{
	return( mnNextPagePos < Count() ) ? (USHORT)(ULONG) GetObject( mnNextPagePos ) : mnNextPagePos;
}

// -----------------------------------------------------------------------------

USHORT SdAnimPageList::GetRealNextPageNum()
{
	return( mnRealNextPagePos < Count() ) ? (USHORT)(ULONG) GetObject( mnRealNextPagePos ) : mnRealNextPagePos;
}

// -----------------------------------------------------------------------------

BOOL SdAnimPageList::IsPageNumIncluded( USHORT nSdPageNum )
{
	if( nSdPageNum == mnCurrentHidenPage )
		return TRUE;

	BOOL bRet = FALSE;

	for( ULONG i = 0, nCount = Count(); i < nCount; i++ )
	{
		if( ( (USHORT)(ULONG) GetObject( i ) ) == nSdPageNum )
		{
			bRet = TRUE;
			break;
		}
	}

	return bRet;
}

// -----------------------------------------------------------------------------

USHORT SdAnimPageList::CalcNextPageNum( BOOL bForward )
{
	if( Count() )
	{
		if( bForward )
		{
			if( mnCurPagePos < ( Count() - 1 ) )
				mnRealNextPagePos = mnNextPagePos = ( mnCurPagePos + 1 );
			else if( mbEndlessMode )
			{
				mnRealNextPagePos = 0;
				mnNextPagePos = ( mbPauseMode ? PAGE_NO_PAUSE : mnRealNextPagePos );
			}
			else
				mnRealNextPagePos = mnNextPagePos = ( mbSoftendMode ? PAGE_NO_SOFTEND : PAGE_NO_END );
		}
		else
		{
			if( mnCurPagePos )
				mnRealNextPagePos = mnNextPagePos = ( mnCurPagePos - 1 );
			else if( mbEndlessMode )
			{
				mnRealNextPagePos = (USHORT) Count() - 1;
				mnNextPagePos = ( mbPauseMode ? PAGE_NO_PAUSE : mnRealNextPagePos );
			}
			else
				mnRealNextPagePos = mnNextPagePos = mnCurPagePos;
		}
	}
	else
	{
		mnCurPagePos = mnNextPagePos = mnRealNextPagePos = ( mbSoftendMode ? PAGE_NO_SOFTEND : PAGE_NO_END );
		mnCurrentHidenPage = -1;
	}

	return( GetNextPageNum() );
}

// -----------------------------------------------------------------------------

BOOL SdAnimPageList::MakePageNumCurrent( USHORT nSdPageNum )
{
	mnCurrentHidenPage = -1;

	BOOL bRet = FALSE;

	if( nSdPageNum >= PAGE_NO_FIRSTDEF )
	{
		mnCurPagePos = nSdPageNum;
		bRet = TRUE;
	}
	else
	{
		if( GetNextPageNum() == nSdPageNum )
		{
			mnCurPagePos = mnNextPagePos;
			bRet = TRUE;
		}
		else
		{
			for( ULONG i = 0, nCount = Count(); i < nCount; i++ )
			{
				if( ( (USHORT)(ULONG) GetObject( i ) ) == nSdPageNum )
				{
					mnCurPagePos = (USHORT) i;
					bRet = TRUE;
					break;
				}
			}
		}
	}

	return bRet;
}

// -----------------------------------------------------------------------------

void SdAnimPageList::SetStartPage( USHORT nSdPageNum )
{
	mnCurrentHidenPage = -1;

	BOOL bFound = FALSE;

	for( ULONG i = 0, nCount = Count(); ( i < nCount ) && !bFound; i++ )
	{
		if( ( (USHORT)(ULONG) GetObject( i ) ) == nSdPageNum )
		{
			mnCurPagePos = mnNextPagePos = (USHORT) i;
			bFound = TRUE;
		}
	}

	if( !bFound )
		mnCurPagePos = mnNextPagePos = 0;
}

void SdAnimPageList::JumpToHidenPage( USHORT nSdPageNum )
{
	mnCurrentHidenPage = nSdPageNum;
}

// ---------------
// - FuSlideShow -
// ---------------

BOOL FuSlideShow::HideOrVanishObject( SdrObject* pActionObject, BOOL bHide )
{
	SdAnimationInfo*	pInfo = pDoc->GetAnimationInfo( pActionObject );
	BOOL				bResult = FALSE;

	// anstehende Gliederungsanimationen und Abblendungen werden beim
	// Verschwinden eines Objektes verworfen
	pCurAnmList->Remove( pLayoutText );
	pDimObject = pHideObject = NULL;
	pInfo->bShow = FALSE;
	RepaintVDev( pActualPage, TRUE );

	// Animationsinfo temporaer veraendern
	if( bHide )
	{
		presentation::AnimationEffect eOldEffect = pInfo->eEffect;
		presentation::AnimationEffect eOldTextEffect = pInfo->eTextEffect;

		pInfo->eEffect = presentation::AnimationEffect_HIDE;
		pInfo->eTextEffect = presentation::AnimationEffect_NONE;

		// das Objekt in der Liste nach vorn schieben und Animation starten
		pCurAnmList->Remove( pActionObject );
		pCurAnmList->Insert( pActionObject, (ULONG) 0 );
		bResult = AnimateObject();

		// Animationsinfo zuruecksetzen
		pInfo->eEffect = eOldEffect;
		pInfo->eTextEffect = eOldTextEffect;
	}
	else
	{
		String          aOldSound( pInfo->aSoundFile );
		presentation::AnimationEffect eOldEffect = pInfo->eEffect;
		presentation::AnimationEffect eOldTextEffect = pInfo->eTextEffect;
		presentation::AnimationSpeed  eOldSpeed = pInfo->eSpeed;
		BOOL            bOldActive = pInfo->bActive;
		BOOL            bOldSoundOn = pInfo->bSoundOn;
		BOOL            bOldPlayFull = pInfo->bPlayFull;

		pInfo->aSoundFile = pInfo->aBookmark;
		pInfo->eEffect = pInfo->eSecondEffect;
		pInfo->eTextEffect = presentation::AnimationEffect_NONE;
		pInfo->eSpeed = pInfo->eSecondSpeed;
		pInfo->bActive = TRUE;
		pInfo->bSoundOn = pInfo->bSecondSoundOn;
		pInfo->bPlayFull = pInfo->bSecondPlayFull;

		// das Objekt in der Liste nach vorn schieben und Animation starten
		pCurAnmList->Remove( pActionObject );
		pCurAnmList->Insert( pActionObject, (ULONG) 0 );

		bResult = AnimateObject();

		// Animationsinfo zuruecksetzen
		pInfo->aSoundFile = aOldSound;
		pInfo->eEffect = eOldEffect;
		pInfo->eTextEffect = eOldTextEffect;
		pInfo->eSpeed = eOldSpeed;
		pInfo->bActive = bOldActive;
		pInfo->bSoundOn = bOldSoundOn;
		pInfo->bPlayFull = bOldPlayFull;
	}

	if( nMagic != SLIDESHOW_MAGIC )
		return FALSE;

	pDimObject = NULL;
	pInfo->bIsShown = pInfo->bShow = FALSE;

	BOOL bWasSlow = IsSlowObj( (SdrAttrObj*) pActionObject );
	BOOL bWasDimmed = pInfo->bDimmed;
	pInfo->bDimmed = FALSE;
	BOOL bIsSlow = IsSlowObj( (SdrAttrObj*) pActionObject );

	// wenn das Objekt aufgrund der fehlenden Abblendung jetzt ein 'schnelles'
	// Objekt geworden ist, muessen die Label im Metafile angepasst und der
	// SlowObjRecord geloescht werden
	if( pMetaFile && bWasSlow && !bIsSlow )
	{
		pMetaFile->ReplaceMarker( OBJ_START( pActionObject, TRUE ), OBJ_START( pActionObject, FALSE ) );
		pMetaFile->ReplaceMarker( OBJ_END( pDimObject, TRUE ), OBJ_END( pDimObject, FALSE ) );

		if( pSlowObjList )
			delete (SdSlowObjRecord*) pSlowObjList->Remove( GetSlowObjRecord( (SdrAttrObj*) pActionObject ) );
	}

	// falls ein nicht mehr abgeblendetes Objekt immer noch 'langsam' ist, muss der SlowObjRecord ersetzt werden
	if( pSlowObjList && bIsSlow && bWasDimmed )
	{
		delete (SdSlowObjRecord*) pSlowObjList->Remove( GetSlowObjRecord( (SdrAttrObj*) pActionObject ) );

		if( CreateSlowObjRecord( (SdrAttrObj*) pActionObject ) )
		{
			if( pMetaFile && !bWasSlow )
			{
				pMetaFile->ReplaceMarker( OBJ_START( pActionObject, FALSE ), OBJ_START( pActionObject, TRUE ) );
				pMetaFile->ReplaceMarker( OBJ_END( pDimObject, FALSE ), OBJ_END( pDimObject, TRUE ) );
			}
		}
		else if( pMetaFile && bWasSlow )
		{
			pMetaFile->ReplaceMarker( OBJ_START( pActionObject, TRUE ), OBJ_START( pActionObject, FALSE ) );
			pMetaFile->ReplaceMarker( OBJ_END( pDimObject, TRUE ), OBJ_END( pDimObject, FALSE ) );
		}
	}

	if( AffectsOwnPage(pActionObject) )
		nVisibleAffectingObjects--;

	return bResult;
}


/*************************************************************************
|*
|* Paint-Handler fuer Objekte, markiert bestimmte Objekte im Metafile
|* mit Start- und Endmarke. Die Endmarke liegt auf der ersten Aktion
|* HINTER dem Objekt, da beim Abspielen die zu einem genannten Ziel
|* gehoerende Aktion nicht ausgefuehrt wird.
|*
\************************************************************************/

IMPL_LINK( FuSlideShow, PaintProc, SdrPaintProcRec *, pRecord )
{
	SdAnimationInfo*	pInfo = pDoc->GetAnimationInfo( pRecord->pObj );
	const BOOL			bMeta = pRecord->rOut.GetOutDev()->GetConnectMetaFile() == pMetaFile;
	BOOL				bMasterObj = pRecord->pObj->GetPage()->IsMasterPage();

	// Beginn der Zeichenseite markieren
	if( !bMasterObj )
	{
		static const Marker aPageStart( PAGE_START );
		if( !pMetaFile->HasMarker( aPageStart ) )
			pMetaFile->InsertMarker( aPageStart );

		static const Marker aFirstStart( FIRST_START );
		if( !pMetaFile->HasMarker( aFirstStart ) )
			pMetaFile->InsertMarker( aFirstStart );
	}

	// leere Praesentationsobjekte sollen nicht in der Show angezeigt werden
	// (Sonderfall Hintergrundrechteck: hat faelschlicherweise ein Leer-Flag,
	//	aber eine Aenderung kurz vor der Auslieferung ist zu riskant, deshalb
	//	an dieser Stelle abfangen)
	if( ( ANIMATIONMODE_PREVIEW != eAnimationMode ) && pRecord->pObj->IsEmptyPresObj() && pRecord->pObj != pBckgndRect )
		return 0;

	// falls nur der Hintergrund gecached wird, ist das erste Objekt das Objekt an Position 1 der Masterpage
	if( bMasterObj && ( SDR_MASTERPAGECACHE_BACKGROUND == nMasterPageCacheMode ) && ( pRecord->pObj->GetOrdNum() == 1 ) )
		pMetaFile->InsertMarker( FIRST_START );

	if( pRecord->pObj == pBckgndRect )
	{
		// wenn es das Hintergrundrechteck ist
		if( bMeta )
		{
			// falls nicht gecached wird, ist das erste Objekt das Objekt an Position 0 der Masterpage
			if( SDR_MASTERPAGECACHE_NONE == nMasterPageCacheMode )
				pMetaFile->InsertMarker( FIRST_START );

			pMetaFile->InsertMarker( BACKOBJ_START );
			pRecord->pObj->Paint( pRecord->rOut, pRecord->rInfoRec );
			pMetaFile->InsertMarker( BACKOBJ_END );
		}
		else
			pRecord->pObj->Paint( pRecord->rOut, pRecord->rInfoRec );
	}
	else if( pInfo && !pRecord->pObj->GetUpGroup() )
	{
		// Objekt mit Animationsinfo: im Metafile mit Labels klammern
		BOOL bIsSlow = FALSE;

		// ShowStati fuer MasterPageObjekte werden an anderer Stelle
		// initialisiert ( ==> ::DoPageFade, ::PrepareForPage )
		if( bInitShowStatus && !bMasterObj )
			InitShowStatus( pInfo );

		// Image
		if( bMeta )
		{
			if( IsSlowObj( (SdrAttrObj*) pRecord->pObj ) && !( pShowView->IsMasterPagePaintCaching() && bMasterObj ) )
				bIsSlow = CreateSlowObjRecord( (SdrAttrObj*) pRecord->pObj );

			pMetaFile->InsertMarker( OBJ_START( pRecord->pObj, bIsSlow ) );

            // #92365# Record only the last frame of an animation
            if( pInfo->bIsMovie )
            {
                // nur das letzte Bild
                SdrObjList* pObjList = ((SdrObjGroup*)pRecord->pObj)->GetSubList();
                SdrObject* pLast = (SdrObject*)pObjList->GetObj(pObjList->GetObjCount() - 1);
                pLast->Paint(pRecord->rOut, pRecord->rInfoRec);
            }
            else
            {
                pRecord->pObj->Paint( pRecord->rOut, pRecord->rInfoRec );
            }

			pMetaFile->InsertMarker( OBJ_END( pRecord->pObj, bIsSlow ) );
		}
		else
			pRecord->pObj->Paint( pRecord->rOut, pRecord->rInfoRec );
	}
	else
	{
		// ein ganz normales Wald- und Wiesenobjekt: zeichnen, wenn es zu sehen
		// ist, ansonsten unterdruecken (das spart Zeit beim Abspielen des Metafiles)
		const SdrPage*	pPage = (SdrPage*) pDoc->GetSdPage( 0, PK_STANDARD );
		Point			aPnt( pPage->GetLftBorder(), pPage->GetUppBorder() );
		const Rectangle	aRect( aPnt, aPageSize );

		if( aRect.IsOver( pRecord->pObj->GetBoundRect() ) )
		{
			SdrObject*	pObj;
			BOOL		bIsSlow = IsSlowObj( (SdrAttrObj*) pRecord->pObj );
			BOOL		bIsTextClone = !bAnimationAllowed && OBJIS_TEXTANIM( pRecord->pObj );

			// falls es sich um ein animiertes Textobjekt handelt,
			// das nicht animiert dargestellt werden soll, muessen
			// wir ein nicht animiertes Clone-Objekt im Mtf aufzeichnen
			if( bIsTextClone )
			{
				// nicht animierten Clone zeichnen
				SfxItemSet aTempAttr( pDoc->GetPool(), SDRATTR_TEXT_ANIKIND, SDRATTR_TEXT_ANIKIND );
				pObj = pRecord->pObj->Clone();

				aTempAttr.Set(pObj->GetItemSet());
				
				aTempAttr.Put( SdrTextAniKindItem() );

				pObj->SetItemSet(aTempAttr);
			}
			else
				pObj = pRecord->pObj;

			if( bIsSlow && bMeta )
			{
				bIsSlow = CreateSlowObjRecord( (SdrAttrObj*) pRecord->pObj );
				pMetaFile->InsertMarker( OBJ_START( pRecord->pObj, bIsSlow ) );
				pObj->Paint( pRecord->rOut, pRecord->rInfoRec );
				pMetaFile->InsertMarker( OBJ_END( pRecord->pObj, bIsSlow ) );
			}
			else
				pObj->Paint( pRecord->rOut, pRecord->rInfoRec );

			if( bIsTextClone )
				delete pObj;
		}
	}

	return 0L;
}

/*************************************************************************
|*
|* ein bestimmtes Animationsobjekt verstecken und wieder anzeigen
|*
\************************************************************************/

BOOL FuSlideShow::HideAndAnimateObject(SdrObject* pObject)
{
	if( !IsInputLocked() )
	{
		SdAnimationInfo*	pInfo = pDoc->GetAnimationInfo(pObject);
		SdPage*				pPage = (SdPage*) pObject->GetPage();
		BOOL				bAbort = FALSE;

		DBG_ASSERT( pInfo, "Objekt ohne Effekt" );

		if( pPage->IsMasterPage() &&
			( pObject->GetObjInventor() == SdrInventor ) &&
			( pObject->GetObjIdentifier() == OBJ_TITLETEXT || pObject->GetObjIdentifier() == OBJ_OUTLINETEXT ) )
		{
			return bAbort;
		}

		pPage = pDoc->GetSdPage( aAnimPageList.GetCurrentPageNum(), PK_STANDARD );
		PrepareForPage( pPage, FALSE );

		// wenn in einer Preview EIN Objekt animiert werden soll, sind alle anderen Animationsobjekte sichtbar
		if( eAnimationMode != ANIMATIONMODE_SHOW )
		{
			// Zeichenseite
			SdrObjListIter aMasterIter( *pPage->GetMasterPage( 0 ), IM_FLAT );
			SdrObjListIter aIter( *pPage, IM_FLAT );

			for( SdrObject*	pMasterO = aMasterIter.Next(); pMasterO; pMasterO = aMasterIter.Next() )
			{
				SdAnimationInfo* pInfo = pDoc->GetAnimationInfo( pMasterO );
				if( pInfo )
					pInfo->bShow = pInfo->bIsShown = TRUE;
			}

			for( SdrObject*	pO = aIter.Next(); pO; pO = aIter.Next() )
			{
				SdAnimationInfo* pInfo = pDoc->GetAnimationInfo( pO );
				if( pInfo )
					pInfo->bShow = pInfo->bIsShown = TRUE;
			}
		}

		// pActualPage wird fuer Objekteffekte benoetigt
		if( !pActualPage )
			pActualPage = pPage;

		// verstecken
		const BOOL bSoundOn = pInfo->bSoundOn;
		pInfo->bSoundOn = FALSE;
		HideOrVanishObject( pObject, pInfo->eClickAction != presentation::ClickAction_VANISH );
		pInfo->bSoundOn = bSoundOn;

		// im Reschedule des Effekts zerstoert?
		if( nMagic != SLIDESHOW_MAGIC )
			return TRUE;

		// und wieder zeigen
		pCurAnmList->Insert( pObject, (ULONG) 0 );

		// wenn es das Gliederungstextobjekt ist, den Zeiger auf NULL zurueck
		// setzen, damit die Initialisierungssequenz in AnimateLayoutText()
		// durchlaufen wird
		if( pObject == pLayoutText )
			pLayoutText = NULL;

		// solange KeyEvents simulieren, bis das Objekt aus der Animationsliste
		// verschwunden ist (z. B. Gliederung mit mehreren Absaetzen)
		// (oder bis die Show im Reschedule eines Effekts zerstoert wurde)
		const KeyEvent aKEvt( 32, KeyCode( KEY_SPACE ) );

		while( nMagic == SLIDESHOW_MAGIC && ( pCurAnmList->Count() || pDimObject ) )
			KeyInput( aKEvt );

		return bAbort;
	}
	else
		return TRUE;
}

/*************************************************************************
|*
|* BitmapEx als TopLayer erzeugen
|*
\************************************************************************/

BOOL FuSlideShow::CreateTopLayer( OutputDevice* pOut,
								  const Marker& rStartMarker,
								  const Marker& rEndMarker )
{
	BOOL bRet;

	// alten TopLayer loeschen
	delete pTopLayer;
	pTopLayer = NULL;

	// BitmapEx fuer TopLayer erzeugen
	VirtualDevice*	pTempDev = new VirtualDevice( *pWindow );
	const Size		aSizePix( pVDev->GetOutputSizePixel() );
	Bitmap			aPaint;
	Bitmap			aMask;

	// Maske
	pTempDev->SetOutputSizePixel( aSizePix );
	pTempDev->SetMapMode( pVDev->GetMapMode() );
	pTempDev->SetDrawMode( DRAWMODE_BLACKLINE | DRAWMODE_BLACKFILL | DRAWMODE_BLACKTEXT |
						   DRAWMODE_BLACKGRADIENT | DRAWMODE_BLACKBITMAP );
	pMetaFile->Play( pTempDev, rStartMarker, rEndMarker, TRUE );
	pTempDev->SetMapMode( MapMode() );
	aMask = pTempDev->GetBitmap( Point(), aSizePix );
	delete pTempDev;

	// Zeichenbitmap
	pTempDev = new VirtualDevice( *pWindow );
	bRet = pTempDev->SetOutputSizePixel( aSizePix );
	pTempDev->SetMapMode( pVDev->GetMapMode() );
	pMetaFile->Play( pTempDev, rStartMarker, rEndMarker );
	pTempDev->SetMapMode( MapMode() );
	aPaint = pTempDev->GetBitmap( Point(), aSizePix );
	delete pTempDev;
	pTopLayer = new BitmapEx( aPaint, aMask );

	return bRet;
}

/*************************************************************************
|*
|* ShowStatus an der Info setzen
|*
\************************************************************************/

void FuSlideShow::InitShowStatus( SdAnimationInfo* pInfo )
{
	if( pInfo )
	{
		if( pInfo->bActive && ( pInfo->eEffect == presentation::AnimationEffect_HIDE ) )
		{
			pInfo->bShow = pInfo->bIsShown = TRUE;
		}
		else if( pInfo->bActive &&
				 ( pInfo->eEffect != presentation::AnimationEffect_NONE || pInfo->eEffect == presentation::AnimationEffect_NONE && pInfo->bIsMovie ) ||
				 ( pInfo->eTextEffect != presentation::AnimationEffect_NONE ) )
		{
			pInfo->bShow = pInfo->bIsShown = FALSE;
		}
		else
			pInfo->bShow = pInfo->bIsShown = TRUE;

		pInfo->bDimmed = FALSE;
	}
}

/*************************************************************************
|*
|* Farbe, die zum Ausmaskieren benutzt wird, bestimmen
|*
\************************************************************************/

Color FuSlideShow::GetVDevColor( const Color& rColor )
{
	return rColor;
/*
	VirtualDevice		aVDev( *pShowWindow );
	const Size			aSz( 2, 2 );
	Bitmap				aBmp;
	BitmapReadAccess*	pAcc;
	Color				aCol;

	aVDev.SetBackground( rColor );
	aVDev.SetOutputSizePixel( aSz );
	aBmp = aVDev.GetBitmap( Point(), aSz );

	if( ( pAcc = aBmp.AcquireReadAccess() ) != NULL )
	{
		if( pAcc->HasPalette() )
			aCol = pAcc->GetPaletteColor( pAcc->GetPixel( 0, 0 ) );
		else
			aCol = pAcc->GetPixel( 0, 0 );

		aBmp.ReleaseAccess( pAcc );
	}

	return aCol;
*/
}

