/*************************************************************************
 *
 *  $RCSfile: fuslshow.hxx,v $
 *
 *  $Revision: 1.11 $
 *
 *  last change: $Author: hr $ $Date: 2003/04/28 17:42:56 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/


#ifndef _SD_FUSLSHOW_HXX
#define _SD_FUSLSHOW_HXX

#ifndef _COM_SUN_STAR_PRESENTATION_ANIMATIONEFFECT_HPP_
#include <com/sun/star/presentation/AnimationEffect.hpp>
#endif
#ifndef _COM_SUN_STAR_PRESENTATION_FADEEFFECT_HPP_
#include <com/sun/star/presentation/FadeEffect.hpp>
#endif
#ifndef _COM_SUN_STAR_PRESENTATION_ANIMATIONSPEED_HPP_
#include <com/sun/star/presentation/AnimationSpeed.hpp>
#endif

#include <svtools/lstner.hxx>
#ifndef _SVDPAGE_HXX //autogen
#include <svx/svdpage.hxx>
#endif
#ifndef _TIME_HXX //autogen
#include <tools/time.hxx>
#endif
#ifndef _TIMER_HXX //autogen
#include <vcl/timer.hxx>
#endif
#ifndef _WRKWIN_HXX //autogen
#include <vcl/wrkwin.hxx>
#endif
#ifndef _IMAGE_HXX //autogen
#include <vcl/image.hxx>
#endif
#ifndef _SOUND_HXX //autogen
#include <vcl/sound.hxx>
#endif
#ifndef _SD_SHOWWIN_HXX
#include "showwin.hxx"
#endif
#ifndef _SD_FUPOOR_HXX
#include "fupoor.hxx"
#endif
#ifndef _SD_ANMDEF_HXX
#include "anmdef.hxx"
#endif
#ifndef _SD_ANMINFO_HXX
#include "anminfo.hxx"
#endif
#ifndef _SD_MOVEDEF_HXX
#include "movedef.hxx"
#endif
#ifndef _SD_FADEDEF_H
#include "fadedef.h"
#endif

class PushButton;
class Button;
class SdrTextObj;
class SdrRectObj;
class SdrGrafObj;
class Fader;
class SdBitmapMover;
class SdPage;
class Sound;			   // fuer die, die Sound "rausdefiniert" haben
class SvInPlaceClientMemberList;
class OutlinerParaObject;
class SdrPaintInfoRec;
class ExtOutputDevice;
class DrawPortionInfo;
struct SdrPaintProcRec;
class OutlinerInfo;
class ShowView;
class SfxItemSet;
class VirtualDevice;
class SdrObject;
class SdrView;
class SdrAttrObj;
class BitmapEx;
class Marker;
class SvtSaveOptions;
class SdrAttrObj;
class SdCustomShow;

// -----------
// - Defines -
// -----------

#define PAGE_NO_END 		65535
#define PAGE_NO_SOFTEND		(PAGE_NO_END - 1)
#define PAGE_NO_PAUSE 		(PAGE_NO_SOFTEND - 1)
#define PAGE_NO_FIRSTDEF	PAGE_NO_PAUSE // immer mit anpassen

#define PEN_THICKNESS		100
#define SLIDESHOW_MAGIC		0x12345678
#define LASER_ALL_PARAS		0xffff
#define VDEV_TOLERANCE		2

#define OBJIS_GRAFANIM( _def_obj ) ( _def_obj->ISA( SdrGrafObj ) && ( (SdrGrafObj*) _def_obj )->IsAnimated() )
#define OBJIS_TEXTANIM( _def_obj ) ( _def_obj->ISA( SdrTextObj ) && ( (SdrTextObj*) _def_obj )->IsTextAnimated() )

// -----------------
// - AnimationMode -
// -----------------

enum AnimationMode
{
	ANIMATIONMODE_SHOW,
	ANIMATIONMODE_PREVIEW,
	ANIMATIONMODE_VIEW
};

// ----------------
// - PageFadeMode -
// ----------------

enum PageFadeMode
{
    PAGE_FADE_NORMAL = 0,
    PAGE_FADE_BLACK = 1,
    PAGE_FADE_WHITE = 2
};

// ------------------
// - SdAnimPageList -
// ------------------

class SdAnimPageList : protected List
{
private:

	USHORT		mnCurPagePos;
	USHORT		mnNextPagePos;
	USHORT		mnRealNextPagePos;
	USHORT		mnPreparedPageNum;
	BOOL		mbEndlessMode;
	BOOL		mbPauseMode;
	BOOL		mbSoftendMode;
	sal_Int32	mnCurrentHidenPage;

public:

				SdAnimPageList();
				~SdAnimPageList();

	void		SetEndlessMode( BOOL bSet ) { mbEndlessMode = bSet; }
	BOOL		IsEndlessMode() const { return mbEndlessMode; }

	void		SetPauseMode( BOOL bSet ) { mbPauseMode = bSet; }
	BOOL		IsPauseMode() const { return mbPauseMode; }

	void		SetSoftendMode( BOOL bSet ) { mbSoftendMode = bSet; }
	BOOL		IsSoftendMode() const { return mbSoftendMode; }

	void		InsertPageNum( USHORT nSdPageNum ) { Insert( (void*)(ULONG) nSdPageNum, LIST_APPEND ); }

	USHORT		GetCurrentPageNum();
	USHORT		GetNextPageNum();
	USHORT		GetRealNextPageNum();

	void		JumpToHidenPage( USHORT nHidenPageNum );

	USHORT		GetFirstPageNum() { return Count() ? (USHORT)(ULONG) First() : PAGE_NO_END; }
	USHORT		GetLastPageNum() { return Count() ? (USHORT)(ULONG) Last() : PAGE_NO_END; }

	BOOL		IsPageNumIncluded( USHORT nSdPageNum );

	USHORT		CalcNextPageNum( BOOL bForward );
	BOOL		MakePageNumCurrent( USHORT nSdPageNum );

	void		SetPreparedPageNum( USHORT nSdPageNum ) { mnPreparedPageNum = nSdPageNum; }
	USHORT		GetPreparedPageNum() const { return mnPreparedPageNum; }

	void		SetStartPage( USHORT nSdPageNum );
};

// -------------------
// - SdSlowObjRecord -
// -------------------

struct SdSlowObjRecord
{
	Point		aPos;
	SdrAttrObj* pObject;
	Image*		pImage;
	BitmapEx*	pBmpEx;

				SdSlowObjRecord() : pObject( NULL ), pImage( NULL ) {}
				SdSlowObjRecord( SdrAttrObj* _pObject, const Point& _rPos ) :
					aPos( _rPos ), pObject( _pObject ), pImage( NULL ), pBmpEx( NULL ) {}
				~SdSlowObjRecord() { delete pImage; delete pBmpEx; }
};

// ----------------
// - SdChangedObj -
// ----------------

class SdChangedObj : public SfxListener
{
	virtual void 	SFX_NOTIFY( SfxBroadcaster& rBC, const TypeId& rBCType,
								const SfxHint& rHint, const TypeId& rHintType );
public:

	SdrObject*		pObject;
	Size			aMove;
	BOOL			bPosChanged;
	BOOL			bLayerChanged;
	BOOL			bDeleted;
	SdrLayerID		nLayer;

					SdChangedObj() : pObject( NULL ), bPosChanged( FALSE ),
									 bLayerChanged( FALSE ), bDeleted( FALSE ) {};
					~SdChangedObj() {}
};

// ----------------
// - SdShowStatus -
// ----------------

struct SdShowStatus
{
	SdAnimationInfo*	pInfo;
	BOOL				bShow;
	BOOL				bIsShown;
	BOOL				bDimmed;

						SdShowStatus( SdAnimationInfo* _pInfo ) :
							pInfo	( _pInfo ),
							bShow	( _pInfo->bShow ),
							bIsShown( _pInfo->bIsShown ),
							bDimmed	( _pInfo->bDimmed ) {}
};

// ---------------
// - FuSlideShow -
// ---------------

class FuSlideShow : public FuPoor
{
private:

	friend class SdMetaFile;

	SfxItemSet*     pNewAttr;		            // die Argumente der Funktion
	Timer			aTimer;
	Timer			aEscapeTimer;
	Fader*			pFader; 		            // fuer Seiten und Animationsobjekte
	SdBitmapMover*	pMover; 		            // fuer Animationsobjekte
	WorkWindow*		pWorkWindow;	            // Parent des sichtbaren Fensters
	SdShowWindow*   pShowWindow;                // das sichtbare Fenster der Show
	VirtualDevice*	pVDev;			            // zum Ueberblenden der Seiten
	VirtualDevice*	pAnmVDev;		            // fuer Animationsobjekte
	VirtualDevice*	pMskVDev;		            // fuer Animationsobjekte
	ShowView*		pShowView;		            // ueber diese View zeichnet die Drawing Engine in pVDev
	SvtSaveOptions*	pSaveOptions;	            // hold save options struct to avoid unwanted savings of modified state
	List*			pCurAnmList;	            // Liste mit Animationsobj. der akt. Seite
	List*			pNextAnmList;	            // dito fuer vorbereitete Seite
	List*			pCurAnimGraphs;             // Listen mit animierten Grafiken
	List*			pNextAnimGraphs;            
	List*			pCurControls;	            // Listen mit Controls
	List*			pNextControls;
	List			aChangedList;	            // Liste mit Objecten, die geaendert wurden
	SdrRectObj* 	pLayoutText;	            // zu animierender Gliederungstext
	SdrRectObj* 	pLayoutClone;	            // Clone dieses Objekts
	PolyPolygon*    pLayoutClip;                // Clipping fuer LayoutClone
	BitmapEx*		pLayoutBmpEx;               // BitmapEx as Substitute for LayoutText
	SdrRectObj*		pCompoundText;
	BitmapEx*		pTopLayer;		            // TopLayer fuer Lasereffekt
	Point           aLaserObjPos;               // Position des Objekts mit dem Lasereffekt
	ULONG			nParaPos;		            // Position des naechsten darzustellenden Absatzes
	ULONG			nDimPos;		            // Position des naechsten abzublendenden Absatzes
	::com::sun::star::presentation::AnimationEffect eRandomLayout;  // der fuer die Gliederung gewaehlte Zufallseffekt (NONE --> nicht beachten)
	Point			aCurTextOrigin; 		    // Textursprung des akt. Absatzes
	Point			aCurTextOrigiWorld;	        // dito in Weltkoordinaten
	SdrObject*      pDimObject;                 // abzublendendes Objekt (NULL moeglich)
	SdrObject*      pHideObject;                // zu versteckendes Objekt (NULL moeglich)
	Rectangle		aDimRect;		            // Position und Groesse zum Abblenden
	Color			aDimColor;		            // Farbe fuers Abblenden
	::com::sun::star::presentation::AnimationEffect eObjectEffect;	// Animationseffekt fuer das akt. Objekt
	PushButton* 	pTimeButton;
	Time			aSlideVisibleSince;         // Startzeitpunkt der Zeitnahme
	Time            aLiveModeStartTime;         // Time, the live mode has been started
	SdAnimPageList	aAnimPageList;
	USHORT			nRestorePage;		        // Seite, die nach dem Beenden der Show wieder gezeigt werden soll
	USHORT			nVisibleAffectingObjects;	// Anzahl der sichtbaren Objs, deren ClickAction die Seite beeinflussen
	Point			aPageOrigin;		        // Ursprung des gezeigten Seitenbereichs
	Size			aPageSize;			        // Groesse des gezeigten Seitenbereichs
    Size			aPresSize;		            // Size, die im Resize hereinkommt und fuer das asynchrone Resize benoetigt wird
	ULONG			nPauseTimeout;
	ULONG			nMouseClickSema;
	AnimationMode   eAnimationMode;             // Show, Preview oder View
	USHORT			nIgnoreInputSmph;	        // > 0 wenn Key-, Mouse- und Timerevents blockiert werden sollen
	Point			aLastPos;
	Point			aDownPos;
	Bitmap* 		pTimeButtonBckgnd;	        // Hintergrund des Timing-Buttons
	String			aCharBuffer;		        // zum Einsammeln von Ziffern (Dia per
	Sound*			pSound;
	Pointer 		aOldPointer;		        // falls zum Zeichnen gewechselt wurde
	Pointer 		aPencil;			        // der Pointer zum Zeichnen
	SdPage* 		pActualPage;		        // die gerade angezeigte Seite
	SdMetaFile*		pMetaFile;			        // Metafile der aktuellen Seite
	SdrObject*		pBckgndRect;		        // das Hintergrundobjekt
	Rectangle		aAnimObjsBoundRect;         // umschliessendes Rechteck aller Animationsobjekte
	List*			pSlowObjList;		        // Liste fuer SlowObjRecords (fuer Objekte, die zu langsam gezeichnet werden)
	SvInPlaceClientMemberList* pClientList;
	List*			pDrawModeWindows;	        // Liste mit Fenstern des Zeichentischs
	SdWindow*		pOldActiveWindow;	        // aktives Fenster der ViewShell
	OutlinerInfo*	pOutlInfo;
	Link            aStarBASICGlobalErrorHdl;
	ULONG           nMagic;
	ULONG			nMasterPageCacheMode;
	ULONG			nShellLockCount;
	ULONG			nPushCount;
	ULONG			nChildMask;
	ULONG			nFadeInTime;		        // system time in milliseconds when this page faded in
	ULONG			nStartShowEvt;
	ULONG			nResizeEvt;
	BOOL			bVDevEmpty : 1; 	        // ist das virtuelle Device pVDev leer?
	BOOL            bFullBckgnd : 1;            // fuer PaintLayoutClone()
	BOOL			bIsCompoundLayoutText : 1;	// wird nur innerhalb von AnimateLayoutText benoetigt, um den richtigen Effekt zu setzen
	BOOL			bGridVisible : 1;		    // Zustand des Rasters der DrawView
    BOOL            bBordVisible : 1;
    BOOL            bPageBorderVisible : 1;
	BOOL            bSetOnlineSpelling : 1;     // Muss OnlineSpelling wieder eingeschaltet werden?
	BOOL			bTerminated : 1;
	BOOL			bAnimationAllowed : 1;
	BOOL			bDestroyed : 1;
	BOOL			bReadyForNextInput : 1;
	BOOL			bDesignMode : 1;
	BOOL			bDirectionForward : 1;	    // Diareihenfolge vorwaerts?
	BOOL			bManual : 1;			    // uebersteuert Einstellung am Dia
	BOOL			bMouseVisible : 1;		    // Mauszeiger sichtbar
	BOOL			bMouseAsPen : 1;		    // Zeichnen mit Maus moeglich
	BOOL			bRehearseTimings : 1;	    // interaktive Zeitnahme
	BOOL			bAlwaysOnTop : 1;		    // immer vor anderen Apps etc.
	BOOL			bShowPauseLogo : 1;		    // immer vor anderen Apps etc.
	BOOL			bMouseIsDrawing : 1;	    // Maus zeichnet gerade
	BOOL			bAutoSaveSuppressed : 1;    	// wenn ein eingeschaltetes Autosave unterdrueckt wurde
	BOOL			bPlayFull : 1;			    // Sound vollstaendig abspielen
	BOOL			bTimerIntercepted : 1;	    // ein TimerCall wurde abgefangen
	BOOL			bIVDsFound : 1; 		    // Initially Visible Disappearing Objs
	BOOL			bNativeMode : 1;		    // TRUE: die Show bearbeitet Ereignisse, FALSE: weiterleiten an akt. Funktion
	BOOL			bInitShowStatus : 1;	    // TRUE: PaintProc initialisiert Showstatus der Animationsinfos
	BOOL			bDocChanged : 1;
	BOOL			bLockedPages : 1;		    // Seite nicht bei Klick in die Flaeche wechseln
	BOOL            bFullScreen : 1;            // True: ganzer Bildsch., False: Fenster
	BOOL            bSoftEndReached : 1;        // show terminated normally

	SdrObject*		mpDownObject;				// Stores the object the mouse was over on MouseButtonDown

					DECL_LINK( StartShowHdl, void* );
					DECL_LINK( ResizeHdl, void* );
					DECL_LINK( DestroyHdl, void* );
					DECL_LINK( PageTimeOutHdl, Timer* );
					DECL_LINK( ObjectTimeOutHdl, Timer* );
					DECL_LINK( TimeButtonTimeOutHdl, Timer* );
					DECL_LINK( TimeButtonHdl, Button* );
					DECL_LINK( EscapeHdl, Timer* );
					DECL_LINK( SoundHasStoppedHdl, void * );
					DECL_LINK( PaintProc, SdrPaintProcRec * );
					DECL_LINK( DrawPortionHdl, DrawPortionInfo* );
					DECL_LINK( ReadyForNextInputHdl, void* );

	::com::sun::star::presentation::FadeEffect		EffectAToF(::com::sun::star::presentation::AnimationEffect eEffect);
	MoveSpeed		SpeedAToM(::com::sun::star::presentation::AnimationSpeed eSpeed);
	FadeSpeed		SpeedAToF(::com::sun::star::presentation::AnimationSpeed eSpeed);

	::com::sun::star::presentation::AnimationEffect RandomAnimationEffect(BOOL bShow) const;

	void			DoPageFade( PageFadeMode ePageFadeMode = PAGE_FADE_NORMAL );
	void			StopShow();
	ULONG			HideChildWindows();
	void			ShowChildWindows( ULONG nShowMask );

	void			FindSpecialObjects( const SdrPage* pPage, BOOL& rEnableOutput );
	void			PrepareForPage( SdPage* pPage, BOOL bInitAnimObjs );
	void			SetPaintModes(SdrView* pSourceView, SdrView* pTargetView, ExtOutputDevice* pXOut, SdrPaintInfoRec* pPaintInfoRec);

	BOOL			Animate();
	BOOL			AnimateLayoutText();
	BOOL			AnimateObject(SdrObject* pSubstitute = NULL);
	BOOL            CompoundEffect();

	BOOL			Dim(SdrAttrObj* pObject, Point aPos, const Color& rDimColor);
	void			DimLayoutParagraph();
	void			DimParas(SdrTextObj* pTextObj, ULONG nFromPara, ULONG nToPara, Color* pColor = NULL);
	void			CreateMarkerMetaFile( SdPage* pPage, BOOL bEnableOutput = FALSE );

	void			StartSound(const String& rSound);

	void			DeleteClientList();
	BOOL			DoVerb(SdrObject* pObject, USHORT nVerb);
	void			ShowPlugIns();

	BOOL			IsAdvanceEvent(const Point& rDown, const Point& rUp) const;

	BOOL			AffectsOwnPage(SdrObject* pObject);
	BOOL			PerformAction(SdrObject* pActionObject);
	BOOL			AnimateNamedObject(const String& rObjectName);
	BOOL			HideOrVanishObject( SdrObject* pActionObject, BOOL bHide );

	BOOL			IsSlowObj(SdrAttrObj* pObject) const;
	BOOL			IsAlphaObj(SdrAttrObj* pObject) const;
	BOOL			CreateSlowObjRecord(SdrAttrObj* pObject);
	SdSlowObjRecord* GetSlowObjRecord(SdrAttrObj* pObject);
	void			ClearSlowObjList();

	BOOL			LaserEffect(SdrRectObj* pObject, USHORT nPara, const Point& rStart);

	void			LockDrawViewShell();
	void			UnlockDrawViewShell( BOOL bUnlockFull );

	void			HandleError( const USHORT nStringId );
	void			CreatePageList( BOOL bAll, BOOL bStartWithActualPage, const String& rPresPage );
	void			ResortAnmList( List& rAnmList );

	void			SetAnimationOwnerState( SdrView* pOwnerView, BOOL bShowIsOwner );
	void			UpdateVDevWithAnimations();
	void			DrawOrStartAnimation( SdrObject* pObj, OutputDevice* pOut, BOOL bStart, BOOL bTextObjs );

	void			RepaintVDev( SdrPage* pRepaintPage, BOOL bOnlyMaster );
	SdViewShell*	GetDrawViewShellForShow() const;

	BOOL			CreateTopLayer( OutputDevice* pOut, const Marker& rStartMarker, const Marker& rEndMarker );
	void			InitShowStatus( SdAnimationInfo* pInfo );
	BitmapEx		CreateReplacement( SdrObject* pObj, ExtOutputDevice* pOut );
	
	static Color	GetVDevColor( const Color& rColor );

	virtual			~FuSlideShow();

public:

					TYPEINFO();

					FuSlideShow(SdViewShell* pViewSh, SdWindow* pWin, SdView* pView,SdDrawDocument* pDoc, SfxRequest& rReq);
	virtual void	Destroy( BOOL bDelete = TRUE );
	
					// Mouse- & Key-Events
	virtual BOOL	KeyInput(const KeyEvent& rKEvt);
	virtual BOOL	MouseMove(const MouseEvent& rMEvt);
	virtual BOOL	MouseButtonUp(const MouseEvent& rMEvt);
	virtual BOOL	MouseButtonDown(const MouseEvent& rMEvt);
	virtual BOOL	Command(const CommandEvent& rCEvt);
	virtual BOOL	RequestHelp(const HelpEvent& rHEvt);
	virtual void	Paint(const Rectangle& rRect, SdWindow* pWin);
	virtual void	ReceiveRequest(SfxRequest& rReq);
	virtual void	Activate(); // Function aktivieren
	virtual void	Deactivate(); // Function deaktivieren

	void			CreateLayoutClone();

	void			JumpToPage( USHORT nNewPage );
	void			JumpToBookmark(const String& rBookmark);
	void			PaintDimmedObject( SdrAttrObj* pObject, OutputDevice* pOut, const Color& rDimColor, BOOL bIgnoreTransparency );
	void			PaintLayoutClone(OutputDevice* pOut);

	BOOL			AdjustAnmVDev( const Rectangle& rObjRect, const Color& rBackground );

	void			StartShow();

	void			SetFullScreen(BOOL bFlScr) { bFullScreen = bFlScr; }
	BOOL			IsFullScreen() const { return bFullScreen; }
	BOOL			IsLivePresentation() const { return !bNativeMode; }
	BOOL			IsDrawingPossible() const { return bMouseAsPen; }
	BOOL			IsAlwaysOnTop() const { return bAlwaysOnTop; }
	BOOL			IsAnimationAllowed() const { return bAnimationAllowed; }
	BOOL			IsSoundPlaying() const { return( pSound && pSound->IsPlaying() ); }
	BOOL			IsSoundPlayFull() const { return bPlayFull; }
	ULONG			GetMasterPageCacheMode() const { return nMasterPageCacheMode; }
	AnimationMode   GetAnimationMode() const { return eAnimationMode; }
	SdrRectObj*		GetLayoutText() const { return pLayoutText; }
	void			EndTextEdit(SdrTextObj* pTextObj);
	USHORT			GetCurrentPage() { return aAnimPageList.GetCurrentPageNum(); }
	USHORT			GetFirstPage() { return aAnimPageList.GetFirstPageNum(); }
	USHORT			GetLastPage() { return aAnimPageList.GetLastPageNum(); }
	BOOL			IsEndless() const { return aAnimPageList.IsEndlessMode(); }

	void			Terminate();
	BOOL			IsTerminated() const { return nMagic != SLIDESHOW_MAGIC; }

	void			InitPageModify();

	BOOL			Resize(const Size& rNewSize);
	BOOL			IsInputLocked() const { return nIgnoreInputSmph > 0; }

	void            SetAnimationMode(AnimationMode eMode, SdShowWindow* pWindow);
	BOOL			AnimatePage();
	BOOL			HideAndAnimateObject(SdrObject* pObject);
	BOOL			HasAction(SdrObject* pObject);
	SdrObject*		OverObject(const Point& rPos);
	void			StopTextOrGraphicAnimation( SdrObject* pObject, BOOL bAll );

	const SdShowWindow* GetShowWindow() const { return pShowWindow; }
	ShowView*		GetShowView() const { return pShowView; }
	SdPage*			GetActualPage() const { return pActualPage; }

	void			Reschedule();
};

#endif		// _SD_FUSLSHOW_HXX
