/*************************************************************************
 *
 *  $RCSfile: instpath.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: ok $ $Date: 2001/09/05 13:08:28 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef _SETUP_INSTPATH_HXX
#define _SETUP_INSTPATH_HXX

#ifndef _SV_BUTTON_HXX //autogen
#include <vcl/button.hxx>
#endif
#ifndef _SV_FIXED_HXX //autogen
#include <vcl/fixed.hxx>
#endif
#ifndef _SV_DIALOG_HXX //autogen
#include <vcl/dialog.hxx>
#endif

#ifndef _SISYS_HXX
#include <sifsys.hxx>
#endif

#ifndef _SV_EDIT_HXX //autogen
#include <vcl/edit.hxx>
#endif

#ifndef _STDCTRL_HXX //autogen
#include <svtools/stdctrl.hxx>
#endif

#ifndef _SV_LSTBOX_HXX //autogen
#include <vcl/lstbox.hxx>
#endif

#include "simode.hxx"

class SiEnvironment;
class SiModule;

// class SetupDriveBox ---------------------------------------------------

class SetupDriveBox : public ListBox
{
public:
	SetupDriveBox( Window* pParent, const ResId& rResId ) :
		ListBox( pParent, rResId ) {}

	virtual void KeyInput( const KeyEvent& rKEvent );
};

// class SetupInstallPathDialog ------------------------------------------

class SetupInstallPathDialog : public ModalDialog
{
private:
	#if defined(WIN) || defined(OS2) || defined(WNT)
	FixedText    	m_aDriveText;
	SetupDriveBox  	m_aDriveBox;
	char			m_cSelDrive;
	#endif

	FixedText    	m_aPathText;
	Edit         	m_aPathEdit;
	PushButton		m_aBrowseBtn;
	OKButton		m_aOKBtn;
	CancelButton	m_aCancelBtn;

	FixedText    	m_aInfo1Text;
	FixedText    	m_aInfo2Text;
	FixedText    	m_aInfo3Text;
	FixedInfo    	m_aSize1Text;
	FixedInfo    	m_aSize2Text;
	FixedInfo    	m_aTemp1Text;
	FixedInfo    	m_aTemp2Text;
	FixedInfo    	m_aSystem1Text;
	FixedInfo    	m_aSystem2Text;

	ByteString			m_aSysStr;

	SiEnvironment   *m_pEnv;
	SiModule const*  m_pModule;
	SiInstallMode	 m_eInstallMode;
	BOOL			 m_bScanRemoveableDisks;
	ULONG		     m_lUsedSize;
	ULONG		     m_lTempSize;
	ULONG		     m_lSystemSize;
	ULONG			 m_lClusterSize;
	ULONG			 m_lClusterSizeSystem;

	void RecalcSize(SiDirEntry const&);
	void UpdateDrives();
	void UpdateSize();

	DECL_LINK( BrowseHdl, Button* );
	DECL_LINK( OKHdl, Button* );
	DECL_LINK( CancelHdl, Button* );
	DECL_LINK( SelectHdl, SetupDriveBox* );

protected:
	virtual void	Activate();

public:
	SetupInstallPathDialog
	(
		Window		 *pParent,
		SiEnvironment*,
		ByteString   const& aProgramName,
		SiModule const*	pModule,
		SiInstallMode	eInstallMode,
		BOOL		    bScanRemoveableDisks
	);
};


#endif
