/*************************************************************************
 *
 *  $RCSfile: textani.hxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:50:55 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef _TEXTANI_HXX
#define _TEXTANI_HXX

#ifndef _SV_VIRDEV_HXX //autogen
#include <vcl/virdev.hxx>
#endif

#ifndef _SV_TIMER_HXX //autogen
#include <vcl/timer.hxx>
#endif

/*************************************************************************

Beschreibung
============

Start() / Stop()

Startet oder Stopt eine Textanimation (wie Animation).

--------------------------------------------------------------------------

SetMode()

TAM_SCROLL          - Von StartPos bis Text nicht mehr zu sehen
TAM_SLIDE           - Von StartPos bis gegenueberliegende Kante
TAM_ALTERNATE       - Zwischen den Seiten laufen (bounds)
					  In diesem Fall wird StartPos ignoriert und
					  Direction gibt die Startrichtung vor.

--------------------------------------------------------------------------

SetStartPos()

TRUE                - Text Outside starten
FALSE               - Text Inside starten

--------------------------------------------------------------------------

SetDirection()

TRUE                - von rechts nach links (bei gedrehtem Text entsprechend)
FALSE               - von link nach rechts (bei gedrehtem Text entsprechend)

--------------------------------------------------------------------------

SetVAlign()

TAA_TOP             - Text haengt an der oberen Kante
TAA_MIDDLE          - Text haengt in der mitte
TAA_BOTTOM          - Text haengt in der unteren Kante

--------------------------------------------------------------------------

SetLoop()

Anzahl der Loops. -1 bedeutet Endlos.

--------------------------------------------------------------------------

SetScrollAmount()

Anzahl der Steps pro ScrollDelay in Pixeln.

--------------------------------------------------------------------------

SetScrollDelay()

Scrollgeschwindigkeit in Pixeln.

--------------------------------------------------------------------------

SetMetaFile()

Setzt das Metafile, welches laufen soll. Wenn dieses gesetzt wird, wird
der gesetze Text und der gesetzte Font ignoriert. Am MetaFile muss
der entsprechende MapMode und die entsprechende Groesse gesetzt werden.
Die Groesse muss positiv sein und darf die Orientation nicht beruecksichtigen.
Der MapMode darf keinen Origin aufweisen. Das MetaFile muss zum Punkt 0,0
aufgezeichnet werden und bei einer entsprechenden Drehung muessen die
Werte negativ sein. Also Punkt 0,0 entspricht der Startposition wie bei einer
Textausgabe mit der entsprechenden LineOrientation.

Zusaetzlich kann bei SetMetaFile die Orientation mit uebergeben werden,
welche 0, 900, 1800 und 2700 10tel-Grad sein darf.

--------------------------------------------------------------------------

SetText()

Setzt den Scroll-Text.

--------------------------------------------------------------------------

SetFont()

Setzt den Font. Alle Attribute werden ausgewertet. Ausser bei Orientation
wird nur 0, 900, 1800 und 2700 10tel-Grad unterstuetzt.

Wenn beim Font keine Hoehe angegeben wird, wird diese automatisch berechnet.
Und zwar so, das der Font in die uebergebene Groesse bei Start passt.
Ansonsten wird die Fontgroesse in logischen Einheiten zum OutputDevice
angegeben.

--------------------------------------------------------------------------

SetBackground()

Setzt den Hintergrund. Wenn Brush transparent ist, wird auch vor einem
beliebigen Hintergrund transparent gescrollt. Ansonsten wird der Hinter-
grund mit der Brush geloescht. In diesem Fall erfolgt die Ausgabe dann auch
schneller.

**************************************************************************/

// -----------------
// - ImpTextAInfo -
// -----------------

struct ImpTextAInfo
{
	Point           aStartPos;
	Size            aStartSize;
	long            nExtraData;
	OutputDevice*   pOutDev;
	Point           aOffset;
	Point           aOff1;
	Point           aOff2;
	long            nItemHeight;
	long            nCurLoop;
	VirtualDevice   aBackground;
	VirtualDevice   aVirDev;
	BOOL            bNew;
	BOOL            bNewBackground;
	BOOL            bDraw;
	BOOL            bDrawAll;
	BOOL            bDirection;
};

DECLARE_LIST( ImpTextAInfoList, ImpTextAInfo* );

// -----------------------
// - TextAnimation-Types -
// -----------------------

#define TEXTANIMATION_DELAY         16

enum TextAnimationMode { TAM_SCROLL, TAM_SLIDE, TAM_ALTERNATE };
enum TextAnimationVAlign { TAA_TOP, TAA_MIDDLE, TAA_BOTTOM };

// -----------------
// - TextAnimation -
// -----------------

class TextAnimation
{
private:
	ImpTextAInfoList*       pInfoList;
	GDIMetaFile*            pMtf;
	ByteString                  aText;
	Pen                     aNullPen;
	Font                    aFont;
	Brush                   aBackBrush;
	Timer                   aTimer;
	ULONG                   nLastTime;
	long                    nLoop;
	long                    nAmount;
	long                    nDelay;
	short                   nMtfOrient;
	TextAnimationMode       eMode;
	TextAnimationVAlign     eVAlign;
	BOOL                    bDirection;
	BOOL                    bStartPos;
	BOOL                    bIsInAnimation;
	BOOL                    bHorz;
	BOOL                    bUp;
	Link                    aNotifyLink;
	Link                    aReadyLink;

	short                   ImpNewOrientation( short nOrientation );
	long                    ImpCalcFontHeight( OutputDevice* pOutDev, const Size& rSize );
	Point                   ImpCalcPoint( const Point& rPoint, const Size& rSize,
										  long nItemHeight );
	void                    ImpStart();
	void                    ImpNew();
	void                    ImpStep();
	void                    ImpDraw();
							DECL_LINK( ImpStepHdl, void* );

public:
							TextAnimation();
							~TextAnimation();

	void                    Start( OutputDevice* pOutDev,
								   const Point& rDestPt, const Size& rDestSize,
								   long nExtraData = 0 );
	void                    Stop( OutputDevice* pOutDev = NULL,
								  long nExtraData = 0 );
	BOOL                    IsInAnimation() const { return bIsInAnimation; }
	VirtualDevice* 			GetFirstBackground();

	void                    SetMode( TextAnimationMode eNewMode );
	TextAnimationMode       GetMode() const { return eMode; }

	void                    SetStartPos( BOOL bNewPos = TRUE );
	BOOL                    GetStartPos() const { return bStartPos; }

	void                    SetDirection( BOOL bNewDirection = TRUE );
	BOOL                    GetDirection() const { return bDirection; }

	void                    SetVAlign( TextAnimationVAlign eNewVAlign );
	TextAnimationVAlign     GetVAlign() const { return eVAlign; }

	void                    SetLoop( long nNewLoop = -1 ) { nLoop = nNewLoop; }
	long                    GetLoop() const { return nLoop; }

	void                    SetScrollAmount( long nNewAmount = 1 ) { nAmount = nNewAmount; }
	long                    GetScrollAmount() const { return nAmount; }

	void                    SetScrollDelay( long nNewDelay = TEXTANIMATION_DELAY ) { nDelay = nNewDelay; }
	long                    GetScrollDelay() const { return nDelay; }

	void                    SetMetaFile( GDIMetaFile* pMetaFile, short nOrientation = 0 );
	GDIMetaFile*            GetMetaFile() const { return pMtf; }
	short                   GetMetaFileOrientation() const { return nMtfOrient; }

	void                    SetText( const ByteString& rText );
	const ByteString&           GetText() const { return aText; }

	void                    SetFont( const Font& rFont );
	const Font&             GetFont() const { return aFont; }

	void                    SetBackground( const Brush& rBrush ) { aBackBrush = rBrush; }
	const Brush&            GetBackground() const { return aBackBrush; }

	void                    SetNotifyHdl( const Link& rLink ) { aNotifyLink = rLink; }
	const Link&             GetNotifyHdl() const { return aNotifyLink; }

	void                    SetReadyHdl( const Link& rLink ) { aReadyLink = rLink; }
	const Link&             GetReadyHdl() const { return aReadyLink; }

	ImpTextAInfoList*       GetAInfoList() { return pInfoList; }
};

#endif // _TEXTANI_HXX
