/*************************************************************************
 *
 *  $RCSfile: unixpath.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: ok $ $Date: 2001/09/05 13:15:57 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

// include ---------------------------------------------------------------

#include "dialog.hrc"
#include "unixpath.hrc"
#include "unixpath.hxx"

// class SetupInstallPathDialog ------------------------------------------

SetupInstallPathDialog::SetupInstallPathDialog( Window *pParent, ByteString const& aProgramName,
												USHORT nIDO, USHORT nIDC, USHORT nIDOT ) :

	ModelessDialog( pParent, ResId( DLG_INSTALLPATHDLG ) ),

	aBinText		( this, ResId( FT_BIN ) ),
	aBinEdit		( this, ResId( ED_BIN ) ),
	aBinButton		( this, ResId( BTN_BIN ) ),
	aDataText		( this, ResId( FT_DATA ) ),
	aDataEdit		( this, ResId( ED_DATA ) ),
	aDataButton		( this, ResId( BTN_DATA ) ),
	aOKButton		( this, ResId( BTN_OK_UNIXPATH ) ),
	aCancelButton	( this, ResId( BTN_CANCEL_UNIXPATH ) ),
	aInfoText		( this, ResId( FT_INFO_UNIXPATH ) ),

	nIDOK    ( nIDO  ),
	nIDCancel( nIDC  ),
	nIDOKText( nIDOT )

{
	FreeResource();

	SetupScript& rScript = SETUP_SCRIPT();
	Link aLink = LINK( this, SetupInstallPathDialog, PathHdl );
	aBinButton.SetClickHdl( aLink );
	aDataButton.SetClickHdl( aLink );
	aOKButton.SetClickHdl( LINK( this, SetupInstallPathDialog, OKHdl ) );
	aCancelButton.SetClickHdl(
		LINK( this, SetupInstallPathDialog, CancelHdl ) );

	// set ok button text if new
	if ( nIDOKText )
		aOKButton.SetText( ByteString( ResId( nIDOKText ) ) );

	ByteString sTxt = aProgramName;
	sTxt += ByteString( ResId( STR_DLG_TITLE ) );
	SetText( sTxt );
	Show();
}

// -----------------------------------------------------------------------

IMPL_LINK( SetupInstallPathDialog, PathHdl, Button*, pBtn )
{
	PathDialog aDlg( this, WB_SVLOOK );

	if ( &aBinButton == pBtn )
		aDlg.SetPath( aBinEdit.GetText() );
	else
		aDlg.SetPath( aDataEdit.GetText() );

	if ( aDlg.Execute() == RET_OK )
	{
		if ( &aBinButton == pBtn )
			aBinEdit.SetText( aDlg.GetPath() );
		else
			aDataEdit.SetText( aDlg.GetPath() );
	}
	return 0;
}

// -----------------------------------------------------------------------

IMPL_LINK( SetupInstallPathDialog, OKHdl, Button*, EMPTYARG )
{
	SetupScript& rScript = SETUP_SCRIPT();
	SiDirEntry aPath( aBinEdit.GetText() );
	rScript.SetBinPath( aPath.GetFull() );
	aPath = aDataEdit.GetText();
	rScript.SetDestPath( aPath.GetFull() );

//!!! Abfrage, ob der Plattenplatz reicht kommt sp"ater

	Application::PostUserEvent( nIDOK, 0 );
	return 0;
}

// -----------------------------------------------------------------------

IMPL_LINK_INLINE_START( SetupInstallPathDialog, CancelHdl, Button*, EMPTYARG )
{
	Application::PostUserEvent( nIDCancel, 0 );
	return 0;
}
IMPL_LINK_INLINE_END( SetupInstallPathDialog, CancelHdl, Button*, EMPTYARG )


