/*************************************************************************
 *
 *  $RCSfile: xmlprsr.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: hr $ $Date: 2003/03/27 11:16:16 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
 
#ifndef _XMLPRSR_HXX_
#define _XMLPRSR_HXX_

#include <external/expat/xmlparse.h>

#include <memory>

//--------------------------------------
// forward declaration
//--------------------------------------

class ISaxDocumentHandler;
class ISaxDTDHandler;
class ISaxEntityResolver;
class SaxParserImpl;

//-----------------------------------------------------
//	Simple wrapper around expat, the xml parser library
//	created by James Clark
//-----------------------------------------------------

class SaxParser  
{
public:
	/** Constructor
	*/
	SaxParser(const XML_Char* EncodingName = 0);

	SaxParser(const XML_Char* EncodingName, XML_Char NamespaceSeparator);

	/** Destructor
	*/
	~SaxParser();

	/** Parse a XML data stream
		
		@param		pXmlData
					Pointer to a buffer containing the xml data

		@param		Length
					Length of the buffer containing the xml data

		@param		IsFinal
					Indicates whether these are the last xml data
					of an xml document to parse. For very large 
					xml documents it may be usefull to read and 
					parse the document partially.

		@precond	XmlData must not be null

		@postcond	-	
		
		@throws		SaxException
					If the used Sax parser returns an error. The SaxException
					contains detailed information about the error.
	*/
	void Parse(const char* XmlData, size_t Length, bool IsFinal = true);
	
	/**	Set a document handler

		@descr		A document handler implements the interface ISaxDocumentHandler.
					The document handler receive notifications of various events
					from the sax parser for instance "StartDocument".

					The client is responsible for the life time management of
					the given document handler, that means the document handler
					instance must exist until a new one was set or until the parser
					no longer exist.

		@param		SaxDocumentHandler
					The new document handler, may be null if not interessted in
					sax parser events.

		@precond	-	

		@postcond	currently used document handler == pSaxDocumentHandler
	*/
	void SetDocumentHandler(ISaxDocumentHandler* SaxDocumentHandler);

	/**	Returns the currently used document handler or null if 
		no document handler was set before.
	*/
	ISaxDocumentHandler* GetDocumentHandler() const;

	/** Set a DTD handler 

		@descr	A DTD handler implements the interface ISaxDTDHandler.

		@param	SaxDTDHandler
				The new DTD handler or null if no DTD notifications 
				are required.

		@precond	-

		@postcond	currently used DTD handler == SaxDTDHandler
	*/
	void SetDTDHandler(ISaxDTDHandler* SaxDTDHandler);

	/** Returns the currently used DTD handler or null if
		no DTD handler was set before.
	*/
	ISaxDTDHandler* GetDTDHandler() const;

	/** Set an entity resolver 

		@descr	A entity resolver implements the interface ISaxEntityResolver.

		@param	SaxEntityResolver
				The new entity resolver or null if entity resolving is
				not required.

		@precond	-

		@postcond	currently used entity resolver == SaxEntityResolver
	*/
	void SetEntityResolver(ISaxEntityResolver* SaxEntityResolver);

	/** Returns the currently used entity resolver or null 
		if no entity resolver was set before.
	*/
	ISaxEntityResolver* GetEntityResolver() const;

	/** 
	*/
	void SetEncoding(const XML_Char* Encoding);

private:
	
	void Init();

	//####################################
	// callback functions
	//####################################

	static void XmlStartElementHandler(void* UserData, const XML_Char* name, const XML_Char** atts);
	static void XmlEndElementHandler(void* UserData, const XML_Char* name);
	static void XmlCharacterDataHandler(void* UserData, const XML_Char* s, int len);
	static void XmlCommentHandler(void* UserData, const XML_Char* Data);

	//####################################
	// member variables
	//####################################

private:
	ISaxDocumentHandler*	m_SaxDocumentHandler;	
	ISaxDTDHandler*			m_SaxDTDHandler;
	ISaxEntityResolver*		m_SaxEntityResolver;
	XML_Parser				m_XmlParser;

// prevent copy and assignment
private:
	SaxParser(const SaxParser&);
	SaxParser& operator=(const SaxParser&);	
};

#endif 

