/*************************************************************************
 *
 *  $RCSfile: AppStarterStatusNative.java,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:54:03 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

package stardiv.controller;

/**
 *
 *
 * @version    $Version: 1.0 $
 * @author     Markus Meyer
 *
 */
public class AppStarterStatusNative implements AppStarterStatus
{
	// don't change, reused in c++
    public final static   short   AwtTopWindow = 1;
    public final static   short   AwtComponent = 2;
    public final static   short   AwtApplet = 3;
    public final static   short   AwtLess = 4;
    public final static   short   DontKnow = 5;

    private long    pCppJSbxObject;

    /**
     * Create the applet viewer
     */
    public AppStarterStatusNative( long nCppHandle )
    {
        pCppJSbxObject = nCppHandle;
    }

    protected void finalize() throws Throwable
    {
        pCppJSbxObject = 0;
    }

    public void ClearNativeHandle()
    {
        pCppJSbxObject = 0;
    }

    /**
     * The AppStarter call this method, if the application
     * or the component is loaded and started.
     *
     * @param   createdObject  the object instatiated. Null if the main
     *          function was called.
     * @param   ObjectType  The type of object which was created.
     */
    public void    started( Object createdObject ) {
		java.awt.Dimension aSize = new java.awt.Dimension();
        short status = DontKnow;
        
        if ( createdObject instanceof java.awt.Window ) {
            status = AwtTopWindow;
			aSize = ((java.awt.Component)createdObject).getSize();
			if( aSize.width == 0 || aSize.height == 0 ) {
				aSize = ((java.awt.Component)createdObject).getPreferredSize();
			}
			((java.awt.Component)createdObject).setVisible( true );
		} 
		else if ( createdObject instanceof java.applet.Applet ) {
            status = AwtApplet;
			aSize = ((java.awt.Component)createdObject).getSize();
			if ( aSize.width == 0 || aSize.height == 0 ) {
				aSize = ((java.awt.Component)createdObject).getPreferredSize();
			}
	        startedNative( createdObject, status, aSize.width, aSize.height );
			((java.applet.Applet)createdObject).start();			
			return;
		} 
		else if ( createdObject instanceof java.awt.Component ) {
            status = AwtComponent;
			aSize = ((java.awt.Component)createdObject).getSize();
			if( aSize.width == 0 || aSize.height == 0 ) {
				aSize = ((java.awt.Component)createdObject).getPreferredSize();
			}
		}
        else if ( createdObject != null ) {
            status = AwtLess;
        }
        
        startedNative( createdObject, status, aSize.width, aSize.height );
    }

    /**
     * The AppStarter call this method, if the application
     * or the component cannot started or created.
     *
     * @param   ObjectType  The type of object which was created.
     */
    public void    abort( Throwable Excp )
    {
        abortNative( Excp.toString() );
    }


    public native void startedNative( Object createdObject, short status, int Width, int Height );
    public native void abortNative( String Text );
}
