/*************************************************************************
 *
 *  $RCSfile: inethist.hxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:58:51 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _INETHIST_HXX
#define _INETHIST_HXX

#ifndef _SOLAR_H
#include <tools/solar.h>
#endif

#ifndef _STRING_HXX
#include <tools/string.hxx>
#endif

#ifndef _URLOBJ_HXX
#include <tools/urlobj.hxx>
#endif

#ifndef _SFXBRDCST_HXX
#include <brdcst.hxx>
#endif

#ifndef _SFXHINT_HXX
#include <hint.hxx>
#endif

/*========================================================================
 *
 * INetURLHistory interface.
 *
 *=======================================================================*/
class INetURLHistory_Impl;
class INetURLHistory : public SfxBroadcaster
{
	/** Representation.
	*/
	INetURLHistory_Impl *m_pImpl;
	String               m_aLocation;

	/** Construction/Destruction.
	*/
	INetURLHistory (void);
	virtual ~INetURLHistory (void);

	/** Implementation.
	*/
	void NormalizeUrl_Impl   (INetURLObject &rUrl);
	void PutUrl_Impl   (const INetURLObject &rUrl);
	BOOL QueryUrl_Impl (const INetURLObject &rUrl);

	/** Not implemented.
	*/
	INetURLHistory (const INetURLHistory&);
	INetURLHistory& operator= (const INetURLHistory&);

public:
	/** GetOrCreate/Delete.
	*/
	static INetURLHistory* GetOrCreate (void);
	static void            Delete      (void);

	/** Location.
	*/
	const String& GetLocation (void) const { return m_aLocation; }
	void          SetLocation (const String &rLocation);

	/** QueryProtocol.
	*/
	BOOL QueryProtocol (INetProtocol eProto) const
	{
		return ((eProto == INET_PROT_FILE ) ||
				(eProto == INET_PROT_FTP  ) ||
				(eProto == INET_PROT_HTTP ) ||
				(eProto == INET_PROT_HTTPS)    );
	}

	/** QueryUrl.
	*/
	BOOL QueryUrl (const INetURLObject &rUrl)
	{
		if (QueryProtocol (rUrl.GetProtocol()))
			return QueryUrl_Impl (rUrl);
		else
			return FALSE;
	}

	BOOL QueryUrl (const String &rUrl)
	{
		INetProtocol eProto =
			INetURLObject::CompareProtocolScheme (rUrl);
		if (QueryProtocol (eProto))
			return QueryUrl (INetURLObject (rUrl));
		else
			return FALSE;
	}

	/** PutUrl.
	*/
	void PutUrl (const INetURLObject &rUrl)
	{
		if (QueryProtocol (rUrl.GetProtocol()))
			PutUrl_Impl (rUrl);
	}

	void PutUrl (const String &rUrl)
	{
		INetProtocol eProto =
			INetURLObject::CompareProtocolScheme (rUrl);
		if (QueryProtocol (eProto))
			PutUrl (INetURLObject (rUrl));
	}
};

/*========================================================================
 *
 * INetURLHistoryHint (broadcasted from PutUrl()).
 *
 *=======================================================================*/
DECL_PTRHINT (INetURLHistoryHint, const INetURLObject);

#endif /* _INETHIST_HXX */

