/*************************************************************************
 *
 *  $RCSfile: linelink.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 17:01:10 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

// include ---------------------------------------------------------------

#ifndef _SOLAR_H
#include <tools/solar.h>	// Max()
#endif
#pragma hdrstop

#include "linelink.hxx"

// -----------------------------------------------------------------------

void LinkLine( const SvxLineStruct& dLine,
			   const SvxLineStruct& ltLine,
			   const SvxLineStruct& lLine,
			   const SvxLineStruct& lbLine,
			   const SvxLineStruct& rtLine,
			   const SvxLineStruct& rLine,
			   const SvxLineStruct& rbLine,
			   short* dxArr )
{
	short nDx;
	short nDxDx;
	short nltW = ltLine.nLeft + ltLine.nMiddle + ltLine.nRight;
	short nlbW = lbLine.nLeft + lbLine.nMiddle + lbLine.nRight;
	short nrtW = rtLine.nLeft + rtLine.nMiddle + rtLine.nRight;
	short nrbW = rbLine.nLeft + rbLine.nMiddle + rbLine.nRight;

	if ( dLine.nRight == 0 ) // einfache Linie
	{
		dxArr[1] = 0;
		dxArr[3] = 0;

		// Linker Teil
		if ( ( lLine.nLeft != 0 ) && ( lLine.nRight == 0 ) ) // links einfache Linie
		{
			//	#46488# nicht durch durchgehend doppelte hindurchzeichnen
			//	stattdessen wie oberen Teil einer doppelten Linie behandeln
			if ( ltLine.nRight != 0 && lbLine.nRight != 0 )		// auf doppelte getroffen?
			{
				nDx = (nltW + 1) / 2;			// ist nicht 0
				nDxDx = (nltW + 1) % 2;
				dxArr[0] = nDxDx + nDx - ltLine.nRight;
			}
			else
				dxArr[0] = 0;
		}
		else
		{
			nDx = Max( nltW, nlbW ) / 2;
			nDxDx = ( Max( nltW, nlbW ) + 1 ) % 2;
			if ((nDx == 0) || (ltLine.nRight == 0) || (lbLine.nRight == 0))
			{
				if (lLine.nLeft == 0)
					dxArr[0] = nDxDx - nDx;
				else
					dxArr[0] = nDxDx + nDx;
			}
			else
				dxArr[0] = nDxDx + nDx;
		}

		// Rechter Teil
		if ((rLine.nLeft != 0) && (rLine.nRight == 0)) // rechts einfache Linie
		{
			//	#46488# nicht durch durchgehend doppelte hindurchzeichnen
			//	stattdessen wie oberen Teil einer doppelten Linie behandeln
			if ( rtLine.nRight != 0 && rbLine.nRight != 0 )		// auf doppelte getroffen?
			{
				nDx = (nrtW + 1) / 2;			// ist nicht 0
				dxArr[2] = -nDx + rtLine.nLeft;
			}
			else
				dxArr[2] = 0;
		}
		else
		{
			nDx = Max(nrtW, nrbW) / 2;
			if ((nDx == 0) || (rtLine.nRight == 0) || (rbLine.nRight == 0))
			{
				if (rLine.nLeft == 0)
					dxArr[2] = nDx;
				else
					dxArr[2] = -nDx;
			}
			else
				dxArr[2] = -nDx;
		}
	}
	else
	{
		// Linker oberer Teil
		if ((nltW == 0) || (ltLine.nRight == 0)) // Links oben keine oder einfache Linie
		{
			nDx = (nlbW + 1) / 2;
			nDxDx = (nlbW + 1) % 2;
			if (nDx == 0)
				dxArr[0] = nDxDx + nDx;
			else
				dxArr[0] = nDxDx - (nlbW / 2);
		}
		else
		{
			nDx = (nltW + 1) / 2;
			nDxDx = (nltW + 1) % 2;
			if (nDx == 0)
				dxArr[0] = nDxDx - nDx;
			else
				dxArr[0] = nDxDx + nDx - ltLine.nRight;
		}
		// Linker unterer Teil
		if ((nlbW == 0) || (lbLine.nRight == 0)) // Links unten keine oder einfache Linie
		{
			nDx = (nltW + 1) / 2;
			nDxDx = (nltW + 1) % 2;
			if (nDx == 0)
				dxArr[1] = nDxDx + nDx;
			else
				dxArr[1] = nDxDx - (nltW / 2);
		}
		else
		{
			nDx = (nlbW + 1) / 2;
			nDxDx = (nlbW + 1) % 2;
			if (nDx == 0)
				dxArr[1] = nDxDx - nDx;
			else
				dxArr[1] = nDxDx + nDx - lbLine.nRight;
		}

		// Rechter oberer Teil
		if ((nrtW == 0) || (rtLine.nRight == 0)) // Rechts oben keine oder einfache Linie
		{
			nDx = (nrbW + 1) / 2;
			if (nDx == 0)
				dxArr[2] = -nDx;
			else
				dxArr[2] = (nrbW / 2);
		}
		else
		{
			nDx = (nrtW + 1) / 2;
			if (nDx == 0)
				dxArr[2] = nDx;
			else
				dxArr[2] = -nDx + rtLine.nLeft;
		}
		// Rechter unterer Teil
		if ((nrbW == 0) || (rbLine.nRight == 0)) // Rechts unten keine oder einfache Linie
		{
			nDx = (nrtW + 1) / 2;
			if (nDx == 0)
				dxArr[3] = -nDx;
			else
				dxArr[3] = (nrtW / 2);
		}
		else
		{
			nDx = (nrbW + 1) / 2;
			if (nDx == 0)
				dxArr[3] = nDx;
			else
				dxArr[3] = -nDx + rbLine.nLeft;
		}
	}
}


