/*************************************************************************
 *
 *  $RCSfile: wizfx.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: os $ $Date: 2002/03/12 12:47:37 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _WIZFX_HXX
#define _WIZFX_HXX

#include "wizfxdlg.hxx"
#include "wizgo.hxx"
#ifndef _WIZCFG_HXX
#include <wizcfg.hxx>
#endif

class FaxDialog: public WizardFaxDialog, private WizardGo
{
	WizardFaxnPage 	aPage1;
	SwFaxWizardCfg  aConfig;

public:
	FaxDialog(Window* pParent);

	virtual void Fill(USHORT StepNum, MultiOne& WinArr);
	virtual BOOL Possible(USHORT StepNum);
	virtual void Enter(USHORT StepNum);
	virtual void Leave(USHORT StepNum);

	void GetFromDef();  // Harte Defaults setzen
	void GetFromUsr();  // Defaults von Benutzereinstellungen holen
	void GetFromIni();  // Defaults vom Inifile holen
	void InitElemUI();  // Datelistbox fuellen

	virtual void WriteToIni();
	virtual BOOL MakeDoc();

	void AbsnToUI();
	void TitlToUI();
	void ElemToUI();
	void FormToUI();    // Seitenformat

	void ArrangeObjects();
	void SetAbsnLineAnz();
	void SetEmpfLineAnz();
	void SetDatmLineAnz();
	void SetBetrLineAnz();
	void FillDocInfoList();
	String GetDocInfStr(USHORT nNum);
	BOOL   GetDocInfStrOk(USHORT nNum);
	BOOL   GetDocInfoGoDown(USHORT nNum);
	void SetElemDisable();

	void SetEventHandler();
	DECL_LINK( StyleClickHdl, RadioButton * );
	DECL_LINK( TitelModifyHdl, Edit * );
	DECL_LINK( FormatSelectHdl, ListBox * );
	DECL_LINK( LogoMFldHdl, MetricField * );
	DECL_LINK( LogoRBtnHdl, RadioButton * );
	DECL_LINK( AbsnBBtnHdl, Button * );
	DECL_LINK( AbsnMFldHdl, MetricField * );
	DECL_LINK( RandMetrcModifyHdl, MetricField * );
	DECL_LINK( EditModifyHdl, Edit * );
	DECL_LINK( ATeleModifyHdl, Edit * );
	DECL_LINK( UpdateAdressHdl, PushButton *);
	DECL_LINK( EmpfModifyHdl, MultiLineEdit * );
	DECL_LINK( EmpfDBasListHdl, ListBox * );
	DECL_LINK( EmpfInsrPBtnHdl, PushButton * );
	DECL_LINK( EmpfNewLPBtnHdl, PushButton * );
	DECL_LINK( EmpfFeldListHdl, ListBox * );
	DECL_LINK( ETeleSelectHdl, ListBox * );
	DECL_LINK( ElemDatmCheckHdl, Button * );
	DECL_LINK( ElemBetrCheckHdl, Button * );
	DECL_LINK( ElemMiscCheckHdl, Button * );
	DECL_LINK( ElemModifyHdl, Edit * );

private:
	void InsLogo();
	void InsTitl();
	void InsDatm();
	void InsEmpf();
	void InsAbsn();
	void InsElem();
	void InsBetr();
	void CreateMacro();
	void SaveMacro();
	void InsDocInfBookmark(USHORT nElemNum);
	void SetFaxPrinter();
};

#endif  //_WIZFX_HXX


