/*************************************************************************
 *
 *  $RCSfile: tresstatewrapper.cxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: vg $ $Date: 2003/05/19 13:14:45 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

// this functions build the wrapper, to handle old function calls to rtl_tres_state
// IMPORTANT: Due to the fact that rtl_tres_state is in the sal.lib 
// you have to rename rtl_tres_state to c_rtl_tres_state
//
// return c_rtl_tres_state
// (
// 	   hRtlTestResult,
// 	   pData->length == 0 &&
// 	   ! *pData->buffer,
// 	   "New OString containing no characters",
// 	   "ctor_001"
// )

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "cppunit/Test.h"
#include "cppunit/autoregister/htestresult.h"
#include "cppunit/autoregister/callbackfunc_fktptr.h"
#include "cppunit/TestAssert.h"

#define LOAD_TRESSTATEWRAPPER_LOCAL
#include "tresstatewrapper.hxx"
#undef LOAD_TRESSTATEWRAPPER_LOCAL

#include "cppunit/tagvalues.hxx"
#include "cppunit/externcallbackfunc.hxx"

// -----------------------------------------------------------------------------
// Wrapper class for the CppUnit::Test, because the new TestResult
// expect a CppUnit::Test interface

class WrappedTest : public CppUnit::Test
{
	std::string m_sName;
public:
	WrappedTest(std::string const& _sName)
			:m_sName(_sName){}
	
    virtual                       ~WrappedTest () {}
    virtual void                  run (hTestResult pResult){}
    virtual int                   countTestCases () const {return 1;}
    virtual std::string           getName () const {return m_sName;}
    virtual std::string           toString () const {return "WrappedTest";}
};

// -----------------------------------------------------------------------------
rtl_tres_state_start::rtl_tres_state_start(hTestResult _aResult, const sal_Char* _pName)
        :m_pName(_pName),
         m_aResult(_aResult)
{
    // (pTestResult_EnterNode)(m_aResult, m_pName);
    (pCallbackFunc)( NULL, TAG_TYPE, RESULT_ENTER_NODE, TAG_RESULT_PTR, m_aResult, TAG_NODENAME, m_pName, TAG_DONE);
}
rtl_tres_state_start::~rtl_tres_state_start()
{
    // (pTestResult_LeaveNode)(m_aResult, m_pName);
    (pCallbackFunc)(NULL, TAG_TYPE, RESULT_LEAVE_NODE, TAG_RESULT_PTR, m_aResult, TAG_NODENAME, m_pName, TAG_DONE);
}

// --------------------------------- C-Wrapper ---------------------------------
typedef std::vector<rtl_tres_state_start*> rtl_tres_states;
rtl_tres_states m_StateStack;

extern "C" void c_rtl_tres_state_start(hTestResult _aResult, const sal_Char* _pName)
{
    rtl_tres_state_start* pState = new rtl_tres_state_start(_aResult, _pName);
    m_StateStack.push_back(pState);
}

extern "C" void c_rtl_tres_state_end(hTestResult _aResult, const sal_Char* _pName)
{
    // std::cout << _pName << std::endl;
    rtl_tres_state_start* pState = m_StateStack.back();

    delete pState;
    m_StateStack.pop_back();
}
// -----------------------------------------------------------------------------
// -----------------------------------------------------------------------------
// -----------------------------------------------------------------------------

// -----------------------------------------------------------------------------
// ------------------------- Wrapper for rtl_tres_state -------------------------
// -----------------------------------------------------------------------------

sal_Bool SAL_CALL c_rtl_tres_state(
    hTestResult pResult,
    sal_Bool bSuccess,
    sal_Char* pTestMsg,
    sal_Char* pFuncName)
{
    CppUnit::Test* pTest = new WrappedTest(pFuncName);
    
    sal_Int32 nValue = (pCallbackFunc)(NULL, TAG_TYPE, EXECUTION_CHECK, TAG_RESULT_PTR, pResult, TAG_NODENAME, pTest->getName().c_str(), TAG_DONE);
    if (nValue == DO_NOT_EXECUTE)
    {
        return false;
    }

    // This code is copied from CppUnit::TestCase and less adapted, to work with the
    // old test code.
    // (pTestResult_StartTest)(pResult, pTest);
    (pCallbackFunc)(NULL, TAG_TYPE, RESULT_START, TAG_RESULT_PTR, pResult, TAG_TEST_PTR, pTest, TAG_DONE);
    
    try 
    {
        CPPUNIT_ASSERT_MESSAGE( pTestMsg, bSuccess ? true : false );
        // (pTestResult_AddInfo)(pResult, pTest, "#PASSED#");
        (pCallbackFunc)(NULL, TAG_TYPE, RESULT_ADD_INFO, TAG_RESULT_PTR, pResult, TAG_TEST_PTR, pTest, TAG_INFO, "PASSED", TAG_DONE);
    }
    catch ( CppUnit::Exception &e ) 
    {
        CppUnit::Exception *copy = e.clone();
        // (pTestResult_AddFailure)( pResult, pTest, copy );
        (pCallbackFunc)( NULL, TAG_TYPE, RESULT_ADD_FAILURE, TAG_RESULT_PTR, pResult, TAG_TEST_PTR, pTest, TAG_EXCEPTION, copy, TAG_DONE );
    }
    catch ( std::exception &e ) 
    {
        //(pTestResult_AddError)( pResult, pTest, new CppUnit::Exception( e.what() ) );
        (pCallbackFunc)( NULL, TAG_TYPE, RESULT_ADD_ERROR, TAG_RESULT_PTR, pResult, TAG_TEST_PTR, pTest, TAG_EXCEPTION, new CppUnit::Exception( e.what() ), TAG_DONE );
    }
    catch (...) 
    {
        CppUnit::Exception *e = new CppUnit::Exception( "caught unknown exception" );
        // (pTestResult_AddError)( pResult, pTest, e );
        (pCallbackFunc)( NULL, TAG_TYPE, RESULT_ADD_ERROR, TAG_RESULT_PTR, pResult, TAG_TEST_PTR, pTest, TAG_EXCEPTION, e, TAG_DONE );
    }
    

    // (pTestResult_EndTest)( pResult, pTest );
    (pCallbackFunc)( NULL, TAG_TYPE, RESULT_END, TAG_RESULT_PTR, pResult, TAG_TEST_PTR, pTest, TAG_DONE );
    
    return bSuccess;
}

